/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.user;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.service.UserManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.validator.Required;

public class UserEditPage extends AbstractCrudPage implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 8197167663670294677L;

    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(UserEditPage.class);

    private List<Map<String, String>> expiresItems;

    private int expiresIndex;

    private String expires;

    private String lastLogon;

    private String name;

    private String password;

    private boolean updateRequired;

    private boolean userEnabled;

    private String expirationDate;

    private UserManagementService userManagementService;

    /**
     * @return the userManagementService
     */
    public UserManagementService getUserManagementService()
    {
        return userManagementService;
    }

    /**
     * @param userManagementService the userManagementService to set
     */
    public void setUserManagementService(
            UserManagementService userManagementService)
    {
        this.userManagementService = userManagementService;
    }

    public List<Map<String, String>> getExpiresItems()
    {
        return expiresItems;
    }

    public void setExpiresItems(List<Map<String, String>> expiresItems)
    {
        this.expiresItems = expiresItems;
    }

    /**
     * @return the expires
     */
    public String getExpires()
    {
        return expires;
    }

    /**
     * @param expires the expires to set
     */
    @Required
    public void setExpires(String expires)
    {
        this.expires = expires;
    }

    /**
     * @return the expiresIndex
     */
    public int getExpiresIndex()
    {
        return expiresIndex;
    }

    /**
     * @param expiresIndex the expiresIndex to set
     */
    public void setExpiresIndex(int expiresIndex)
    {
        this.expiresIndex = expiresIndex;
    }

    public String getLastLogon()
    {
        return lastLogon;
    }

    public void setLastLogon(String lastLogon)
    {
        this.lastLogon = lastLogon;
    }

    public String getName()
    {
        return name;
    }

    @Required
    public void setName(String name)
    {
        this.name = name;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public boolean isUpdateRequired()
    {
        return updateRequired;
    }

    public void setUpdateRequired(boolean updateRequired)
    {
        this.updateRequired = updateRequired;
    }

    public boolean isUserEnabled()
    {
        return userEnabled;
    }

    public void setUserEnabled(boolean userEnabled)
    {
        this.userEnabled = userEnabled;
    }

    /**
     * @return the expirationDate
     */
    public String getExpirationDate()
    {
        return expirationDate;
    }

    /**
     * @param expirationDate the expirationDate to set
     */
    public void setExpirationDate(String expirationDate)
    {
        this.expirationDate = expirationDate;
    }

    public String initialize()
    {
        return null;
    }

    public Class prerender()
    {
        // Check name
        if (!getUserManagementService().isUserExists(getName()))
        {
            FacesMessageUtil.addWarnMessage("could.not.find.user");
            return UserListPage.class;
        }

        // update this page
        getUserManagementService().loadPage(this);

        return null;
    }

    public String doUpdate()
    {
        try
        {
            getUserManagementService().update(this);
            FacesMessageUtil.addInfoMessage("updated.user.information",
                    new Object[] { getName() });
        }
        catch (PALAdminException e)
        {
            FacesMessageUtil.addErrorMessage(
                    "failed.to.update.user.information",
                    new Object[] { getName() });
            logger.error("Failed to update the user: " + getName(), e);
        }
        return null;
    }
}
