/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.role;


import java.io.Serializable;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.PALAdminException;
import jp.sf.pal.admin.web.CrudType;

import org.seasar.framework.log.Logger;
import org.seasar.teeda.extension.annotation.takeover.TakeOver;
import org.seasar.teeda.extension.annotation.takeover.TakeOverType;

public class RoleConfirmPage extends AbstractRolePage implements Serializable
{
    /**
     * 
     */
    private static final long serialVersionUID = 8565809646908671454L;
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger
            .getLogger(RoleConfirmPage.class);

    public String initialize()
    {
        return null;
    }

    public String prerender()
    {
        return null;
    }

    @TakeOver(type = TakeOverType.NEVER)
    public Class doFinish()
    {
        switch (getCrudType())
        {
            case CrudType.CREATE:
                try
                {
                    getRoleManagementService().insert(this);
                    FacesMessageUtil.addInfoMessage("added.new.role", new Object[]{getName()});
                }
                catch (PALAdminException e)
                {
                    FacesMessageUtil.addErrorMessage("failed.to.add.new.role", new Object[]{getName()});
                    logger.error("Failed to add a new role: "+getName(), e);
                }
                break;
            //            case CrudType.UPDATE:
            //                break;
            case CrudType.DELETE:
                try
                {
                    getRoleManagementService().delete(this);
                    FacesMessageUtil.addInfoMessage("deleted.role", new Object[]{getName()});
                }
                catch (PALAdminException e)
                {
                    FacesMessageUtil.addErrorMessage("failed.to.delete.role", new Object[]{getName()});
                    logger.error("Failed to delete a new role: "+getName(), e);
                }
                break;
            default:
                break;
        }
        return RoleListPage.class;

    }

    public boolean isComeFromList()
    {
        return getCrudType() == CrudType.READ
                || getCrudType() == CrudType.DELETE;

    }

}
