/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.role;

import jp.sf.pal.admin.service.RoleManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;

import org.seasar.teeda.extension.annotation.validator.Required;

public class AbstractRolePage extends AbstractCrudPage
{

    private String name;

    private RoleManagementService roleManagementService;

    public AbstractRolePage()
    {
        super();
    }

    public String getName()
    {
        return name;
    }

    @Required
    public void setName(String roleName)
    {
        this.name = roleName;
    }

    /**
     * @return the roleManagementService
     */
    public RoleManagementService getRoleManagementService()
    {
        return roleManagementService;
    }

    /**
     * @param roleManagementService the roleManagementService to set
     */
    public void setRoleManagementService(
            RoleManagementService roleManagementService)
    {
        this.roleManagementService = roleManagementService;
    }

}