/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.web.deployer;

import java.io.Serializable;

import javax.faces.internal.FacesMessageUtil;

import jp.sf.pal.admin.service.RepositoryManagementService;
import jp.sf.pal.admin.web.AbstractCrudPage;

public class RemoteRepositoryEditPage extends AbstractCrudPage implements
        Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -5296937640583502536L;

    private String name;

    private String configPath;

    private RepositoryManagementService repositoryManagementService;

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return the configPath
     */
    public String getConfigPath()
    {
        return configPath;
    }

    /**
     * @param configPath the configPath to set
     */
    public void setConfigPath(String configPath)
    {
        this.configPath = configPath;
    }

    /**
     * @return the repositoryManagementService
     */
    public RepositoryManagementService getRepositoryManagementService()
    {
        return repositoryManagementService;
    }

    /**
     * @param repositoryManagementService the repositoryManagementService to set
     */
    public void setRepositoryManagementService(
            RepositoryManagementService repositoryManagementService)
    {
        this.repositoryManagementService = repositoryManagementService;
    }

    public String initialize()
    {
        return null;
    }

    public Class prerender()
    {
        if (isUpdate())
        {
            if (getName() == null)
            {
                FacesMessageUtil
                        .addErrorMessage("invalid.repository.parameters");
                return RemoteRepositoryListPage.class;
            }

            getRepositoryManagementService().loadPage(this);
        }
        return null;
    }

}
