/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.security.auth.Subject;

import jp.sf.pal.admin.PALAdminConstants;

public class PALAdminUtil
{
    /**
     * @return the facesContext
     */
    private static FacesContext getFacesContext()
    {
        return FacesContext.getCurrentInstance();
    }

    public static boolean isEmpty(String s)
    {
        if (s == null)
            return true;

        if (s.trim().equals(""))
            return true;

        return false;
    }

    public static Principal getPrincipal(Subject subject, Class cls)
    {
        Principal principal = null;
        Iterator principals = subject.getPrincipals().iterator();
        while (principals.hasNext())
        {
            Principal p = (Principal) principals.next();
            if (cls.isInstance(p))
            {
                principal = p;
                break;
            }
        }
        return principal;
    }

    public static Map<String, String> createItem(String label, String value)
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("label", label);
        map.put("value", value);
        return map;
    }

    public static List<Map<String, String>> createItems(Iterator<String> items)
    {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        while (items.hasNext())
        {
            String value = items.next();
            list.add(PALAdminUtil.createItem(value, value));
        }
        return list;
    }

    public static String toStringFromList(List<String> list)
    {
        StringBuffer buf = new StringBuffer();
        for (Iterator<String> ite = list.iterator(); ite.hasNext();)
        {
            buf.append(ite.next());
            if (ite.hasNext())
            {
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static String toStringFromArray(Object[] strs)
    {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strs.length; i++)
        {
            buf.append(strs[i].toString());
            if (i + 1 < strs.length)
            {
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public static void drain(InputStream in, OutputStream out)
            throws IOException
    {
        try
        {
            byte[] buf = new byte[8192];
            int len = in.read(buf);

            while (len != -1)
            {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
            out.flush();
        }
        catch (IOException e)
        {
            throw e;
        }
        finally
        {
            try
            {
                out.close();
            }
            catch (IOException e)
            {
            }
            try
            {
                in.close();
            }
            catch (IOException e)
            {
            }
        }
    }

    public static void setPasswordToSession(String value)
    {
        getFacesContext().getExternalContext().getSessionMap().put(
                PALAdminConstants.PASSWORD, value);
    }

    public static String getPasswordFromSession()
    {
        return (String) getFacesContext().getExternalContext().getSessionMap()
                .get(PALAdminConstants.PASSWORD);
    }

    public static void removePasswordFromSession()
    {
        getFacesContext().getExternalContext().getSessionMap().remove(
                PALAdminConstants.PASSWORD);
    }
}
