/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.admin;

public class PALAdminConstants
{
    public static final boolean DEBUG = false;

    public static final String PREFIX = "jp.sf.pal.admin.";

    public static final String CPS_SECURITY_PROVIDER_COMPONENT = "cps:SecurityProvider";

    public static final String SECURITY_PROVIDER_COMPONENT = PREFIX
            + "SecurityProvider";

    public static final String USER_MANAGER_COMPONENT = PREFIX + "UserManager";

    public static final String ROLE_MANAGER_COMPONENT = PREFIX + "RoleManager";

    public static final String GROUP_MANAGER_COMPONENT = PREFIX
            + "GroupManager";

    public static final String PROFILER_COMPONENT = PREFIX + "Profiler";

    public static final String PAGE_MANAGER_COMPONENT = PREFIX + "PageManager";

    public static final String APPLICATION_SERVER_MANAGER_COMPONENT = PREFIX
            + "ApplicationServerManager";

    public static final String PORTLET_REGISTRY_COMPONENT = PREFIX
            + "PortletRegistry";

    public static final String PORTLET_FACTORY_COMPONENT = PREFIX
            + "PortletFactory";

    public static final String DEPLOYMENT_MANAGER_COMPONENT = PREFIX
            + "DeploymentManager";

    public static final String PREVIOUS_PAGE_NUMBER = "previousPageNumber";

    public static final String NEXT_PAGE_NUMBER = "nextPageNumber";

    //TODO move to portlet.xml file
    public static final int DEFAULT_PAGER_LIMIT_SIZE = 25;

    public static final String DEFAULT_TEMPLATE_FOLDER = "/_user/template/";

    public static final String USER_CREDENTIAL_ACTIVE = PREFIX + "Active";

    public static final String USER_CREDENTIAL_EXPIRED = PREFIX + "Expired";

    public static final String USER_CREDENTIAL_EXTEND = PREFIX + "Extend";

    public static final String USER_CREDENTIAL_EXTEND_UNLIMITED = PREFIX
            + "ExtendUnlimited";

    //TODO move to portlet.xml file
    public static final String LOCATOR_PAGE = "page";

    //TODO move to portlet.xml file
    public static final String LOCATOR_MENU = "menu";

    public static final int PORTLET_APPLICATION_TYPE_WEBAPP = 0;

    public static final int PORTLET_APPLICATION_TYPE_LOCAL = 1;

    public static final int PORTLET_APPLICATION_STATUS_RUNNING = 1;

    public static final int PORTLET_APPLICATION_STATUS_STOPPED = 0;

    public static final String PORTLET_MANAGEMENT_ACTION_START = "start";

    public static final String PORTLET_MANAGEMENT_ACTION_STOP = "stop";

    public static final String PORTLET_MANAGEMENT_ACTION_UNDEPLOY = "undeploy";

    public static final String PORTLET_MANAGEMENT_ACTION_DELETE = "delete";

    public static final String DEPLOYMENT_STATUS = PREFIX + "DeploymentStatus";

    public static final String LOCAL_TEMP_FILENAME_PREFIX = "uploadedPortletApplication";

    public static final String LOCAL_TEMP_FILENAME_SUFFIX = ".war";

    public static final String PASSWORD = PREFIX + "Password";
}
