/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sf.pal.weather ;

import java.io.IOException;
import java.util.* ;
import javax.portlet.*;

/**
 * Weather Portlet
 * 
 * @version $Id: WeatherPortlet.java,v 1.13 2007/02/14 11:20:31 karma Exp $
 * @author KATOH Yasufumi
 */
public class WeatherPortlet extends GenericPortlet
{
    
    //
    // Attribute Name
    //
    /** Attribute Name of City ID */
    public static final String CITYID_ATTR_NAME = "id" ;
    
    /** Attribute Name of Weather */
    public static final String WEATHER_ATTR_NAME = "weather" ;
    
    /** Attribute Name of CityMap */
    public static final String CITYMAP_ATTR_NAME = "city";
    
    /** Attribute Name of Today's Weather */
    public static final String TODAY_WEATHER_ATTR_NAME = "todayweather" ;
    
    /** Attribute Name of Tomorrow's Weather */
    public static final String TOMORROW_WEATHER_ATTR_NAME = "tomorrowweather" ;
    
    /** Parameter Name of The Day After Tomorror (checkbox) */
    public static final String DAYAFTERTOMORROW_WEATHER_ATTR_NAME = "dayaftertomorrowweather";
    
    /** Parameter Name of Description Display Mode (checkbox) */
    public static final String DESCRIPTIONDISPMODE_ATTR_NAME = "description";
    
    public static final String IS_TODAY_WEATHER_DISPLAYED_ATTR_NAME = "istodaydisplay";
    public static final String IS_TOMORROW_WEATHER_DISPLAYED_ATTR_NAME = "istomorrowdisplay";
    public static final String IS_DAYAFTERTOMORROW_WEATHER_DISPLAYED_ATTR_NAME = "isdayaftertomorrowdisplay";
    
    //
    // Parameter Name
    //
    /** Parameter Name of City ID (select menu) */
    public static final String CITY_PARAM_NAME = "city" ;

    /** Parameter Name of Today (checkbox) */
    public static final String TODAY_PARAM_NAME = "today" ;
    
    /** Parameter Name of Tomorrow (checkbox) */
    public static final String TOMORROW_PARAM_NAME = "tomorrow" ;
    
    /** Parameter Name of The Day After Tomorror (checkbox) */
    public static final String DAYAFTERTOMORROW_PARAM_NAME = "dayaftertomorrow";
    
    /** Parameter Name of Description Display Mode (checkbox) */
    public static final String DESCRIPTIONDISPMODE_PARAM_NAME = "description";
    
    //
    // Parameter Value
    //
    /** Parameter Value of Default City ID */
    public static final String CITY_PARAM_DEFAULT_VALUE = "default" ;
    
    /** Parameter Value of Today/Tomorrow Checkbox */
    public static final String DAY_PARAM_ON_VALUE = "on" ;
    
    /** Parameter Value of Overview display mode checkbox */
    public static final String DESCRIPTIONDISPMODE_ON_VALUE = "on";
    
    //
    // JSP File Path
    //
    /** JSP file Path of View Mode (Display one day weather) */
    public static final String VIEW_MODE_ONE_DAY_JSP_PATH = "/WEB-INF/view/weather.jsp" ;
    
    /** JSP file Path of View Mode (Display 2day's Weather) */
    public static final String VIEW_MODE_TWO_DAYS_JSP_PATH = "/WEB-INF/view/twodaysview.jsp" ;
    
    /** JSP file Path of Edit Mode */
    public static final String EDIT_MODE_JSP_PATH = "/WEB-INF/view/edit.jsp" ;

    /**
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        super.init(config);
    }

    /**
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
    {
        response.setContentType("text/html");        
        PortletContext context = getPortletContext();
        
        String id = request.getParameter(CITY_PARAM_NAME) ;
        PortletPreferences  prefs = request.getPreferences() ;

        // ViewモードだけどParameterがない場合，Editモードの時はPortletPreferencesから取得
        if (id == null) {
            // PortletPreferences から表示したい都市の id を取得
            id = prefs.getValue(CITY_PARAM_NAME, null) ;
        }
        
        // WebService から天気情報を取得
        WeatherWebService webService = new WeatherWebService(id) ;
        Map cityMap = webService.getCityMap() ;
        
        // 本日の天気の取得
        Weather today_weather = null ;
        boolean dispToday
            = prefs.getValue(TODAY_PARAM_NAME, null).equals(DAY_PARAM_ON_VALUE) ;
        request.setAttribute(IS_TODAY_WEATHER_DISPLAYED_ATTR_NAME, new Boolean(dispToday));
        if (dispToday) {
            WeatherWebService todayService = new WeatherWebService(id);
            todayService.setDay(TODAY_PARAM_NAME) ;
            today_weather = todayService.getWeather() ;
            request.setAttribute(TODAY_WEATHER_ATTR_NAME, today_weather);
        }
        
        // 明日の天気の取得
        Weather tomorrow_weather = null ;
        boolean dispTomorrow
            = prefs.getValue(TOMORROW_PARAM_NAME, null).equals(DAY_PARAM_ON_VALUE) ;
        request.setAttribute(IS_TOMORROW_WEATHER_DISPLAYED_ATTR_NAME, new Boolean(dispTomorrow));
        if (dispTomorrow) {
            WeatherWebService tomorrowService = new WeatherWebService(id);
            tomorrowService.setDay(TOMORROW_PARAM_NAME) ;
            tomorrow_weather = tomorrowService.getWeather() ;
            request.setAttribute(TOMORROW_WEATHER_ATTR_NAME, tomorrow_weather);
        }
        
        // あさっての天気の取得
        Weather dayaftertomorrow_weather = null ;
        boolean dispDayAfterTomorrow
            = prefs.getValue(DAYAFTERTOMORROW_PARAM_NAME, null).equals(DAY_PARAM_ON_VALUE);
        request.setAttribute(IS_DAYAFTERTOMORROW_WEATHER_DISPLAYED_ATTR_NAME, new Boolean(dispDayAfterTomorrow));
        if (dispDayAfterTomorrow) {
            WeatherWebService dayAfterTomorrowService = new WeatherWebService(id);
            dayAfterTomorrowService.setDay(DAYAFTERTOMORROW_PARAM_NAME);
            dayaftertomorrow_weather = dayAfterTomorrowService.getWeather() ;
            request.setAttribute(DAYAFTERTOMORROW_WEATHER_ATTR_NAME, dayaftertomorrow_weather);
        }
        
        if (!dispToday) {
            if (dispTomorrow) {
                request.setAttribute(TODAY_WEATHER_ATTR_NAME, tomorrow_weather);
            } else {
                request.setAttribute(TODAY_WEATHER_ATTR_NAME, dayaftertomorrow_weather);
            }
        }
        
        request.setAttribute(CITYMAP_ATTR_NAME, cityMap) ;
        request.setAttribute(CITYID_ATTR_NAME, id) ;
        
        // 概況を表示する or しない
        boolean isDispOverview
            = prefs.getValue(DESCRIPTIONDISPMODE_PARAM_NAME, null).equals(DESCRIPTIONDISPMODE_ON_VALUE);
        request.setAttribute(DESCRIPTIONDISPMODE_ATTR_NAME, new Boolean(isDispOverview));
        
        // inclde JSP
        PortletRequestDispatcher rd = null ;
        rd = context.getRequestDispatcher(VIEW_MODE_ONE_DAY_JSP_PATH) ;
        rd.include(request, response);
    }
    
    /**
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response)
    	throws PortletException, IOException {
        
        if (request.getPortletMode().equals(PortletMode.EDIT)) {
            this.processActionForEdit(request, response) ;
        } else if (request.getPortletMode().equals(PortletMode.VIEW)) {
            this.processActionForView(request, response) ;
        }
        
    }
    
    private void processActionForView(ActionRequest request, ActionResponse response)
        throws PortletException, IOException {
        
        // 天気を表示したい都市のidの取得
        String id = request.getParameter(CITY_PARAM_NAME);
        
        // PortletPreferencesの取得
        PortletPreferences  prefs = request.getPreferences() ;
        
        // 取得する都市の指定がない場合
        if (id == null || id.equals(CITY_PARAM_DEFAULT_VALUE)) {
            id = prefs.getValue(CITY_PARAM_NAME, null) ;
        } 
        
        // パラメータのセット
        response.setRenderParameter(CITY_PARAM_NAME, id) ;
        
    }
    
    private void processActionForEdit(ActionRequest request, ActionResponse response)
        throws PortletException, IOException {
    
        // parameterの取得
        String id = request.getParameter(CITY_PARAM_NAME);
        String today = request.getParameter(TODAY_PARAM_NAME) ;
        String tomorrow = request.getParameter(TOMORROW_PARAM_NAME) ;
        String dayaftertomorrow = request.getParameter(DAYAFTERTOMORROW_PARAM_NAME);
        String descriptionDisplayMode = request.getParameter(DESCRIPTIONDISPMODE_PARAM_NAME);
    
        // PortletPreferencesの取得
        PortletPreferences  prefs = request.getPreferences() ;
    
        // 取得する都市の指定がない場合
        if (id == null || id.equals(CITY_PARAM_DEFAULT_VALUE)) {
            id = prefs.getValue(CITY_PARAM_NAME, null) ;
        }
        
        // チェックボックスにチェックがない場合
        if (today == null && tomorrow == null && dayaftertomorrow == null) {
            return ;
        }
        
        if (today == null) {
            today = "" ;
        }
        
        if (tomorrow == null) {
            tomorrow = "" ;
        }
        
        if (dayaftertomorrow == null) {
            dayaftertomorrow = "";
        }
        
        if (descriptionDisplayMode == null) {
            descriptionDisplayMode = "";
        }
        
        // パラメータのセット
        prefs.setValue(CITY_PARAM_NAME, id) ;
        prefs.setValue(TODAY_PARAM_NAME, today) ;
        prefs.setValue(TOMORROW_PARAM_NAME, tomorrow) ;
        prefs.setValue(DAYAFTERTOMORROW_PARAM_NAME, dayaftertomorrow);
        prefs.setValue(DESCRIPTIONDISPMODE_PARAM_NAME, descriptionDisplayMode);
        prefs.store() ;
    
    }
    
    /**
     * @see javax.portlet.GenericPortlet#doEdit(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    public void doEdit(RenderRequest request, RenderResponse response)
        throws PortletException, IOException {
        
        response.setContentType("text/html");
        PortletContext context = getPortletContext();
        
        // PortletPreferences から表示したい都市の id を取得
        PortletPreferences  prefs = request.getPreferences() ;
        String id = prefs.getValue(CITY_PARAM_NAME, null) ;
        String today = prefs.getValue(TODAY_PARAM_NAME, null) ;
        String tomorrow = prefs.getValue(TOMORROW_PARAM_NAME, null) ;
        String dayaftertomorrow = prefs.getValue(DAYAFTERTOMORROW_PARAM_NAME, null);
        String descriptionDisplayMode = prefs.getValue(DESCRIPTIONDISPMODE_PARAM_NAME, null);
        
        // WebService から都市Mapを取得
        WeatherWebService webService = new WeatherWebService() ;
        Map cityMap = webService.getCityMap() ;
        
        // 属性に都市Mapをセット
        request.setAttribute(CITYMAP_ATTR_NAME, cityMap) ;
        request.setAttribute(CITYID_ATTR_NAME, id) ;
        request.setAttribute(TODAY_PARAM_NAME, today.equals("on")  ? "checked" : "") ;
        request.setAttribute(TOMORROW_PARAM_NAME, tomorrow.equals("on") ? "checked" : "") ;
        request.setAttribute(DAYAFTERTOMORROW_PARAM_NAME, 
                dayaftertomorrow.equals("on") ? "checked" : "") ;
        request.setAttribute(DESCRIPTIONDISPMODE_PARAM_NAME,
                descriptionDisplayMode.equals("on") ? "checked" : "") ;
        
        // inclde JSP
        PortletRequestDispatcher rd = context.getRequestDispatcher(EDIT_MODE_JSP_PATH) ;
        rd.include(request, response);
        
    }
    
}
