/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.pooptimizer;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import jp.sf.pal.facesresponse.io.BufferedResponseStream;
import jp.sf.pal.facesresponse.io.BufferedResponseStreamFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class OptimizerFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)OptimizerFilter.class);
    private static final int DEFAULT_BLOCK_SIZE = 4096;
    private static final String BLOCK_SIZE_KEY = "block-size";
    private int blockSize = 4096;

    public void destroy() {
    }

    public void init(PortletFilterConfig config) throws PortletException {
        String blockSizeStr = config.getInitParameter(BLOCK_SIZE_KEY);
        if (blockSizeStr != null) {
            try {
                this.blockSize = Integer.parseInt(blockSizeStr);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Could not parse " + blockSizeStr), (Throwable)e);
            }
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called processActionFilter.");
        }
        chain.processActionFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"called renderFilter.");
        }
        chain.renderFilter(request, response);
        BufferedResponseStream bufferedResponseStream = BufferedResponseStreamFactory.getBufferedResponseStream((PortletRequest)request);
        if (bufferedResponseStream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("renderFilter(RenderRequest, RenderResponse, PortletFilterChain) - bufferedResponseStream=" + bufferedResponseStream));
            }
            bufferedResponseStream.commit();
            InputStream reader = bufferedResponseStream.getInputStream();
            BufferedOutputStream outputStream = new BufferedOutputStream(bufferedResponseStream.getOutputStream());
            byte[] bytes = new byte[this.blockSize];
            try {
                int length = reader.read(bytes);
                if (length != -1) {
                    String str = new String(bytes, 0, length, "ISO-8859-1");
                    int beginBodyIndex = str.indexOf("<body");
                    if (beginBodyIndex == -1) {
                        beginBodyIndex = str.indexOf("<BODY");
                    }
                    if (beginBodyIndex >= 0) {
                        int beginBodyIndexEnd = str.indexOf(">", beginBodyIndex);
                        int endBodyIndex = str.indexOf("</body");
                        if (endBodyIndex == -1) {
                            endBodyIndex = str.indexOf("</BODY");
                        }
                        if (endBodyIndex > beginBodyIndex) {
                            outputStream.write(bytes, beginBodyIndexEnd + 1, endBodyIndex - beginBodyIndexEnd - 1);
                        } else {
                            outputStream.write(bytes, beginBodyIndexEnd + 1, length - beginBodyIndexEnd - 1);
                            length = reader.read(bytes);
                            while (length != -1) {
                                str = new String(bytes, 0, length, "ISO-8859-1");
                                endBodyIndex = str.indexOf("</body");
                                if (endBodyIndex == -1) {
                                    endBodyIndex = str.indexOf("</BODY");
                                }
                                if (endBodyIndex >= 0) {
                                    outputStream.write(bytes, 0, endBodyIndex);
                                    break;
                                }
                                if (length > 0) {
                                    outputStream.write(bytes, 0, length);
                                }
                                length = reader.read(bytes);
                            }
                        }
                    } else {
                        if (length != -1) {
                            outputStream.write(bytes, 0, length);
                        }
                        length = reader.read(bytes);
                        while (length != -1) {
                            str = new String(bytes, 0, length, bufferedResponseStream.getEncoding());
                            if (length > 0) {
                                outputStream.write(bytes, 0, length);
                            }
                            length = reader.read(bytes);
                        }
                    }
                }
                outputStream.flush();
            }
            finally {
                bytes = null;
            }
            bufferedResponseStream.commit();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"BufferedResponseStream is null.");
        }
    }
}

