/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.helloworld;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * HelloWorldPortlet is a portlet to say "Hello!"
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class HelloWorldPortlet extends GenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HelloWorldPortlet.class);

    public static final String YOUR_NAME_KEY = "yourName";
    public static final String COUNT_KEY = "count";

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#init(javax.portlet.PortletConfig)
     */
    public void init(PortletConfig config) throws PortletException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init() - HelloWorldPortlet: init()");
        }
        super.init(config);
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#doView(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException
    {
        response.setContentType("text/html");        

        if (log.isDebugEnabled())
        {
            log.debug("doView() - HelloWorldPortlet: doView()");
        }
        PortletContext context = getPortletContext();

        String yourName = request.getParameter(YOUR_NAME_KEY);
        if (log.isDebugEnabled())
        {
            log.debug("doView() - yourName=" + yourName);
        }
        if (yourName == null)
        {
            yourName = "";
        }
        request.setAttribute(YOUR_NAME_KEY, yourName);

        PortletRequestDispatcher rd = context.getRequestDispatcher("/WEB-INF/jsp/helloworld.jsp");
        rd.include(request, response);
    }

    /* (non-Javadoc)
     * @see javax.portlet.Portlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException
    {
        if (log.isDebugEnabled())
        {
            log.debug("processAction() - HelloWorldPortlet: processAction()");
        }
        PortletSession session = request.getPortletSession();
        String yourName = request.getParameter(YOUR_NAME_KEY);

        if (yourName != null)
        {
            Integer count = (Integer) session.getAttribute(COUNT_KEY);
            if (count != null)
            {
                count = new Integer(count.intValue() + 1);
            }
            else
            {
                count = new Integer(1);
            }
            if (log.isDebugEnabled())
            {
                log.debug("processAction() - HelloWorldPortlet: yourName = " + yourName + ", count = " + count);
            }

            session.setAttribute(COUNT_KEY, count);
            response.setRenderParameter(YOUR_NAME_KEY, yourName);
        }

        return;
    }

}
