<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.todolist.resources.TodoListResources"
		var="msgs" />

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
		<t:dataTable id="todoList" var="todo"
			value="#{todoListViewPage.todos}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{todoListViewSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['todolistview.Title']}" />
				</f:facet>
				<h:commandLink action="#{todoListViewPage.detail}"
					value="#{todo['0'].title}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['todolistview.DueDate']}" />
				</f:facet>
				<h:outputText value="#{todo['0'].formattedShortDuedate}" />
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['todolistview.Status']}" />
				</f:facet>
				<h:outputText value="#{todo['0'].statusbar}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="todoList" fastStep="10" pageCountVar="pageCount"
				pageIndexVar="pageIndex" paginator="true" paginatorMaxPages="9">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="todoList" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				firstRowIndexVar="firstRowIndex" lastRowIndexVar="lastRowIndex"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['todolistview.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['todolistview.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>

		<h:panelGrid columns="3">
			<h:commandLink action="#{todoListViewPage.displayAll}"
				value="#{msgs['todolistview.All']}"
				rendered="#{!todoListViewSession.all}" />
			<h:commandLink action="#{todoListViewPage.displayOpen}"
				value="#{msgs['todolistview.Open']}"
				rendered="#{todoListViewSession.all}" />
			<h:outputText value="|" rendered="#{todoListViewPage.validUser}" />
			<h:commandLink action="#{todoListViewPage.toAddPage}"
				value="#{msgs['todolistview.Add']}"
				rendered="#{todoListViewPage.validUser}" />
		</h:panelGrid>
	</h:form>

</f:view>
