<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle
		basename="jp.sf.pal.addresslist.resources.AddressListResources"
		var="msgs" />

	<!-- List View -->
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
		<t:dataTable id="addressList" var="user"
			value="#{addressListViewPage.users}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{addressListSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['addresslistview.Name']}" />
				</f:facet>
				<h:commandLink action="#{addressListViewPage.detail}">
					<f:verbatim>
						<h:panelGrid columns="3">
							<h:outputText value="#{user['0'].familyname}" />
							<h:outputText value="#{user['0'].middlename}" />
							<h:outputText value="#{user['0'].givenname}" />
						</h:panelGrid>
					</f:verbatim>
				</h:commandLink>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['addresslistview.Email']}" />
				</f:facet>
				<h:panelGrid>
					<h:outputLink value="mailto:#{user['0'].homeEmail1.value}"
						rendered="#{user['0'].homeEmail1.value!='' && user['0'].homeEmail1.value!=null}">
						<f:verbatim>
							<h:outputText value="#{user['0'].homeEmail1.value}" />
							<h:outputText value="#{msgs['addresslistview.Home']}" />
						</f:verbatim>
					</h:outputLink>
					<h:outputLink value="mailto:#{user['0'].businessEmail1.value}"
						rendered="#{user['0'].businessEmail1.value!='' && user['0'].businessEmail1.value!=null}">
						<f:verbatim>
							<h:outputText value="#{user['0'].businessEmail1.value}" />
							<h:outputText value="#{msgs['addresslistview.Business']}" />
						</f:verbatim>
					</h:outputLink>
				</h:panelGrid>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['addresslistview.Telephone']}" />
				</f:facet>
				<h:panelGrid>
					<h:panelGrid columns="2"
						rendered="#{user['0'].homeTelephone.combinedNumber!=''}">
						<h:outputText value="#{user['0'].homeTelephone.combinedNumber}" />
						<h:outputText value="#{msgs['addresslistview.Home']}" />
					</h:panelGrid>
					<h:panelGrid columns="2"
						rendered="#{user['0'].homeMobile.combinedNumber!=''}">
						<h:outputText value="#{user['0'].homeMobile.combinedNumber}" />
						<h:outputText value="#{msgs['addresslistview.Home']}" />
					</h:panelGrid>
					<h:panelGrid columns="2"
						rendered="#{user['0'].businessTelephone.combinedNumber!=''}">
						<h:outputText
							value="#{user['0'].businessTelephone.combinedNumber}" />
						<h:outputText value="#{msgs['addresslistview.Business']}" />
					</h:panelGrid>
					<h:panelGrid columns="2"
						rendered="#{user['0'].businessMobile.combinedNumber!=''}">
						<h:outputText value="#{user['0'].businessMobile.combinedNumber}" />
						<h:outputText value="#{msgs['addresslistview.Business']}" />
					</h:panelGrid>
				</h:panelGrid>
			</h:column>
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['addresslistview.Employer']}" />
				</f:facet>
				<h:outputText value="#{user['0'].employer}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="addressList" fastStep="10"
				pageCountVar="pageCount" pageIndexVar="pageIndex" paginator="true"
				paginatorMaxPages="9">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex>1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="addressList" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				firstRowIndexVar="firstRowIndex" lastRowIndexVar="lastRowIndex"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['addresslistview.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['addresslistview.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>

		<h:panelGrid columns="1">
			<h:commandLink action="#{addressListViewPage.toAddPage}"
				value="#{msgs['addresslistview.Add']}"
				rendered="#{addressListViewPage.publicList}" />
		</h:panelGrid>
	</h:form>

</f:view>
