<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle
		basename="jp.sf.pal.addresslist.resources.AddressListResources"
		var="msgs" />

	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistadd.BasicInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="familyname">
				<h:outputText value="#{msgs['addresslistadd.FamilyName']}" />
			</h:outputLabel>
			<h:inputText id="familyname" value="#{addressListAddPage.familyname}"
				maxlength="128" />
			<h:message for="familyname"></h:message>

			<h:outputLabel for="givenname">
				<h:outputText value="#{msgs['addresslistadd.GivenName']}" />
			</h:outputLabel>
			<h:inputText id="givenname" value="#{addressListAddPage.givenname}"
				maxlength="128" />
			<h:message for="givenname"></h:message>

			<h:outputLabel for="middlename">
				<h:outputText value="#{msgs['addresslistadd.MiddleName']}" />
			</h:outputLabel>
			<h:inputText id="middlename" value="#{addressListAddPage.middlename}"
				maxlength="64" />
			<h:message for="middlename"></h:message>

			<h:outputLabel for="nameprefix">
				<h:outputText value="#{msgs['addresslistadd.NamePrefix']}" />
			</h:outputLabel>
			<h:inputText id="nameprefix" value="#{addressListAddPage.nameprefix}"
				maxlength="32" />
			<h:message for="nameprefix"></h:message>

			<h:outputLabel for="namesuffix">
				<h:outputText value="#{msgs['addresslistadd.NameSuffix']}" />
			</h:outputLabel>
			<h:inputText id="namesuffix" value="#{addressListAddPage.namesuffix}"
				maxlength="32" />
			<h:message for="namesuffix"></h:message>

			<h:outputLabel for="nickname">
				<h:outputText value="#{msgs['addresslistadd.Nickname']}" />
			</h:outputLabel>
			<h:inputText id="nickname" value="#{addressListAddPage.nickname}"
				maxlength="64" />
			<h:message for="nickname"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistadd.PersonalInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="bdate">
				<h:outputText value="#{msgs['addresslistadd.Bdate']}" />
			</h:outputLabel>
			<t:inputCalendar id="bdate" value="#{addressListAddPage.bdate}"
				renderAsPopup="true" popupTodayString="Today" popupWeekString="Wk"
				popupDateFormat="yyyy-MM-dd" renderPopupButtonAsImage="true" />
			<h:message for="bdate"></h:message>

			<h:outputLabel for="gender">
				<h:outputText value="#{msgs['addresslistadd.Gender']}" />
			</h:outputLabel>
			<h:selectOneMenu id="gender" value="#{addressListAddPage.gender}">
				<f:selectItems value="#{addressListAddPage.genderItems}" />
			</h:selectOneMenu>
			<h:message for="gender"></h:message>

			<h:outputLabel for="employer">
				<h:outputText value="#{msgs['addresslistadd.Employer']}" />
			</h:outputLabel>
			<h:inputText id="employer" value="#{addressListAddPage.employer}"
				maxlength="128" />
			<h:message for="employer"></h:message>

			<h:outputLabel for="department">
				<h:outputText value="#{msgs['addresslistadd.Department']}" />
			</h:outputLabel>
			<h:inputText id="department" value="#{addressListAddPage.department}"
				maxlength="128" />
			<h:message for="department"></h:message>

			<h:outputLabel for="jobtitle">
				<h:outputText value="#{msgs['addresslistadd.Jobtitle']}" />
			</h:outputLabel>
			<h:inputText id="jobtitle" value="#{addressListAddPage.jobtitle}"
				maxlength="64" />
			<h:message for="jobtitle"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText
				value="#{msgs['addresslistadd.HomeAddressInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="homeCountry">
				<h:outputText value="#{msgs['addresslistadd.Country']}" />
			</h:outputLabel>
			<h:inputText id="homeCountry"
				value="#{addressListAddPage.homeCountry}" maxlength="128" />
			<h:message for="homeCountry"></h:message>

			<h:outputLabel for="homePostalcode">
				<h:outputText value="#{msgs['addresslistadd.PostalCode']}" />
			</h:outputLabel>
			<h:inputText id="homePostalcode"
				value="#{addressListAddPage.homePostalcode}" maxlength="255" />
			<h:message for="homePostalcode"></h:message>

			<h:outputLabel for="homeStateprov">
				<h:outputText value="#{msgs['addresslistadd.StateProv']}" />
			</h:outputLabel>
			<h:inputText id="homeStateprov"
				value="#{addressListAddPage.homeStateprov}" maxlength="64" />
			<h:message for="homeStateprov"></h:message>

			<h:outputLabel for="homeCity">
				<h:outputText value="#{msgs['addresslistadd.City']}" />
			</h:outputLabel>
			<h:inputText id="homeCity" value="#{addressListAddPage.homeCity}"
				maxlength="64" />
			<h:message for="homeCity"></h:message>

			<h:outputLabel for="homeStreet">
				<h:outputText value="#{msgs['addresslistadd.Street']}" />
			</h:outputLabel>
			<h:inputText id="homeStreet" value="#{addressListAddPage.homeStreet}"
				maxlength="64" />
			<h:message for="homeStreet"></h:message>

			<h:outputLabel for="homeName">
				<h:outputText value="#{msgs['addresslistadd.Name']}" />
			</h:outputLabel>
			<h:inputText id="homeName" value="#{addressListAddPage.homeName}"
				maxlength="128" />
			<h:message for="homeName"></h:message>

			<h:outputLabel for="homeOrganization">
				<h:outputText value="#{msgs['addresslistadd.Organization']}" />
			</h:outputLabel>
			<h:inputText id="homeOrganization"
				value="#{addressListAddPage.homeOrganization}" maxlength="255" />
			<h:message for="homeOrganization"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="homeTelephone">
				<h:outputText value="#{msgs['addresslistadd.Telephone']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeTelephone">
				<h:outputText value="+" />
				<h:inputText id="homeTelephoneIntcode"
					value="#{addressListAddPage.homeTelephoneIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeTelephoneLoccode"
					value="#{addressListAddPage.homeTelephoneLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeTelephoneNumber"
					value="#{addressListAddPage.homeTelephoneNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeTelephoneExt"
					value="#{addressListAddPage.homeTelephoneExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeTelephone"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.HomeTelephoneExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeTelephoneComment">
				<h:outputText value="#{msgs['addresslistadd.TelephoneComment']}" />
			</h:outputLabel>
			<h:inputText id="homeTelephoneComment"
				value="#{addressListAddPage.homeTelephoneComment}" maxlength="255" />
			<h:message for="homeTelephoneComment"></h:message>

			<h:outputLabel for="homeFax">
				<h:outputText value="#{msgs['addresslistadd.Fax']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeFax">
				<h:outputText value="+" />
				<h:inputText id="homeFaxIntcode"
					value="#{addressListAddPage.homeFaxIntcode}" maxlength="2" size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeFaxLoccode"
					value="#{addressListAddPage.homeFaxLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeFaxNumber"
					value="#{addressListAddPage.homeFaxNumber}" maxlength="32" size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeFaxExt"
					value="#{addressListAddPage.homeFaxExt}" maxlength="32" size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeFax"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.HomeFaxExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeFaxComment">
				<h:outputText value="#{msgs['addresslistadd.FaxComment']}" />
			</h:outputLabel>
			<h:inputText id="homeFaxComment"
				value="#{addressListAddPage.homeFaxComment}" maxlength="255" />
			<h:message for="homeFaxComment"></h:message>

			<h:outputLabel for="homeMobile">
				<h:outputText value="#{msgs['addresslistadd.Mobile']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homeMobile">
				<h:outputText value="+" />
				<h:inputText id="homeMobileIntcode"
					value="#{addressListAddPage.homeMobileIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homeMobileLoccode"
					value="#{addressListAddPage.homeMobileLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homeMobileNumber"
					value="#{addressListAddPage.homeMobileNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homeMobileExt"
					value="#{addressListAddPage.homeMobileExt}" maxlength="32" size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homeMobile"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.HomeMobileExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homeMobileComment">
				<h:outputText value="#{msgs['addresslistadd.MobileComment']}" />
			</h:outputLabel>
			<h:inputText id="homeMobileComment"
				value="#{addressListAddPage.homeMobileComment}" maxlength="255" />
			<h:message for="homeMobileComment"></h:message>

			<h:outputLabel for="homePager">
				<h:outputText value="#{msgs['addresslistadd.Pager']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="homePager">
				<h:outputText value="+" />
				<h:inputText id="homePagerIntcode"
					value="#{addressListAddPage.homePagerIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="homePagerLoccode"
					value="#{addressListAddPage.homePagerLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="homePagerNumber"
					value="#{addressListAddPage.homePagerNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="homePagerExt"
					value="#{addressListAddPage.homePagerExt}" maxlength="32" size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="homePager"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.HomePagerExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="homePagerComment">
				<h:outputText value="#{msgs['addresslistadd.PagerComment']}" />
			</h:outputLabel>
			<h:inputText id="homePagerComment"
				value="#{addressListAddPage.homePagerComment}" maxlength="255" />
			<h:message for="homePagerComment"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="homeEmail1">
				<h:outputText value="#{msgs['addresslistadd.Email1']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail1" value="#{addressListAddPage.homeEmail1}"
				maxlength="255" />
			<h:message for="homeEmail1"></h:message>

			<h:outputLabel for="homeEmail2">
				<h:outputText value="#{msgs['addresslistadd.Email2']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail2" value="#{addressListAddPage.homeEmail2}"
				maxlength="255" />
			<h:message for="homeEmail2"></h:message>

			<h:outputLabel for="homeEmail3">
				<h:outputText value="#{msgs['addresslistadd.Email3']}" />
			</h:outputLabel>
			<h:inputText id="homeEmail3" value="#{addressListAddPage.homeEmail3}"
				maxlength="255" />
			<h:message for="homeEmail3"></h:message>

			<h:outputLabel for="homeUrl1">
				<h:outputText value="#{msgs['addresslistadd.Url1']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl1" value="#{addressListAddPage.homeUrl1}"
				maxlength="255" />
			<h:message for="homeUrl1"></h:message>

			<h:outputLabel for="homeUrl2">
				<h:outputText value="#{msgs['addresslistadd.Url2']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl2" value="#{addressListAddPage.homeUrl2}"
				maxlength="255" />
			<h:message for="homeUrl2"></h:message>

			<h:outputLabel for="homeUrl3">
				<h:outputText value="#{msgs['addresslistadd.Url3']}" />
			</h:outputLabel>
			<h:inputText id="homeUrl3" value="#{addressListAddPage.homeUrl3}"
				maxlength="255" />
			<h:message for="homeUrl3"></h:message>

		</h:panelGrid>


		<t:div styleClass="portlet-section-header">
			<h:outputText
				value="#{msgs['addresslistadd.BusinessAddressInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="businessCountry">
				<h:outputText value="#{msgs['addresslistadd.Country']}" />
			</h:outputLabel>
			<h:inputText id="businessCountry"
				value="#{addressListAddPage.businessCountry}" maxlength="128" />
			<h:message for="businessCountry"></h:message>

			<h:outputLabel for="businessPostalcode">
				<h:outputText value="#{msgs['addresslistadd.PostalCode']}" />
			</h:outputLabel>
			<h:inputText id="businessPostalcode"
				value="#{addressListAddPage.businessPostalcode}" maxlength="255" />
			<h:message for="businessPostalcode"></h:message>

			<h:outputLabel for="businessStateprov">
				<h:outputText value="#{msgs['addresslistadd.StateProv']}" />
			</h:outputLabel>
			<h:inputText id="businessStateprov"
				value="#{addressListAddPage.businessStateprov}" maxlength="64" />
			<h:message for="businessStateprov"></h:message>

			<h:outputLabel for="businessCity">
				<h:outputText value="#{msgs['addresslistadd.City']}" />
			</h:outputLabel>
			<h:inputText id="businessCity"
				value="#{addressListAddPage.businessCity}" maxlength="64" />
			<h:message for="businessCity"></h:message>

			<h:outputLabel for="businessStreet">
				<h:outputText value="#{msgs['addresslistadd.Street']}" />
			</h:outputLabel>
			<h:inputText id="businessStreet"
				value="#{addressListAddPage.businessStreet}" maxlength="64" />
			<h:message for="businessStreet"></h:message>

			<h:outputLabel for="businessName">
				<h:outputText value="#{msgs['addresslistadd.Name']}" />
			</h:outputLabel>
			<h:inputText id="businessName"
				value="#{addressListAddPage.businessName}" maxlength="128" />
			<h:message for="businessName"></h:message>

			<h:outputLabel for="businessOrganization">
				<h:outputText value="#{msgs['addresslistadd.Organization']}" />
			</h:outputLabel>
			<h:inputText id="businessOrganization"
				value="#{addressListAddPage.businessOrganization}" maxlength="255" />
			<h:message for="businessOrganization"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="businessTelephone">
				<h:outputText value="#{msgs['addresslistadd.Telephone']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessTelephone">
				<h:outputText value="+" />
				<h:inputText id="businessTelephoneIntcode"
					value="#{addressListAddPage.businessTelephoneIntcode}"
					maxlength="2" size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessTelephoneLoccode"
					value="#{addressListAddPage.businessTelephoneLoccode}"
					maxlength="32" size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessTelephoneNumber"
					value="#{addressListAddPage.businessTelephoneNumber}"
					maxlength="32" size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessTelephoneExt"
					value="#{addressListAddPage.businessTelephoneExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessTelephone"></h:message>

			<h:outputText value="" />
			<h:outputText
				value="#{msgs['addresslistadd.BusinessTelephoneExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessTelephoneComment">
				<h:outputText value="#{msgs['addresslistadd.TelephoneComment']}" />
			</h:outputLabel>
			<h:inputText id="businessTelephoneComment"
				value="#{addressListAddPage.businessTelephoneComment}"
				maxlength="255" />
			<h:message for="businessTelephoneComment"></h:message>

			<h:outputLabel for="businessFax">
				<h:outputText value="#{msgs['addresslistadd.Fax']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessFax">
				<h:outputText value="+" />
				<h:inputText id="businessFaxIntcode"
					value="#{addressListAddPage.businessFaxIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessFaxLoccode"
					value="#{addressListAddPage.businessFaxLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessFaxNumber"
					value="#{addressListAddPage.businessFaxNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessFaxExt"
					value="#{addressListAddPage.businessFaxExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessFax"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.BusinessFaxExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessFaxComment">
				<h:outputText value="#{msgs['addresslistadd.FaxComment']}" />
			</h:outputLabel>
			<h:inputText id="businessFaxComment"
				value="#{addressListAddPage.businessFaxComment}" maxlength="255" />
			<h:message for="businessFaxComment"></h:message>

			<h:outputLabel for="businessMobile">
				<h:outputText value="#{msgs['addresslistadd.Mobile']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessMobile">
				<h:outputText value="+" />
				<h:inputText id="businessMobileIntcode"
					value="#{addressListAddPage.businessMobileIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessMobileLoccode"
					value="#{addressListAddPage.businessMobileLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessMobileNumber"
					value="#{addressListAddPage.businessMobileNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessMobileExt"
					value="#{addressListAddPage.businessMobileExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessMobile"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.BusinessMobileExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessMobileComment">
				<h:outputText value="#{msgs['addresslistadd.MobileComment']}" />
			</h:outputLabel>
			<h:inputText id="businessMobileComment"
				value="#{addressListAddPage.businessMobileComment}" maxlength="255" />
			<h:message for="businessMobileComment"></h:message>

			<h:outputLabel for="businessPager">
				<h:outputText value="#{msgs['addresslistadd.Pager']}" />
			</h:outputLabel>
			<h:panelGrid columns="9" id="businessPager">
				<h:outputText value="+" />
				<h:inputText id="businessPagerIntcode"
					value="#{addressListAddPage.businessPagerIntcode}" maxlength="2"
					size="2" />
				<h:outputText value="-" />
				<h:inputText id="businessPagerLoccode"
					value="#{addressListAddPage.businessPagerLoccode}" maxlength="32"
					size="4" />
				<h:outputText value="-" />
				<h:inputText id="businessPagerNumber"
					value="#{addressListAddPage.businessPagerNumber}" maxlength="32"
					size="8" />
				<h:outputText value="(" />
				<h:inputText id="businessPagerExt"
					value="#{addressListAddPage.businessPagerExt}" maxlength="32"
					size="4" />
				<h:outputText value=")" />

			</h:panelGrid>
			<h:message for="businessPager"></h:message>

			<h:outputText value="" />
			<h:outputText value="#{msgs['addresslistadd.BusinessPagerExample']}" />
			<h:outputText value="" />

			<h:outputLabel for="businessPagerComment">
				<h:outputText value="#{msgs['addresslistadd.PagerComment']}" />
			</h:outputLabel>
			<h:inputText id="businessPagerComment"
				value="#{addressListAddPage.businessPagerComment}" maxlength="255" />
			<h:message for="businessPagerComment"></h:message>

		</h:panelGrid>

		<h:panelGrid columns="3">

			<h:outputLabel for="businessEmail1">
				<h:outputText value="#{msgs['addresslistadd.Email1']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail1"
				value="#{addressListAddPage.businessEmail1}" maxlength="255" />
			<h:message for="businessEmail1"></h:message>

			<h:outputLabel for="businessEmail2">
				<h:outputText value="#{msgs['addresslistadd.Email2']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail2"
				value="#{addressListAddPage.businessEmail2}" maxlength="255" />
			<h:message for="businessEmail2"></h:message>

			<h:outputLabel for="businessEmail3">
				<h:outputText value="#{msgs['addresslistadd.Email3']}" />
			</h:outputLabel>
			<h:inputText id="businessEmail3"
				value="#{addressListAddPage.businessEmail3}" maxlength="255" />
			<h:message for="businessEmail3"></h:message>

			<h:outputLabel for="businessUrl1">
				<h:outputText value="#{msgs['addresslistadd.Url1']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl1"
				value="#{addressListAddPage.businessUrl1}" maxlength="255" />
			<h:message for="businessUrl1"></h:message>

			<h:outputLabel for="businessUrl2">
				<h:outputText value="#{msgs['addresslistadd.Url2']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl2"
				value="#{addressListAddPage.businessUrl2}" maxlength="255" />
			<h:message for="businessUrl2"></h:message>

			<h:outputLabel for="businessUrl3">
				<h:outputText value="#{msgs['addresslistadd.Url3']}" />
			</h:outputLabel>
			<h:inputText id="businessUrl3"
				value="#{addressListAddPage.businessUrl3}" maxlength="255" />
			<h:message for="businessUrl3"></h:message>

		</h:panelGrid>

		<t:div styleClass="portlet-section-header">
			<h:outputText value="#{msgs['addresslistadd.CustomInformation']}" />
		</t:div>
		<h:panelGrid columns="3">

			<h:outputLabel for="custom1">
				<h:outputText value="#{msgs['addresslistadd.Custom1']}" />
			</h:outputLabel>
			<h:inputText id="custom1" value="#{addressListAddPage.custom1}"
				maxlength="255" />
			<h:message for="custom1"></h:message>

			<h:outputLabel for="custom2">
				<h:outputText value="#{msgs['addresslistadd.Custom2']}" />
			</h:outputLabel>
			<h:inputText id="custom2" value="#{addressListAddPage.custom2}"
				maxlength="255" />
			<h:message for="custom2"></h:message>

			<h:outputLabel for="custom3">
				<h:outputText value="#{msgs['addresslistadd.Custom3']}" />
			</h:outputLabel>
			<h:inputText id="custom3" value="#{addressListAddPage.custom3}"
				maxlength="255" />
			<h:message for="custom3"></h:message>

			<h:outputLabel for="custom4">
				<h:outputText value="#{msgs['addresslistadd.Custom4']}" />
			</h:outputLabel>
			<h:inputText id="custom4" value="#{addressListAddPage.custom4}"
				maxlength="255" />
			<h:message for="custom4"></h:message>

		</h:panelGrid>


		<h:panelGrid columns="2">
			<h:commandButton action="#{addressListAddPage.save}"
				value="#{msgs['addresslistadd.Add']}" />
			<h:commandButton action="#{addressListAddPage.back}"
				value="#{msgs['addresslistadd.Back']}" immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
