/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.util;

import jp.sf.pal.addresslist.AddressListRuntimeException;
import jp.sf.pal.addresslist.dao.CustomDao;
import jp.sf.pal.addresslist.dao.OnlineDao;
import jp.sf.pal.addresslist.dao.PostalDao;
import jp.sf.pal.addresslist.dao.TelecomDao;
import jp.sf.pal.addresslist.dao.UserDao;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class AddressListDaoUtil
{
    public static CustomDao getCustomDao() throws AddressListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getCustomDao(container);
    }

    public static CustomDao getCustomDao(S2Container container) throws AddressListRuntimeException
    {
        CustomDao dao = (CustomDao) container.getComponent(CustomDao.class);
        if (dao == null)
        {
            throw new AddressListRuntimeException("CustomDao is null. Check the configuration for S2Container.");
        }
        return dao;
    }

    public static OnlineDao getOnlineDao() throws AddressListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getOnlineDao(container);
    }

    public static OnlineDao getOnlineDao(S2Container container) throws AddressListRuntimeException
    {
        OnlineDao dao = (OnlineDao) container.getComponent(OnlineDao.class);
        if (dao == null)
        {
            throw new AddressListRuntimeException("OnlineDao is null. Check the configuration for S2Container.");
        }
        return dao;
    }

    public static PostalDao getPostalDao() throws AddressListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getPostalDao(container);
    }

    public static PostalDao getPostalDao(S2Container container) throws AddressListRuntimeException
    {
        PostalDao dao = (PostalDao) container.getComponent(PostalDao.class);
        if (dao == null)
        {
            throw new AddressListRuntimeException("PostalDao is null. Check the configuration for S2Container.");
        }
        return dao;
    }

    public static TelecomDao getTelecomDao() throws AddressListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getTelecomDao(container);
    }

    public static TelecomDao getTelecomDao(S2Container container) throws AddressListRuntimeException
    {
        TelecomDao dao = (TelecomDao) container.getComponent(TelecomDao.class);
        if (dao == null)
        {
            throw new AddressListRuntimeException("TelecomDao is null. Check the configuration for S2Container.");
        }
        return dao;
    }

    public static UserDao getUserDao() throws AddressListRuntimeException
    {
        S2Container container = SingletonS2ContainerFactory.getContainer();

        return getUserDao(container);
    }

    public static UserDao getUserDao(S2Container container) throws AddressListRuntimeException
    {
        UserDao dao = (UserDao) container.getComponent(UserDao.class);
        if (dao == null)
        {
            throw new AddressListRuntimeException("UserDao is null. Check the configuration for S2Container.");
        }
        return dao;
    }

}
