/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.bean;

import java.util.ArrayList;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;

import jp.sf.pal.addresslist.AddressListConstants;
import jp.sf.pal.addresslist.model.User;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletConfigUtil;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.model.S2HibernateDataModel;
import com.marevol.utils.faces.util.LocaleUtil;

public class AddressListViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(AddressListViewPageBean.class);

    private Boolean publicList = null;

    private AddressListSessionBean addressListSession;

    public String detail()
    {
        ExternalContext exContext = FacesContext.getCurrentInstance()
                .getExternalContext();
        Map map = exContext.getRequestMap();
        Map userMap = (Map) map.get("user");
        User user = (User) userMap.get("0");
        if (user != null)
        {
            getAddressListSession().setUser(user);
            return AddressListConstants.ADDRESSLISTEDIT_VIEW_ID;
        }
        else
        {
            // i18n
            FacesMessageUtil.addWarnMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "addresslistviewpagebean.TheSelectedItemIsNull"));
            log.error("The selected Item is null.");
        }
        return null;
    }

    public String toAddPage()
    {
        return AddressListConstants.ADDRESSLISTADD_VIEW_ID;
    }

    // Setter and Getter

    public boolean isPublicList()
    {
        if (publicList == null)
        {
            String publicListString = PortletConfigUtil
                    .getInitParameter(AddressListConstants.PUBLIC_LIST_PARAM);
            if (publicListString != null
                    && publicListString.equalsIgnoreCase("true"))
            {
                publicList = Boolean.TRUE;
            }
            else
            {
                if (FacesContext.getCurrentInstance().getExternalContext()
                        .getRemoteUser() != null)
                {
                    publicList = Boolean.TRUE;
                }
                else
                {
                    publicList = Boolean.FALSE;
                }
            }
        }
        return publicList.booleanValue();
    }

    /**
     * @return Returns the user list.
     */
    public DataModel getUsers()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getUsers() - start");
        }

        StringBuffer query = new StringBuffer("select user from User user ");
        String param = "where ";
        ArrayList paramList = new ArrayList();

        String username = FacesContext.getCurrentInstance()
                .getExternalContext().getRemoteUser();
        if (isPublicList())
        {
            if (username != null)
            {
                query.append(param);
                query.append("(user.owner = ? or user.owner = ?) ");
                param = "and ";
                paramList.add(username);
                paramList.add(AddressListConstants.GUEST_USERNAME);
            }
            else
            {
                query.append(param);
                query.append("user.owner = ? ");
                param = "and ";
                paramList.add(AddressListConstants.GUEST_USERNAME);
            }
        }
        else
        {
            if (username == null)
            {
                query.append(param);
                query.append("user.owner = ? ");
                param = "and ";
                paramList.add(username);
            }
            else
            {
                query.append(param);
                query.append("user.owner = ? ");
                param = "and ";
                paramList.add(AddressListConstants.GUEST_USERNAME);
            }
        }

        // TODO order
        query.append("order by user.familyname, user.givenname");

        if (log.isDebugEnabled())
        {
            log.debug("getUsers() -  : query=" + query.toString());
            for (int i = 0; i < paramList.size(); i++)
            {
                log.debug("getUsers() -  : param[" + i + "]="
                        + paramList.get(i));
            }
        }

        Object[] params = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); i++)
        {
            params[i] = paramList.get(i);
        }

        DataModel returnDataModel = new S2HibernateDataModel(query.toString(),
                params);
        if (log.isDebugEnabled())
        {
            log.debug("getUsers() - end");
        }
        return returnDataModel;
    }

    /**
     * @return Returns the addressListSession.
     */
    public AddressListSessionBean getAddressListSession()
    {
        return addressListSession;
    }

    /**
     * @param addressListSession The addressListSession to set.
     */
    public void setAddressListSession(
            AddressListSessionBean addressListViewSession)
    {
        this.addressListSession = addressListViewSession;
    }
}
