/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.bean;

import java.io.IOException;

import jp.sf.pal.addresslist.AddressListConstants;
import jp.sf.pal.addresslist.model.User;
import jp.sf.pal.addresslist.util.AddressListDaoUtil;

import org.seasar.portlet.util.PortletPreferencesUtil;

public class AddressListSessionBean
{

    private Long userId;

    /**
     * @return Returns the user.
     */
    public User getUser()
    {
        if (userId != null)
        {
            return AddressListDaoUtil.getUserDao().getUserById(
                    userId.longValue());
        }
        else
        {
            return null;
        }
    }

    /**
     * @param user The user to set.
     */
    public void setUser(User user)
    {
        if (user != null)
        {
            userId = new Long(user.getId());
        }
        else
        {
            userId = null;
        }
    }

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        return new Integer(PortletPreferencesUtil.getValue(
                AddressListConstants.VIEW_PAGE_SIZE, Integer
                        .toString(AddressListConstants.DEFAULT_PAGE_SIZE)));
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer maxResults) throws IOException
    {
        PortletPreferencesUtil.setValue(AddressListConstants.VIEW_PAGE_SIZE,
                maxResults.toString());
    }

}
