package jp.sf.pal.searchselector.web.search;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Locale;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sf.pal.searchselector.engine.SearchEngine;
import jp.sf.pal.searchselector.engine.SearchEngineFactory;

public class SearchListPage
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(SearchListPage.class);

    private String actionUrl;

    public SelectItem[] getSearchEngines()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getSearchEngines()");
        }

        SearchEngineFactory searchEngineFactory = (SearchEngineFactory) SingletonS2ContainerFactory
                .getContainer().getComponent("SearchEngineFactory");
        if (searchEngineFactory == null)
        {
            return null;
        }
        List<SearchEngine> engines = searchEngineFactory.getSearchEngines();
        SelectItem[] items = new SelectItem[engines.size()];
        Locale locale = getCurrentLocale();
        int i = 0;
        for (SearchEngine engine : engines)
        {
            items[i] = new SelectItem(engine.getId(), engine
                    .getLocalizedName(locale));
            i++;
        }
        return items;
    }

    private Locale getCurrentLocale()
    {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null)
        {
            return context.getViewRoot().getLocale();
        }
        return Locale.ENGLISH;
    }

    /**
     * @return the actionUrl
     */
    public String getActionUrl()
    {
        return actionUrl;
    }

    /**
     * @param actionUrl the actionUrl to set
     */
    public void setActionUrl(String actionUrl)
    {
        this.actionUrl = actionUrl;
    }

    public String getFormOnClick()
    {
        return FacesContext.getCurrentInstance().getExternalContext()
                .encodeNamespace("search")
                + "(); return false;";
    }
}
