package jp.sf.pal.searchselector.engine;

import java.util.Locale;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SearchEngine
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(SearchEngine.class);

    private String id;

    private String encoding;

    private Map<String, String> name;

    private String actionUrl;

    /**
     * @return the actionUrl
     */
    public String getActionUrl()
    {
        return actionUrl;
    }

    /**
     * @param actionUrl the actionUrl to set
     */
    public void setActionUrl(String actionUrl)
    {
        this.actionUrl = actionUrl;
    }

    /**
     * @return the name
     */
    public Map<String, String> getName()
    {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(Map<String, String> name)
    {
        this.name = name;
    }

    public String getLocalizedName(Locale locale)
    {
        if (log.isDebugEnabled())
        {
            log.debug("getLocalizedName(Locale) - locale=" + locale);
        }

        if (locale != null)
        {
            String lname = null;
            for (String lc : name.keySet())
            {

                if (locale.toString().equalsIgnoreCase(lc))
                {
                    lname = name.get(lc);
                }
                else if (locale.toString().startsWith(lc) && lname == null)
                {
                    lname = name.get(lc);
                }
            }
            if (log.isDebugEnabled())
            {
                log.debug("getLocalizedName(Locale) - lname=" + lname);
            }

            if (lname != null)
            {
                return lname;
            }
        }

        String defaultName = null;
        for (String lc : name.keySet())
        {
            if (defaultName == null)
            {
                defaultName = name.get(lc);
            }
            else if (lc.equals("en"))
            {
                defaultName = name.get(lc);
            }
        }
        if (defaultName != null)
        {
            return defaultName;
        }
        return "Unknown Search Engine";
    }

    /**
     * @return the id
     */
    public String getId()
    {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * @return the encoding
     */
    public String getEncoding()
    {
        return encoding;
    }

    /**
     * @param encoding the encoding to set
     */
    public void setEncoding(String encoding)
    {
        this.encoding = encoding;
    }
}
