<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.blog.resources.BlogViewResources"
		var="msgs" />
	<h:form id="redirectForm">
		<h:inputHidden id="blogid" />
		<h:outputText value="#{viewPage.javaScriptForRedirect}" escape="false" />
	</h:form>
	<!-- List View -->
	<h:form rendered='#{viewPage.mode=="ListView"}'>
		<t:dataTable id="listView" var="blogMsg"
			value="#{viewPage.blogMessages}"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{viewSession.pageSize}">
			<h:column>
				<t:htmlTag value="div" styleClass="portlet-section-header">
					<h:outputText value="#{blogMsg['0'].title}" />
					<h:outputText value="#{msgs['blogview.NoTitle']}"
						rendered="#{blogMsg['0'].emptyTitle}" />
				</t:htmlTag>
				<t:htmlTag value="div" style="padding:3px">
					<h:outputText value="#{blogMsg['0'].formattedMessage}"
						styleClass="portlet-font" escape="false" />
				</t:htmlTag>
				<t:htmlTag value="div" styleClass="portlet-section-footer"
					style="text-align:right">
					<h:outputFormat value="#{msgs['blogview.PostedByNameAtDate']}">
						<f:param value="#{blogMsg['0'].owner}" />
						<f:param value="#{blogMsg['0'].formattedCreatedtime}" />
					</h:outputFormat>
					<t:htmlTag value="br" />
					<h:outputLink value="#{blogMsg['0'].redirectUrl}">
						<h:outputText value="#{msgs['blogview.LinkToThisArticle']}" />
					</h:outputLink>
					<h:outputText value="|" rendered="#{viewSession.trackbackEnabled}" />
					<h:outputLink value="#{blogMsg['0'].trackbackUrl}"
						rendered="#{viewSession.trackbackEnabled}">
						<h:outputText value="#{msgs['blogview.TrackbackURL']}" />
					</h:outputLink>
					<h:outputText value="|" rendered="#{viewSession.commentEnabled}" />
					<h:commandLink action="#{viewPage.commentView}"
						rendered="#{viewSession.commentEnabled}">
						<h:outputFormat value="#{msgs['blogview.Comments']}">
							<f:param value="#{blogMsg['0'].blogCommentSize}" />
						</h:outputFormat>
					</h:commandLink>
					<h:outputText value="|" rendered="#{viewSession.trackbackEnabled}" />
					<h:outputFormat value="#{msgs['blogview.Trackback']}"
						rendered="#{viewSession.trackbackEnabled}">
						<f:param value="#{blogMsg['0'].blogTrackbackSize}" />
					</h:outputFormat>
				</t:htmlTag>
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="listView" fastStep="10" pageCountVar="pageCount"
				pageIndexVar="pageIndex" paginator="true" paginatorMaxPages="9">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="listView" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				firstRowIndexVar="firstRowIndex" lastRowIndexVar="lastRowIndex"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['blogview.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{displayedRowsCountVar}" />
					<f:param value="#{firstRowIndex}" />
					<f:param value="#{lastRowIndex}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['blogview.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>
	</h:form>

	<!-- Content View -->
	<h:form rendered='#{viewPage.mode=="ContentView"}'>
		<h:panelGrid columns="1">
			<h:commandLink action="#{viewPage.listView}"
				styleClass="portlet-form-button">
				<h:outputText value="#{msgs['blogview.All']}" escape="false" />
			</h:commandLink>
		</h:panelGrid>
	</h:form>
	<h:form rendered='#{viewPage.mode=="ContentView"}'>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<t:htmlTag value="div" styleClass="portlet-section-header">
			<h:outputText value="#{viewPage.blogMessage.title}" />
			<h:outputText value="#{msgs['blogview.NoTitle']}"
				rendered="#{viewPage.blogMessage.emptyTitle}" />
		</t:htmlTag>
		<t:htmlTag value="div" style="padding:3px">
			<h:outputText value="#{viewPage.blogMessage.formattedMessage}"
				styleClass="portlet-font" escape="false" />
		</t:htmlTag>
		<t:htmlTag value="div" styleClass="portlet-section-footer"
			style="text-align:right">
			<h:outputFormat value="#{msgs['blogview.PostedByNameAtDate']}">
				<f:param value="#{viewPage.blogMessage.owner}" />
				<f:param value="#{viewPage.blogMessage.formattedCreatedtime}" />
			</h:outputFormat>
		</t:htmlTag>

		<t:htmlTag value="span" rendered="#{viewSession.commentEnabled}">
			<t:htmlTag value="div" styleClass="portlet-section-header">
				<h:outputText value="#{msgs['blogview.CommentsTitle']}" />
			</t:htmlTag>
			<h:outputText value="#{msgs['blogview.NoComments']}"
				rendered="#{viewPage.blogMessage.blogCommentSize==0}" />
			<t:dataTable var="blogCmt"
				value="#{viewPage.blogMessage.sortedBlogComments}"
				rowClasses="portlet-section-body,portlet-section-alternate"
				style="width:100%"
				rendered="#{viewPage.blogMessage.blogCommentSize>0}">
				<h:column>
					<t:htmlTag value="div" style="padding:3px">
						<h:outputText value="#{blogCmt.message}" styleClass="portlet-font"
							escape="false" />
					</t:htmlTag>
					<t:htmlTag value="div" styleClass="portlet-section-footer"
						style="text-align:right">
						<h:outputFormat
							value="#{msgs['blogview.PostedByEmailNameAtDate']}"
							rendered="#{!blogCmt.emptyEmail}"
							escape="false">
							<f:param value="#{blogCmt.email}" />
							<f:param value="#{blogCmt.name}" />
							<f:param value="#{blogCmt.formattedCreatedtime}" />
						</h:outputFormat>
						<h:outputFormat value="#{msgs['blogview.PostedByNameAtDate']}"
							rendered="#{blogCmt.emptyEmail}">
							<f:param value="#{blogCmt.name}" />
							<f:param value="#{blogCmt.formattedCreatedtime}" />
						</h:outputFormat>
						<h:outputText value="|"
							rendered="#{!blogCmt.emptyUrl}" />
						<h:outputLink value="#{blogCmt.url}"
							rendered="#{!blogCmt.emptyUrl}">
							<f:verbatim>
								<h:outputText value="#{msgs['blogview.URL']}" />
							</f:verbatim>
						</h:outputLink>
						<h:outputText value="|" rendered="#{blogCmt.deleteEnabled}" />
						<h:commandLink action="#{viewPage.deleteComment}"
							rendered="#{blogCmt.deleteEnabled}">
							<f:verbatim>
								<h:outputText value="#{msgs['blogview.Delete']}" />
							</f:verbatim>
						</h:commandLink>
					</t:htmlTag>
				</h:column>
			</t:dataTable>
			<t:htmlTag value="br" />
		</t:htmlTag>
	</h:form>
	<t:htmlTag value="span" rendered="#{viewSession.commentEnabled}">
		<h:form rendered='#{viewPage.mode=="ContentView"}'>
			<t:htmlTag value="div" styleClass="portlet-section-header">
				<h:outputText value="#{msgs['blogview.PostAComment']}" />
			</t:htmlTag>
			<t:panelGrid columns="1">
				<t:outputLabel for="name">
					<t:outputText value="#{msgs['blogview.comment.Name']}"
						styleClass="portlet-form-field" />
				</t:outputLabel>
				<t:inputText id="name" value="#{viewPage.commentName}"
					required="true" />
				<t:message for="name" infoClass="portlet-msg-info"
					warnClass="portlet-msg-alert" fatalClass="portlet-msg-error"
					errorClass="portlet-msg-error" />

				<t:outputLabel for="email" styleClass="portlet-form-field">
					<t:outputText value="#{msgs['blogview.comment.EmailAddress']}" />
				</t:outputLabel>
				<t:inputText id="email" value="#{viewPage.commentEmail}">
					<t:validateEmail />
				</t:inputText>
				<t:message for="email" infoClass="portlet-msg-info"
					warnClass="portlet-msg-alert" fatalClass="portlet-msg-error"
					errorClass="portlet-msg-error" />

				<t:outputLabel for="url">
					<t:outputText value="#{msgs['blogview.comment.URL']}"
						styleClass="portlet-form-field" />
				</t:outputLabel>
				<t:inputText id="url" value="#{viewPage.commentUrl}">
					<t:validateRegExpr pattern="(http)|(https)://.*" />
				</t:inputText>
				<t:message for="url" infoClass="portlet-msg-info"
					warnClass="portlet-msg-alert" fatalClass="portlet-msg-error"
					errorClass="portlet-msg-error" />

				<t:outputLabel for="comment">
					<t:outputText value="#{msgs['blogview.comment.Comments']}"
						styleClass="portlet-form-field" />
				</t:outputLabel>
				<t:inputTextarea id="comment" value="#{viewPage.commentMessage}"
					rows="10" cols="50" required="true" />
				<t:message for="comment" infoClass="portlet-msg-info"
					warnClass="portlet-msg-alert" fatalClass="portlet-msg-error"
					errorClass="portlet-msg-error" />

			</t:panelGrid>
			<t:div style="width:100%;text-align:center;">
				<h:commandButton action="#{viewPage.postComment}"
					value="#{msgs['blogview.comment.Post']}" />
			</t:div>
			<t:htmlTag value="br" />
		</h:form>
	</t:htmlTag>
	<t:htmlTag value="span" rendered="#{viewSession.trackbackEnabled}">
		<h:form rendered='#{viewPage.mode=="ContentView"}'>
			<t:htmlTag value="div" styleClass="portlet-section-header">
				<h:outputText value="#{msgs['blogview.TrackbacksTitle']}" />
			</t:htmlTag>
			<h:outputText value="#{msgs['blogview.NoTrackbacks']}"
				rendered="#{viewPage.blogMessage.blogTrackbackSize==0}" />
			<t:dataTable var="blogTb"
				value="#{viewPage.blogMessage.sortedBlogTrackbacks}"
				rowClasses="portlet-section-body,portlet-section-alternate"
				style="width:100%"
				rendered="#{viewPage.blogMessage.blogTrackbackSize>0}">
				<h:column>
					<t:htmlTag value="div" styleClass="portlet-subsection-header"
						rendered="#{!blogTb.emptyTitle}">
						<h:outputText value="#{blogTb.title}" styleClass="portlet-font"
							escape="false" />
						<h:outputText value="(" styleClass="portlet-font" escape="false"
							rendered="#{!blogTb.emptyBlogname}" />
						<h:outputText value="#{blogTb.blogname}" styleClass="portlet-font"
							escape="false"
							rendered="#{!blogTb.emptyBlogname}" />
						<h:outputText value=")" styleClass="portlet-font" escape="false"
							rendered="#{!blogTb.emptyBlogname}" />
					</t:htmlTag>
					<t:htmlTag value="div" styleClass="portlet-subsection-header"
						rendered="#{blogTb.emptyTitle}">
						<h:outputText value="#{msgs['blogview.NoTitle']}"
							styleClass="portlet-font" escape="false" />
					</t:htmlTag>
					<t:htmlTag value="div" style="padding:3px"
						rendered="#{!blogTb.emptyExcerpt}">
						<h:outputText value="#{blogTb.excerpt}" styleClass="portlet-font"
							escape="true" />
					</t:htmlTag>
					<t:htmlTag value="div" styleClass="portlet-section-footer"
						style="text-align:right">
						<h:outputLink value="#{blogTb.url}">
							<f:verbatim>
								<h:outputText value="#{blogTb.url}" />
							</f:verbatim>
						</h:outputLink>
						<h:outputText value="|" />
						<h:outputText value="#{blogTb.formattedCreatedtime}" />
						<h:outputText value="|" rendered="#{blogTb.deleteEnabled}" />
						<h:commandLink action="#{viewPage.deleteTrackback}"
							rendered="#{blogTb.deleteEnabled}">
							<f:verbatim>
								<h:outputText value="#{msgs['blogview.Delete']}" />
							</f:verbatim>
						</h:commandLink>
					</t:htmlTag>
				</h:column>
			</t:dataTable>
		</h:form>
	</t:htmlTag>
</f:view>
