<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
	<f:loadBundle
		basename="jp.sf.pal.blog.resources.BlogTrackbackTitleViewResources"
		var="msgs" />
	<h:form>
		<t:dataTable id="titleView" var="blogTrackback"
			value="#{trackbackTitleViewPage.blogTrackbacks}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{trackbackTitleViewSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['blogtrackbacktitleview.TitleColumn']}" />
				</f:facet>
				<h:commandLink action="#{trackbackTitleViewPage.select}">
					<f:verbatim>
						<h:outputText value="#{blogTrackback['0'].abbreviatedTitle}" />
						<h:outputText value="#{msgs['blogtrackbacktitleview.NoTitle']}"
							rendered="#{blogTrackback['0'].title==null || blogTrackback['0'].title==''}" />
					</f:verbatim>
				</h:commandLink>
			</h:column>
			<h:column rendered="#{trackbackTitleViewSession.displayCreatedtime}">
				<f:facet name="header">
					<h:outputText
						value="#{msgs['blogtrackbacktitleview.CreatedDateColumn']}" />
				</f:facet>
				<h:outputText value="#{blogTrackback['0'].formattedCreatedtime}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="titleView" fastStep="10"
				pageCountVar="pageCount" pageIndexVar="pageIndex" paginator="true"
				paginatorMaxPages="5">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="titleView" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['blogtrackbacktitleview.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['blogtrackbacktitleview.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>
	</h:form>
</f:view>
