/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.model;

import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import jp.sf.pal.blog.AbstractTestCase;
import jp.sf.pal.blog.dao.BlogMessageDao;
import jp.sf.pal.blog.model.hatena.Comment;
import jp.sf.pal.blog.model.hatena.Day;
import jp.sf.pal.blog.model.hatena.Diary;
import jp.sf.pal.blog.model.hatena.HatenaUtil;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class HatenaModelTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HatenaModelTest.class);

    public static Long testId = null;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public HatenaModelTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new HatenaModelTest("parse"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void parse()
    {

        String filePath = "src/test/resources/hatena/export.xml";

        try
        {
            Diary diary = HatenaUtil.parse(filePath);
            if (log.isDebugEnabled())
            {
                Iterator i1 = diary.getDays().iterator();
                while (i1.hasNext())
                {
                    Day day = (Day) i1.next();
                    log.debug("day.getDate()=" + day.getDate());
                    log.debug("day.getTitle()=" + day.getTitle());
                    log.debug("day.getBody()=" + day.getBody());
                    Iterator i2 = day.getComments().iterator();
                    while (i2.hasNext())
                    {
                        Comment comment = (Comment) i2.next();
                        log.debug("comment.getUsername()=" + comment.getUsername());
                        log.debug("comment.getBody()=" + comment.getBody());
                        log.debug("comment.getTimestamp()=" + comment.getTimestamp());

                    }
                }
            }
            assertEquals(diary.getDays().size(), 3);
        }
        catch (FileNotFoundException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
