/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletPreferencesUtil;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.LocaleUtil;

public class BlogViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(BlogViewEditPageBean.class);

    private String owner;

    private Integer pageSize;

    private BlogViewSessionBean viewSession;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getViewSession().setOwner(owner);
            getViewSession().setPageSize(pageSize);

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogview.UpdatedParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getViewSession().setOwner(
                    FacesContext.getCurrentInstance().getExternalContext()
                            .getRemoteUser());
            getViewSession().setPageSize(
                    new Integer(BlogConstants.DEFAULT_PAGE_SIZE));

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return viewSession.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return viewSession.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the viewSession.
     */
    public BlogViewSessionBean getViewSession()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return viewSession;
    }

    /**
     * @param viewSession The viewSession to set.
     */
    public void setViewSession(BlogViewSessionBean viewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewSessionBean) - start");
        }

        this.viewSession = viewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewSessionBean) - end");
        }
    }

}
