/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import java.io.IOException;
import java.util.ArrayList;

import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletPreferencesUtil;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.LocaleUtil;

public class BlogTitleViewEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(BlogTitleViewEditPageBean.class);

    private String owner;

    private String sortColumn;

    private Integer pageSize;

    private Object[] displayedItems;

    private BlogTitleViewSessionBean titleViewSession;

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        try
        {
            getTitleViewSession().setOwner(owner);
            getTitleViewSession().setPageSize(pageSize);
            getTitleViewSession().setSortColumn(sortColumn);

            if (displayedItems != null)
            {
                String createdtime = BlogConstants.FALSE;
                String updatedtime = BlogConstants.FALSE;
                for (int i = 0; i < displayedItems.length; i++)
                {
                    if (displayedItems[i].equals(BlogMessage.CREATEDTIME))
                    {
                        createdtime = BlogConstants.TRUE;
                    }
                    else if (displayedItems[i].equals(BlogMessage.UPDATEDTIME))
                    {
                        updatedtime = BlogConstants.TRUE;
                    }
                }

                if (!getTitleViewSession().getDisplayCreatedtime().equals(
                        createdtime))
                {
                    getTitleViewSession().setDisplayCreatedtime(
                            new Boolean(createdtime));
                }
                if (!getTitleViewSession().getDisplayUpdatedtime().equals(
                        updatedtime))
                {
                    getTitleViewSession().setDisplayUpdatedtime(
                            new Boolean(updatedtime));
                }

                PortletPreferencesUtil.store();

                // i18n
                FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                        .getString(LocaleUtil.getLocale(),
                                "blogtitleview.UpdatedParameters"));

            }
            else
            {
                // i18n
                FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                        .getString(LocaleUtil.getLocale(),
                                "blogtitleview.TheSpecifiedItemsAreInvalid"));
                if (log.isDebugEnabled())
                {
                    log.debug("setDisplayedItems(Object[]) - items is null.");
                }
            }

        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogtitleview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (log.isDebugEnabled())
        {
            log.debug("reset() - start");
        }

        try
        {
            getTitleViewSession().setOwner(
                    FacesContext.getCurrentInstance().getExternalContext()
                            .getRemoteUser());
            getTitleViewSession().setPageSize(
                    new Integer(BlogConstants.DEFAULT_PAGE_SIZE));
            getTitleViewSession().setSortColumn(BlogMessage.CREATEDTIME);
            getTitleViewSession().setDisplayCreatedtime(
                    new Boolean(BlogConstants.FALSE));
            getTitleViewSession().setDisplayUpdatedtime(
                    new Boolean(BlogConstants.FALSE));

            PortletPreferencesUtil.store();

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogtitleview.UpdatedToDefaultParameters"));
        }
        catch (IOException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil
                    .getString(LocaleUtil.getLocale(),
                            "blogtitleview.SystemErrorOccurs"), e.toString());
            log.error(e);
        }

        if (log.isDebugEnabled())
        {
            log.debug("reset() - end");
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the pageSize.
     */
    public Integer getPageSize()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getPageSize() - end");
        }
        //        return pageSize;
        return titleViewSession.getPageSize();
    }

    /**
     * @param pageSize The pageSize to set.
     */
    public void setPageSize(Integer number)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - start");
        }

        this.pageSize = number;

        if (log.isDebugEnabled())
        {
            log.debug("setPageSize(Integer) - end");
        }
    }

    /**
     * @return Returns the owner.
     */
    public String getOwner()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getOwner() - end");
        }
        //return owner;
        return titleViewSession.getOwner();
    }

    /**
     * @param owner The owner to set.
     */
    public void setOwner(String targetUser)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - start");
        }

        this.owner = targetUser;

        if (log.isDebugEnabled())
        {
            log.debug("setOwner(String) - end");
        }
    }

    /**
     * @return Returns the titleViewSession.
     */
    public BlogTitleViewSessionBean getTitleViewSession()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return titleViewSession;
    }

    /**
     * @param titleViewSession The titleViewSession to set.
     */
    public void setTitleViewSession(BlogTitleViewSessionBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewSessionBean) - start");
        }

        this.titleViewSession = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewSessionBean) - end");
        }
    }

    /**
     * @return Returns the sortColumn.
     */
    public String getSortColumn()
    {
        return getTitleViewSession().getSortColumn();
    }

    /**
     * @param sortColumn The sortColumn to set.
     */
    public void setSortColumn(String sortColumn)
    {
        this.sortColumn = sortColumn;
    }

    public Object[] getDisplayedItems()
    {
        ArrayList items = new ArrayList();
        if (getTitleViewSession().getDisplayCreatedtime().booleanValue())
        {
            items.add(BlogMessage.CREATEDTIME);
        }
        if (getTitleViewSession().getDisplayUpdatedtime().booleanValue())
        {
            items.add(BlogMessage.UPDATEDTIME);
        }
        return items.toArray();
    }

    public void setDisplayedItems(Object[] items)
    {
        displayedItems = items;
    }

}
