      real*8 function Newton(Qmat,y,q,ay,a,b,z,w,rho,lambda,C
     &     ,mu,N,eps_g)

      implicit real*8(a-h,o-z)

      integer N,msize,MAX
      real*8 Qmat(N,N),y(N),a(N),b(N),z(N),w(N),rho(N),lambda
      real*8 q(N),ay
      real*8 mu,gnrm,eps_g,zeta,dl

      parameter (MAX=999)


c     for LAPACK
      integer,allocatable::IPIV(:)
      real*8,allocatable::H(:,:),g0(:)
      real*8,allocatable::g1(:),g2(:),g3(:),g4(:),g5(:)
      real*8,allocatable::x1(:),x2(:),x3(:),x4(:),x5(:)
      integer   LWORK,INFO

      msize=N+1
      allocate (IPIV(msize),H(msize,msize),g0(msize))
      allocate (g1(N),g2(N),g3(N),g4(N),g5(N))
      allocate (x1(N),x2(N),x3(N),x4(N),x5(N))

      do itr=1,MAX
c     calc gradient
        call dgemv('N', N, N, -1.d0, Qmat, N, a, 1, 0.d0, g1, 1)
        g1=g1+q-lambda*y-rho+z
        g2=mu-a*z
        g3=w-rho
        g4=mu-b*w
        g5=C-a-b
        zeta=ay-ddot(N,y,1,a,1)
        
c     convergence check
        gnrm=ddot(N,g1,1,g1,1)+ddot(N,g2,1,g2,1)+ddot(N,g3,1,g3,1)
     &       +ddot(N,g4,1,g4,1)+ddot(N,g5,1,g5,1)+zeta**2
        gnrm=sqrt(gnrm)/dble(5*N+1)
c        write(*,'(A16,I4,A7,1P,E24.15)') 'inner loop',itr,'gnrm=',gnrm
        if ( (gnrm .lt. mu .or. gnrm .lt. eps_g) .and. 
     &       itr .ge. 2 ) exit

c     calc Hessian
        H(1:N,1:N)=Qmat(1:N,1:N)
        x1=z/a+w/b
        do i=1,N
          H(i,i)=H(i,i)+x1(i)
        end do
        H(1:N,msize)=y
        H(msize,1:N)=y
        g0(1:N)=g1+g2/a-g3-g4/b+w*g5/b
        H(msize,msize)=0.d0
        g0(msize)=zeta
        
        call DGESV(msize, 1, H, msize, IPIV, g0, msize, INFO)

        x1=g0(1:N)
        x2=(g2-z*x1)/a
        x3=g5-x1
        x4=(g4-w*x3)/b
        x5=g3+x4
        dl=g0(msize)
        
        aa=1.d0
        do while (.true.)
          ii=0
          do i=1,N
            if (a(i)+aa*x1(i) .le. 0.d0 .or.
     &           b(i)+aa*x3(i) .le. 0.d0) then 
              ii=ii+1
              aa=aa*0.9d0
            end if
          end do
          if (ii .eq. 0) then
            exit
          end if
          if (aa .lt. 1.d-15) then
            goto 9999
          end if
        end do
        a=a+aa*x1
        b=b+aa*x3
        
        aa=1.d0
        do while (.true.)
          ii=0
          do i=1,N
            if (z(i)+aa*x2(i) .le. 0.d0 .or.
     &           w(i)+aa*x4(i) .le. 0.d0) then
              ii=ii+1
              aa=aa*0.9d0
            end if
          end do
          if (ii .eq. 0) then
            exit
          end if
          if (aa .lt. 1.d-15) then
            goto 9999
          end if
        end do
        z=z+aa*x2
        w=w+aa*x4
        
        rho=rho+x5
        lambda=lambda+dl
        
      end do

 9999 continue

      deallocate (IPIV,H,g0)
      deallocate (g1,g2,g3,g4,g5)
      deallocate (x1,x2,x3,x4,x5)

      Newton=gnrm

      return
      end 
