#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static FILE *fp;
static char *line;

void file_open_(char *input_file)
{
  char *p;

  p=strtok(input_file," ");
  if (p == NULL) p=input_file;
  fp=fopen(p,"r");
  if (fp ==NULL) exit(1);
  line=(char*)malloc(99999);
}

void file_close_(void)
{
  char *p;

  free(line);
  fclose(fp);
}

void analysis_(char *input_file, int *NN, int *MM)
{
  char *p;
  int  max_dim=0,n_data=0,n_dim;

  line=(char*)malloc(99999);

  p=strtok(input_file," ");
  if (p == NULL) p=input_file;
  fp=fopen(p,"r");

  while (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    n_data++;
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    n_dim=0;
    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) n_dim++;
    }
    if (n_dim > max_dim) max_dim=n_dim;
  }
  *NN=n_data;
  *MM=max_dim;

  fclose(fp);
  free(line);
}

void read_df_(char *input_file, double *y, double *x)
{
  char *p;

  line=(char*)malloc(99999);

  p=strtok(input_file," ");
  if (p == NULL) p=input_file;
  fp=fopen(p,"r");

  while (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *y=atof(p); y++;

    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	*x=atof(p);
	x++;
      }
    }
  }

  fclose(fp);
  free(line);
}

void read_sf_(char *input_file, double *y, double *x, int *pt, int *nd
	      ,int *NN, int *MM, int *imax)
{
  char   *p,*q;
  int    n,*tpt;
  double *tx;

  line=(char*)malloc(99999);

  p=strtok(input_file," ");
  if (p == NULL) p=input_file;
  fp=fopen(p,"r");

  *imax=0;
  while (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *y=atof(p); y++;

    n=0;
    tx=x; tpt=pt;
    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	q=strchr(p,':'); *q='\0'; q++;
	*pt=atoi(p);
	*x=atof(q);
	if (*pt > *imax) *imax=*pt;
	pt++;
	x++;
	n++;
      }
    }
    *nd=n; nd++;
    x=tx+(*MM); pt=tpt+(*MM);
  }

  fclose(fp);
  free(line);
}

void write_model_df_(char *output_file, double *y, double *a, double *x, double *b
		     , int *NN, int *MM, double *eps
		     , double *Cost, double *gamma, double *u1, double *u2, double *u3
		     , double *probA, double *probB)
{
  int i,j,k,n;
  char *p;

  p=strtok(output_file," ");
  if (p == NULL) p=output_file;
  fp=fopen(p,"w");

  n=0;
  for (i=0;i<(*NN);i++) {
    if (a[i] >= *eps) n++;
  }

  fprintf(fp,"%d %d 0\n",n,*MM);
  fprintf(fp,"%10.4f %10.4f %10.4f %10.4f %10.4f\n",*Cost,*gamma,*u1,*u2,*u3);
  fprintf(fp,"%24.15E %24.15E\n",*probA,*probB);
  fprintf(fp,"%24.15E\n",*b);
  for (i=0;i<(*NN);i++) {
    if (a[i] >= *eps) {
      fprintf(fp,"%4.1f %24.15E ",y[i],a[i]);
      for (j=0;j<(*MM);j++) {
	fprintf(fp,"%24.15E ",x[j+(*MM)*i]);
      }
      fprintf(fp,"\n");
    }
  }
  
  fclose(fp);
}

void write_model_sf_(char *output_file, double *y, double *a, double *x, int *pt, int *nd, double *b
		     , int *NN, int *MM, double *eps
		     , double *Cost, double *gamma, double *u1, double *u2, double *u3
		     , double *probA, double *probB)
{
  int i,j,k,n;
  char *p;

  p=strtok(output_file," ");
  if (p == NULL) p=output_file;
  fp=fopen(p,"w");

  n=0;
  for (i=0;i<(*NN);i++) {
    if (a[i] >= *eps) n++;
  }

  fprintf(fp,"%d %d 1\n",n,*MM);
  fprintf(fp,"%10.4f %10.4f %10.4f %10.4f %10.4f\n",*Cost,*gamma,*u1,*u2,*u3);
  fprintf(fp,"%24.15E %24.15E\n",*probA,*probB);
  fprintf(fp,"%24.15E\n",*b);
  for (i=0;i<(*NN);i++) {
    if (a[i] >= *eps) {
      fprintf(fp,"%4.1f %24.15E ",y[i],a[i]);
      for (j=0;j<nd[i];j++) {
	fprintf(fp,"%d:%-24.15E ",pt[j+(*MM)*i],x[j+(*MM)*i]);
      }
      fprintf(fp,"\n");
    }
  }
  
  fclose(fp);
}

void read_model_df_(char *model_file, double *y, double *a, double *x)
{
  char *p;

  line=(char*)malloc(99999);

  p=strtok(model_file," ");
  if (p == NULL) p=model_file;
  fp=fopen(p,"r");

  fgets(line,99999,fp);
  fgets(line,99999,fp);
  fgets(line,99999,fp);
  fgets(line,99999,fp);

  while (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *y=atof(p); y++;

    p=strtok(NULL," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *a=atof(p); a++;

    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	*x=atof(p);
	x++;
      }
    }
  }

  
  fclose(fp);
  free(line);
}

int read_line_df_(char *name, double *z)
{
  char *p;

  if (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    strcpy(name,p);
    name[strlen(p)]=' ';
    
    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	*z=atof(p);
	z++;
      }
    }
    return(1);
  }
  else {
    return(0);
  }

}

void read_model_sf_(char *model_file, double *y, double *a, double *x
		    , int *pt, int *nd, int *MM, int *imax)
{
  char *p,*q;
  int n,*tpt;
  double *tx;

  line=(char*)malloc(99999);

  p=strtok(model_file," ");
  if (p == NULL) p=model_file;
  fp=fopen(p,"r");

  fgets(line,99999,fp);
  fgets(line,99999,fp);
  fgets(line,99999,fp);
  fgets(line,99999,fp);

  *imax=0;
  while (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *y=atof(p); y++;

    p=strtok(NULL," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    *a=atof(p); a++;

    n=0;
    tx=x; tpt=pt;
    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	q=strchr(p,':'); *q='\0'; q++;
	*pt=atoi(p);
	*x=atof(q);
	if (*pt > *imax) *imax=*pt;
	pt++;
	x++;
	n++;
      }
    }
    *nd=n; nd++;
    x=tx+(*MM); pt=tpt+(*MM);
  }

  fclose(fp);
  free(line);
}

int read_line_sf_(char *name, double *z, int *qt, int *md)
{
  char *p,*q;
  int  n;
  
  if (fgets(line,99999,fp) != NULL) {
    line[strlen(line)-1]='\0';
    p=strtok(line," ");
    if (strlen(p) == 0) {
      while (1) {
	p=strtok(NULL," ");
	if (strlen(p) > 0) break;
      }
    }
    strcpy(name,p);
    name[strlen(p)]=' ';
    
    n=0;
    while ((p=strtok(NULL," ")) != NULL) {
      if (strlen(p) > 0) {
	q=strchr(p,':'); *q='\0'; q++;
	*qt=atoi(p);
	*z=atof(q);
	qt++;
	z++;
	n++;
      }
    }
    *md=n;
    return(1);
  }
  else {
    return(0);
  }

}
