/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Syntax;

final class LineElement
implements Element,
Position {
    private final LineRootElement root;
    private final Position startPos;
    private final Position endPos;
    private AttributeSet attributes = null;
    private Syntax.StateInfo syntaxStateInfo;

    LineElement(LineRootElement lineRootElement, Position position, Position position2) {
        assert (position != null);
        assert (position2 != null);
        this.root = lineRootElement;
        this.startPos = position;
        this.endPos = position2;
    }

    public Document getDocument() {
        return this.root.getDocument();
    }

    public int getOffset() {
        return this.getStartOffset();
    }

    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    Position getStartPosition() {
        return this.startPos;
    }

    public int getEndOffset() {
        return this.endPos.getOffset();
    }

    Position getEndPosition() {
        return this.endPos;
    }

    public Element getParentElement() {
        return this.root;
    }

    public String getName() {
        return "paragraph";
    }

    public AttributeSet getAttributes() {
        AttributeSet attributeSet = this.attributes;
        return attributeSet == null ? SimpleAttributeSet.EMPTY : attributeSet;
    }

    public void setAttributes(AttributeSet attributeSet) {
        this.attributes = attributeSet;
    }

    public int getElementIndex(int n) {
        return -1;
    }

    public int getElementCount() {
        return 0;
    }

    public Element getElement(int n) {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    Syntax.StateInfo getSyntaxStateInfo() {
        return this.syntaxStateInfo;
    }

    void updateSyntaxStateInfo(Syntax syntax) {
        if (this.syntaxStateInfo == null) {
            this.syntaxStateInfo = syntax.createStateInfo();
            assert (this.syntaxStateInfo != null);
        }
        syntax.storeState(this.syntaxStateInfo);
    }

    void clearSyntaxStateInfo() {
        this.syntaxStateInfo = null;
    }

    public String toString() {
        return "getStartOffset()=" + this.getStartOffset() + ", getEndOffset()=" + this.getEndOffset() + ", syntaxStateInfo=" + this.getSyntaxStateInfo();
    }
}

