/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PositionFinderVisitor
implements XMLNodeVisitor {
    int position = 0;
    Node node;
    boolean found;

    public int findPosition(Node node, Node node2) {
        this.reset();
        this.node = node2;
        node.accept(this);
        return this.position;
    }

    public void reset() {
        this.position = 0;
        this.found = false;
    }

    public void visit(Document document) {
        this.position += this.getLengthOfTokens(document);
        NodeList nodeList = document.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = (Node)nodeList.item(i);
            node.accept(this);
            if (!this.found) continue;
            return;
        }
    }

    public void visit(Element element) {
        if (element.getId() == this.node.getId()) {
            this.found = true;
        } else {
            this.position += this.getElementStartTokenLength(element, true);
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = (Node)namedNodeMap.item(i);
                node.accept(this);
                if (!this.found) continue;
                return;
            }
            this.position += this.getStartTagWhiteSpaceTokensLength(element);
            ++this.position;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = (Node)nodeList.item(i);
                node.accept(this);
                if (!this.found) continue;
                return;
            }
            this.position += this.getElementStartTokenLength(element, false);
            this.position += this.getEndTagWhiteSpaceTokensLength(element);
            ++this.position;
        }
    }

    public void visit(Text text) {
        if (text.getId() == this.node.getId()) {
            this.found = true;
        } else {
            int n = this.getLength(text);
            if (n > 0) {
                this.position += n;
            }
        }
    }

    public void visit(Attribute attribute) {
        if (attribute.getId() == this.node.getId()) {
            this.position += this.getLeadingWhiteSpaces(attribute);
            this.found = true;
        } else {
            this.position += this.getLengthOfTokens(attribute);
        }
    }

    private int getLength(Text text) {
        int n = 0;
        for (Token token : text.getTokens()) {
            n += token.getValue().length();
        }
        return n;
    }

    private int getElementStartTokenLength(Element element, boolean bl) {
        String string = "";
        List<Token> list = element.getTokens();
        for (Token token : list) {
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String string2 = token.getValue();
            if (bl) {
                if (string2.startsWith("</")) continue;
                string = string2;
                continue;
            }
            if (!string2.startsWith("</")) continue;
            string = string2;
        }
        return string.length();
    }

    private int getStartTagWhiteSpaceTokensLength(NodeImpl nodeImpl) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Token> list = nodeImpl.getTokens();
        for (Token token : list) {
            if (token.getType() == TokenType.TOKEN_ELEMENT_END_TAG) break;
            if (token.getType() != TokenType.TOKEN_WHITESPACE) continue;
            stringBuilder.append(token.getValue());
        }
        return stringBuilder.toString().length();
    }

    private int getEndTagWhiteSpaceTokensLength(NodeImpl nodeImpl) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Token> list = nodeImpl.getTokens();
        boolean bl = false;
        for (Token token : list) {
            if (token.getType() == TokenType.TOKEN_ELEMENT_START_TAG && token.getValue().startsWith("</")) {
                bl = true;
            }
            if (!bl || token.getType() != TokenType.TOKEN_WHITESPACE) continue;
            stringBuilder.append(token.getValue());
        }
        return stringBuilder.toString().length();
    }

    private int getLeadingWhiteSpaces(Attribute attribute) {
        Token token = attribute.getTokens().get(0);
        if (token.getType() == TokenType.TOKEN_WHITESPACE) {
            return token.getValue().length();
        }
        return 0;
    }

    private int getLengthOfTokens(NodeImpl nodeImpl) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Token> list = nodeImpl.getTokens();
        for (Token token : list) {
            stringBuilder.append(token.getValue());
        }
        return stringBuilder.length();
    }
}

