/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.JoinTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListList<T extends TokenId>
extends GapList<EmbeddedTokenList<T>> {
    private final TokenList<?> rootTokenList;
    private final LanguagePath languagePath;
    private boolean joinSections;
    private Set<Language<?>> childrenLanguages;
    private static final EmbeddedTokenList<?>[] EMPTY_TOKEN_LIST_ARRAY = new EmbeddedTokenList[0];

    public TokenListList(TokenList<?> tokenList, LanguagePath languagePath) {
        super(4);
        Object object;
        this.rootTokenList = tokenList;
        this.languagePath = languagePath;
        this.childrenLanguages = Collections.emptySet();
        assert (languagePath.size() >= 2);
        Language language = LexerUtilsConstants.innerLanguage(languagePath);
        if (languagePath.size() > 2) {
            object = tokenList.tokenHierarchyOperation().tokenListList(languagePath.parent());
            for (int i = 0; i < object.size(); ++i) {
                TokenList tokenList2 = (TokenList)object.get(i);
                this.scanTokenList(tokenList2, language);
            }
        } else {
            this.scanTokenList(tokenList, language);
        }
        if (this.joinSections) {
            JoinTokenList.create(this, 0, this.size());
        } else {
            object = this.iterator();
            while (object.hasNext()) {
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)object.next();
                assert (!embeddedTokenList.embedding().joinSections());
                if (embeddedTokenList.tokenCountCurrent() != 0 || embeddedTokenList.textLength() <= 0) continue;
                embeddedTokenList.initAllTokens();
            }
        }
    }

    private void scanTokenList(TokenList<?> tokenList, Language<T> language) {
        int n = tokenList.tokenCount();
        Set<Language<?>> set = Collections.singleton(language);
        for (int i = 0; i < n; ++i) {
            EmbeddedTokenList embeddedTokenList = EmbeddingContainer.embeddedTokenList(tokenList, i, set, false);
            if (embeddedTokenList == null) continue;
            this.add(embeddedTokenList);
            if (!embeddedTokenList.embedding().joinSections()) continue;
            this.joinSections = true;
        }
    }

    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public boolean joinSections() {
        return this.joinSections;
    }

    public void setJoinSections(boolean bl) {
        this.joinSections = bl;
    }

    public void notifyChildAdded(Language<?> language) {
        if (this.childrenLanguages.size() == 0) {
            this.childrenLanguages = new HashSet();
        }
        boolean bl = this.childrenLanguages.add(language);
        assert (bl) : "Children language " + language.mimeType() + " already contained.";
    }

    public void notifyChildRemoved(Language<?> language) {
        boolean bl = this.childrenLanguages.remove(language);
        assert (bl) : "Children language " + language.mimeType() + " not contained.";
    }

    public boolean hasChildren() {
        return this.childrenLanguages.size() > 0;
    }

    public Set<Language<?>> childrenLanguages() {
        return this.childrenLanguages;
    }

    public EmbeddedTokenList<T> getOrNull(int n) {
        return n < this.size() ? (EmbeddedTokenList)this.get(n) : null;
    }

    public EmbeddedTokenList<T>[] replace(int n, int n2, List<EmbeddedTokenList<T>> list) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = n2 > 0 ? new EmbeddedTokenList[n2] : EMPTY_TOKEN_LIST_ARRAY;
        if (n2 > 0) {
            this.copyElements(n, n + n2, objectArray, 0);
            this.remove(n, n2);
        }
        this.addAll(n, list);
        return objectArray;
    }

    public TokenList<?> rootTokenList() {
        return this.rootTokenList;
    }

    void childAdded() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public int findIndex(int n) {
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = n3 + n2 >>> 1;
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(n4);
            embeddedTokenList.embeddingContainer().updateStatus();
            int n5 = embeddedTokenList.startOffset() - n;
            if (n5 < 0) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 - 1;
                continue;
            }
            n3 = n4;
            break;
        }
        return n3;
    }

    public int findIndexDuringUpdate(EmbeddedTokenList<T> embeddedTokenList, TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        int n = this.size() - 1;
        int n2 = 0;
        int n3 = LexerUtilsConstants.updatedStartOffset(embeddedTokenList, tokenHierarchyEventInfo);
        block0: while (n2 <= n) {
            int n4 = n2 + n >>> 1;
            EmbeddedTokenList embeddedTokenList2 = (EmbeddedTokenList)this.get(n4);
            int n5 = LexerUtilsConstants.updatedStartOffset(embeddedTokenList2, tokenHierarchyEventInfo);
            int n6 = n5 - n3;
            if (n6 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n6 > 0) {
                n = n4 - 1;
                continue;
            }
            n2 = n4;
            if (embeddedTokenList2 == embeddedTokenList) break;
            while (--n2 >= 0) {
                embeddedTokenList2 = (EmbeddedTokenList)this.get(n2);
                if (embeddedTokenList2 == embeddedTokenList) {
                    return n2;
                }
                if (LexerUtilsConstants.updatedStartOffset(embeddedTokenList2, tokenHierarchyEventInfo) == n3) continue;
            }
            n2 = n4;
            while (++n2 < this.size()) {
                embeddedTokenList2 = (EmbeddedTokenList)this.get(n2);
                if (embeddedTokenList2 == embeddedTokenList) {
                    return n2;
                }
                if (LexerUtilsConstants.updatedStartOffset(embeddedTokenList2, tokenHierarchyEventInfo) == n3) continue;
                break block0;
            }
            break block0;
        }
        return n2;
    }

    public String checkConsistency() {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(i);
            embeddedTokenList.embeddingContainer().updateStatusUnsync();
            if (embeddedTokenList.isRemoved()) {
                return "TOKEN-LIST-LIST Removed token list at index=" + i + '\n' + (Object)((Object)this);
            }
            if (embeddedTokenList.startOffset() < n) {
                return "TOKEN-LIST-LIST Invalid start offset at index=" + i + ": etl[" + i + "].startOffset()=" + embeddedTokenList.startOffset() + " < lastEndOffset=" + n + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.startOffset() > embeddedTokenList.endOffset()) {
                return "TOKEN-LIST-LIST Invalid end offset at index=" + i + ": etl[" + i + "].startOffset()=" + embeddedTokenList.startOffset() + " > etl[" + i + "].endOffset()=" + embeddedTokenList.endOffset() + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.embeddingContainer() == null) {
                return "TOKEN-LIST-LIST Null ec at index=" + i + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.embeddingContainer().isRemoved()) {
                return "TOKEN-LIST-LIST Removed ec at index=" + i + "\n" + (Object)((Object)this);
            }
            n = embeddedTokenList.endOffset();
        }
        if (this.joinSections() && this.size() > 0) {
            return ((EmbeddedTokenList)this.get(0)).joinTokenList().checkConsistency();
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        if (this.joinSections()) {
            stringBuilder.append("J");
        }
        stringBuilder.append("TLL for \"");
        stringBuilder.append(this.languagePath().mimePath()).append('\"');
        if (this.hasChildren()) {
            stringBuilder.append(", hasChildren");
        }
        stringBuilder.append('\n');
        int n = ArrayUtilities.digitCount((int)this.size());
        for (int i = 0; i < this.size(); ++i) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(i);
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n);
            EmbeddingContainer<?> embeddingContainer = embeddedTokenList.embeddingContainer();
            embeddingContainer.updateStatus();
            embeddedTokenList.dumpInfo(stringBuilder);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

