/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.options.MacroInputPanel;
import org.netbeans.modules.editor.options.MacrosEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MacrosEditorPanel
extends JPanel {
    PairStringModel model;
    private MacrosEditor editor;
    private FontSizeTable macrosTable;
    private JButton addButton;
    private JButton editButton;
    private JScrollPane macrosPane;
    private JButton removeButton;

    public MacrosEditorPanel(MacrosEditor macrosEditor) {
        this.editor = macrosEditor;
        this.model = new PairStringModel();
        this.initComponents();
        this.macrosTable = new FontSizeTable();
        this.macrosTable.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.macrosTable.setModel(this.model);
        this.macrosTable.setShowVerticalLines(false);
        this.macrosTable.setShowHorizontalLines(false);
        this.macrosTable.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.macrosTable.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(3000);
        tableColumnModel.getColumn(0).setPreferredWidth(30);
        tableColumnModel.getColumn(1).setMaxWidth(7000);
        tableColumnModel.getColumn(1).setPreferredWidth(70);
        this.macrosPane.setViewportView(this.macrosTable);
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP"));
        this.macrosTable.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_MEP_Table"));
        this.macrosTable.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Table"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_MEP_Remove"));
        this.enableButtons(false);
        this.macrosTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getAncestorOfClass(Window.class, MacrosEditorPanel.this).setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.macrosTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (MacrosEditorPanel.this.macrosTable.getRowCount() == 0) {
                    MacrosEditorPanel.this.enableButtons(false);
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                MacrosEditorPanel.this.enableButtons(!listSelectionModel.isSelectionEmpty());
            }
        });
    }

    private void enableButtons(boolean bl) {
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    private String getBundleString(String string) {
        return NbBundle.getMessage(MacrosEditorPanel.class, (String)string);
    }

    public void setValue(Map map) {
        HashMap hashMap = map != null ? new HashMap(map) : new HashMap();
        if (hashMap.containsKey(null)) {
            hashMap.remove(null);
        }
        this.model.setData(new TreeMap(hashMap));
        if (this.model.getRowCount() > 0) {
            this.macrosTable.setRowSelectionInterval(0, 0);
        }
    }

    public Map getValue() {
        return this.model.getData();
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void initComponents() {
        this.macrosPane = new JScrollPane();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.macrosPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)this.getBundleString("MEP_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)this.getBundleString("MEP_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)this.getBundleString("MEP_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacrosEditorPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getMacro(null);
        if (stringArray == null) {
            return;
        }
        int n = this.model.putPair(stringArray);
        this.macrosTable.setRowSelectionInterval(n, n);
        this.notifyEditor();
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.macrosTable.getSelectedRow();
        if (n != -1) {
            String[] stringArray = this.model.getPair(n);
            if ((stringArray = this.getMacro(stringArray)) != null) {
                this.model.removePair(n);
                n = this.model.putPair(stringArray);
                this.macrosTable.setRowSelectionInterval(n, n);
                this.notifyEditor();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.macrosTable.getSelectedRow();
        if (n != -1) {
            this.model.removePair(n);
            if (n >= this.model.getRowCount()) {
                --n;
            }
            if (n >= 0) {
                this.macrosTable.setRowSelectionInterval(n, n);
            }
            this.notifyEditor();
        }
    }

    private String[] getMacro(String[] stringArray) {
        String[] stringArray2;
        MacroInputPanel macroInputPanel = new MacroInputPanel();
        HelpCtx.setHelpIDString((JComponent)macroInputPanel, HelpCtx.findHelp((Component)this) != null ? HelpCtx.findHelp((Component)this).getHelpID() : null);
        if (stringArray != null) {
            macroInputPanel.setMacro(stringArray);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)macroInputPanel, this.getBundleString("MEP_EnterMacro"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        macroInputPanel.requestFocus();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && !"".equals((stringArray2 = macroInputPanel.getMacro())[0])) {
            int n = this.model.containsKey(stringArray2[0]);
            if (n >= 0) {
                if (stringArray != null && stringArray[0].equals(stringArray2[0])) {
                    return stringArray2;
                }
                String[] stringArray3 = this.model.getPair(n);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MacrosEditorPanel.class, (String)"MEP_Overwrite", (Object)stringArray2[0]), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    return null;
                }
            }
            return stringArray2;
        }
        return null;
    }

    private final class FontSizeTable
    extends JTable {
        private boolean needCalcRowHeight = true;

        private FontSizeTable() {
        }

        public void updateUI() {
            super.updateUI();
            this.needCalcRowHeight = true;
        }

        public void paint(Graphics graphics) {
            if (this.needCalcRowHeight) {
                this.calcRowHeight(graphics);
            }
            super.paint(graphics);
        }

        private void calcRowHeight(Graphics graphics) {
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            this.needCalcRowHeight = false;
            this.setRowHeight(n);
        }
    }

    private class PairStringModel
    extends AbstractTableModel {
        String[] columns;
        TreeMap data;
        String[] keys;

        public PairStringModel() {
            this.columns = new String[]{MacrosEditorPanel.this.getBundleString("MEP_MacroTitle"), MacrosEditorPanel.this.getBundleString("MEP_ExpandTitle")};
            this.data = new TreeMap();
            this.keys = new String[0];
        }

        public void setData(TreeMap treeMap) {
            this.data = treeMap;
            this.updateKeys();
        }

        private void updateKeys() {
            this.keys = this.data.keySet().toArray(new String[0]);
            this.fireTableDataChanged();
        }

        public TreeMap getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.columns[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.keys[n];
            }
            return this.data.get(this.keys[n]);
        }

        public int putPair(String[] stringArray) {
            this.data.put(stringArray[0], stringArray[1]);
            this.updateKeys();
            return Arrays.binarySearch(this.keys, stringArray[0]);
        }

        public void removePair(int n) {
            this.data.remove(this.getValueAt(n, 0));
            this.updateKeys();
        }

        public String[] getPair(int n) {
            String string = (String)this.getValueAt(n, 0);
            String[] stringArray = new String[]{string, (String)this.data.get(string)};
            return stringArray;
        }

        public int containsKey(String string) {
            return Arrays.binarySearch(this.keys, string);
        }
    }
}

