/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DataFilesProviderImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectOperations {
    private ProjectOperations() {
    }

    public static List<FileObject> getMetadataFiles(Project project) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (DataFilesProviderImplementation dataFilesProviderImplementation : project.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
            arrayList.addAll(dataFilesProviderImplementation.getMetadataFiles());
            assert (!arrayList.contains(null)) : "Nulls in " + arrayList + " from " + dataFilesProviderImplementation;
        }
        return arrayList;
    }

    public static List<FileObject> getDataFiles(Project project) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (DataFilesProviderImplementation dataFilesProviderImplementation : project.getLookup().lookupAll(DataFilesProviderImplementation.class)) {
            arrayList.addAll(dataFilesProviderImplementation.getDataFiles());
            assert (!arrayList.contains(null)) : "Nulls in " + arrayList + " from " + dataFilesProviderImplementation;
        }
        return arrayList;
    }

    public static boolean isDeleteOperationSupported(Project project) {
        return project.getLookup().lookup(DeleteOperationImplementation.class) != null;
    }

    public static void notifyDeleting(Project project) throws IOException {
        for (DeleteOperationImplementation deleteOperationImplementation : project.getLookup().lookupAll(DeleteOperationImplementation.class)) {
            deleteOperationImplementation.notifyDeleting();
        }
    }

    public static void notifyDeleted(Project project) throws IOException {
        for (DeleteOperationImplementation deleteOperationImplementation : project.getLookup().lookupAll(DeleteOperationImplementation.class)) {
            deleteOperationImplementation.notifyDeleted();
        }
    }

    public static boolean isCopyOperationSupported(Project project) {
        return project.getLookup().lookup(CopyOperationImplementation.class) != null;
    }

    public static void notifyCopying(Project project) throws IOException {
        for (CopyOperationImplementation copyOperationImplementation : project.getLookup().lookupAll(CopyOperationImplementation.class)) {
            copyOperationImplementation.notifyCopying();
        }
    }

    public static void notifyCopied(Project project, Project project2, File file, String string) throws IOException {
        for (CopyOperationImplementation copyOperationImplementation : project.getLookup().lookupAll(CopyOperationImplementation.class)) {
            copyOperationImplementation.notifyCopied(null, file, string);
        }
        for (CopyOperationImplementation copyOperationImplementation : project2.getLookup().lookupAll(CopyOperationImplementation.class)) {
            copyOperationImplementation.notifyCopied(project, file, string);
        }
    }

    public static void notifyMoving(Project project) throws IOException {
        for (MoveOperationImplementation moveOperationImplementation : project.getLookup().lookupAll(MoveOperationImplementation.class)) {
            moveOperationImplementation.notifyMoving();
        }
    }

    public static void notifyMoved(Project project, Project project2, File file, String string) throws IOException {
        for (MoveOperationImplementation moveOperationImplementation : project.getLookup().lookupAll(MoveOperationImplementation.class)) {
            moveOperationImplementation.notifyMoved(null, file, string);
        }
        for (MoveOperationImplementation moveOperationImplementation : project2.getLookup().lookupAll(MoveOperationImplementation.class)) {
            moveOperationImplementation.notifyMoved(project, file, string);
        }
    }

    public static boolean isMoveOperationSupported(Project project) {
        return project.getLookup().lookup(MoveOperationImplementation.class) != null;
    }
}

