/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileOwnerQuery {
    private static final Logger LOG = Logger.getLogger(FileOwnerQuery.class.getName());
    private static Lookup.Result<FileOwnerQueryImplementation> implementations;
    private static List<FileOwnerQueryImplementation> cache;
    public static final int EXTERNAL_ALGORITHM_TRANSIENT = 0;

    private FileOwnerQuery() {
    }

    public static Project getOwner(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to FileOwnerQuery.getOwner(FileObject)");
        }
        FileObject fileObject2 = FileUtil.getArchiveFile((FileObject)fileObject);
        if (fileObject2 != null) {
            fileObject = fileObject2;
        }
        for (FileOwnerQueryImplementation fileOwnerQueryImplementation : FileOwnerQuery.getInstances()) {
            Project project = fileOwnerQueryImplementation.getOwner(fileObject);
            if (project == null) continue;
            LOG.log(Level.FINE, "getOwner({0}) -> {1} from {2}", new Object[]{fileObject, project, fileOwnerQueryImplementation});
            return project;
        }
        LOG.log(Level.FINE, "getOwner({0}) -> nil", fileObject);
        return null;
    }

    public static Project getOwner(URI uRI) {
        if (uRI.isOpaque() && "jar".equalsIgnoreCase(uRI.getScheme())) {
            Object object = uRI.getSchemeSpecificPart();
            int n = ((String)object).lastIndexOf(33);
            if (n > 0) {
                object = ((String)object).substring(0, n);
            }
            try {
                object = ((String)object).replace("#", "%23");
                uRI = new URI((String)object);
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    URL uRL = new URL((String)object);
                    uRI = new File(uRL.getPath()).toURI();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    assert (false) : object;
                    return null;
                }
            }
        } else if (!uRI.isAbsolute() || uRI.isOpaque()) {
            throw new IllegalArgumentException("Bad URI: " + uRI);
        }
        for (FileOwnerQueryImplementation fileOwnerQueryImplementation : FileOwnerQuery.getInstances()) {
            Project project = fileOwnerQueryImplementation.getOwner(uRI);
            if (project == null) continue;
            LOG.log(Level.FINE, "getOwner({0}) -> {1} from {2}", new Object[]{uRI, project, fileOwnerQueryImplementation});
            return project;
        }
        LOG.log(Level.FINE, "getOwner({0}) -> nil", uRI);
        return null;
    }

    static void reset() {
        SimpleFileOwnerQueryImplementation.reset();
    }

    public static void markExternalOwner(FileObject fileObject, Project project, int n) throws IllegalArgumentException {
        LOG.log(Level.FINE, "markExternalOwner({0}, {1}, {2})", new Object[]{fileObject, project, n});
        switch (n) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(fileObject, project);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + n);
            }
        }
    }

    public static void markExternalOwner(URI uRI, Project project, int n) throws IllegalArgumentException {
        LOG.log(Level.FINE, "markExternalOwner({0}, {1}, {2})", new Object[]{uRI, project, n});
        switch (n) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(uRI, project);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + n);
            }
        }
    }

    private static synchronized List<FileOwnerQueryImplementation> getInstances() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookupResult(FileOwnerQueryImplementation.class);
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent lookupEvent) {
                    Class<FileOwnerQuery> clazz = FileOwnerQuery.class;
                    synchronized (FileOwnerQuery.class) {
                        cache = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList<FileOwnerQueryImplementation>(implementations.allInstances());
        }
        return cache;
    }
}

