/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.impl.SampleProviderHelper;
import org.netbeans.modules.db.mysql.spi.sample.SampleProvider;
import org.netbeans.modules.db.mysql.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleManager {
    public static List<String> getSampleNames() {
        Collection<SampleProvider> collection = SampleProviderHelper.getProviders();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SampleProvider sampleProvider : collection) {
            arrayList.addAll(sampleProvider.getSampleNames());
        }
        return arrayList;
    }

    public static boolean isSample(String string) {
        Collection<SampleProvider> collection = SampleProviderHelper.getProviders();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SampleProvider sampleProvider : collection) {
            arrayList.addAll(sampleProvider.getSampleNames());
        }
        return arrayList.contains(string);
    }

    private static SampleProvider getProvider(String string) {
        Collection<SampleProvider> collection = SampleProviderHelper.getProviders();
        for (SampleProvider sampleProvider : collection) {
            if (!sampleProvider.supportsSample(string)) continue;
            return sampleProvider;
        }
        return null;
    }

    public static void createSample(String string, DatabaseConnection databaseConnection) throws DatabaseException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("You can not call this method from the event dispatch thread");
        }
        SampleProvider sampleProvider = SampleManager.getProvider(string);
        if (sampleProvider == null) {
            throw new DatabaseException(Utils.getMessage("MSG_NoSuchSample", string));
        }
        sampleProvider.create(string, databaseConnection);
    }
}

