/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.api.VisualSQLEditorMetaData;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalVSEMetaDataImpl
implements VisualSQLEditorMetaData {
    private DatabaseMetaData databaseMetaData = null;
    private DatabaseConnection dbconn;
    private List<String> schemas;
    private List<List<String>> allTables = null;
    private int hashSizeForTables = 30;
    private Hashtable fkExportedTable = new Hashtable(30);
    private Hashtable fkImportedTable = new Hashtable(30);
    private Hashtable columnNameTable = new Hashtable(30);
    private Hashtable allColumnsTable = new Hashtable(400);
    private Hashtable pkTable = new Hashtable(30);
    private String identifierQuoteString = null;

    public InternalVSEMetaDataImpl(DatabaseConnection databaseConnection) {
        this.dbconn = databaseConnection;
        try {
            this.initMetaData();
        }
        catch (SQLException sQLException) {
            Log.getLogger().warning("Could not create cache for " + sQLException.getLocalizedMessage());
        }
    }

    @Override
    public List<String> getSchemas() {
        if (this.schemas != null) {
            return this.schemas;
        }
        this.schemas = new ArrayList<String>();
        this.schemas.add(this.dbconn.getSchema());
        return this.schemas;
    }

    @Override
    public List<List<String>> getTables() throws SQLException {
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if (this.allTables != null) {
            return this.allTables;
        }
        Log.getLogger().finest(" loading tables");
        this.allTables = new ArrayList<List<String>>();
        List<String> list = this.getSchemas();
        if (list != null && list.size() > 0) {
            for (String string : list) {
                Log.getLogger().finest("  schema: " + string);
                ResultSet resultSet = this.databaseMetaData.getTables(null, string, "%", new String[]{"TABLE", "VIEW"});
                while (resultSet.next()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(resultSet.getString("TABLE_SCHEM"));
                    arrayList.add(resultSet.getString("TABLE_NAME"));
                    this.allTables.add(arrayList);
                }
            }
        } else {
            Log.getLogger().finest(" all schemas");
            ResultSet resultSet = this.databaseMetaData.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            while (resultSet.next()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(resultSet.getString("TABLE_SCHEM"));
                arrayList.add(resultSet.getString("TABLE_NAME"));
                this.allTables.add(arrayList);
            }
        }
        Log.getLogger().finest(" tables loaded " + this.allTables.size());
        return this.allTables;
    }

    @Override
    public List<String> getColumns(String string, String string2) throws SQLException {
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getColumns", new Object[]{string, string2});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        String string3 = InternalVSEMetaDataImpl.mergeTableName(string, string2);
        ArrayList<String> arrayList = (ArrayList<String>)this.columnNameTable.get(string3);
        Log.getLogger().finest("    cache hit=" + (arrayList != null));
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        ResultSet resultSet = this.databaseMetaData.getColumns(null, string, string2, "%");
        if (resultSet != null) {
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("COLUMN_NAME"));
            }
            resultSet.close();
            if (Log.getLogger().isLoggable(Level.FINEST)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Log.getLogger().finest("     Column:" + (String)arrayList.get(i));
                }
            }
        }
        Log.getLogger().finest("   getColumnNames loaded  " + arrayList.size());
        this.columnNameTable.put(string3, arrayList);
        return arrayList;
    }

    @Override
    public List<String> getPrimaryKeys(String string, String string2) throws SQLException {
        String string3;
        ArrayList<String> arrayList;
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getPrimaryKeys", new Object[]{string, string2});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if ((arrayList = (ArrayList<String>)this.pkTable.get(string3 = InternalVSEMetaDataImpl.mergeTableName(string, string2))) != null) {
            return arrayList;
        }
        arrayList = new ArrayList<String>();
        String[] stringArray = InternalVSEMetaDataImpl.parseTableName(string3);
        ResultSet resultSet = this.databaseMetaData.getPrimaryKeys(null, string, string2);
        if (resultSet != null) {
            while (resultSet.next()) {
                String string4 = resultSet.getString("COLUMN_NAME");
                arrayList.add(string4);
            }
            resultSet.close();
        }
        this.pkTable.put(string3, arrayList);
        return arrayList;
    }

    @Override
    public List<List<String>> getImportedKeys(String string, String string2) throws SQLException {
        return this.getForeignKeys(string, string2, false);
    }

    @Override
    public List<List<String>> getExportedKeys(String string, String string2) throws SQLException {
        return this.getForeignKeys(string, string2, true);
    }

    private List<List<String>> getForeignKeys(String string, String string2, boolean bl) throws SQLException {
        ResultSet resultSet;
        String string3;
        Hashtable hashtable;
        ArrayList<List<String>> arrayList;
        Log.getLogger().entering("InternalVSEMetaDataImpl", "getForeignKeys", new Object[]{string, string2});
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if ((arrayList = (ArrayList<List<String>>)(hashtable = bl ? this.fkExportedTable : this.fkImportedTable).get(string3 = InternalVSEMetaDataImpl.mergeTableName(string, string2))) != null) {
            return arrayList;
        }
        arrayList = new ArrayList<List<String>>();
        ResultSet resultSet2 = resultSet = bl ? this.databaseMetaData.getExportedKeys(null, string, string2) : this.databaseMetaData.getImportedKeys(null, string, string2);
        if (resultSet != null) {
            while (resultSet.next()) {
                String string4 = resultSet.getString("FKTABLE_SCHEM");
                String string5 = resultSet.getString("PKTABLE_SCHEM");
                List<String> list = Arrays.asList((string4 != null ? string4 + "." : "") + resultSet.getString("FKTABLE_NAME"), resultSet.getString("FKCOLUMN_NAME"), (string5 != null ? string5 + "." : "") + resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"));
                arrayList.add(list);
            }
            resultSet.close();
        }
        hashtable.put(string3, arrayList);
        return arrayList;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.databaseMetaData == null) {
            this.initMetaData();
        }
        if (this.identifierQuoteString != null) {
            return this.identifierQuoteString;
        }
        this.identifierQuoteString = this.databaseMetaData.getIdentifierQuoteString();
        return this.identifierQuoteString;
    }

    private void initMetaData() throws SQLException {
        this.databaseMetaData = this.getMetaData();
        this.refreshCacheTables();
    }

    private void refresh() {
        Log.getLogger().entering("InternalVSEMetaDataImpl", "refresh");
        this.databaseMetaData = null;
        this.refreshCacheTables();
    }

    private void refreshCacheTables() {
        this.schemas = null;
        this.columnNameTable.clear();
        this.fkExportedTable.clear();
        this.fkImportedTable.clear();
        this.allTables = null;
        this.allColumnsTable.clear();
        this.pkTable.clear();
        this.identifierQuoteString = null;
    }

    private static String[] parseTableName(String string) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length > 1) {
            stringArray[0] = stringArray2[0];
            stringArray[1] = stringArray2[1];
        } else {
            stringArray[0] = null;
            stringArray[1] = stringArray2[0];
        }
        return stringArray;
    }

    private static String mergeTableName(String string, String string2) {
        return string == null || string.equals("") ? string2 : string + "." + string2;
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this.databaseMetaData == null) {
            Connection connection = this.dbconn.getJDBCConnection();
            if (connection == null) {
                String string = NbBundle.getMessage(QueryBuilder.class, (String)"CANNOT_ESTABLISH_CONNECTION");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                this.databaseMetaData = this.dbconn.getJDBCConnection().getMetaData();
            }
        }
        return this.databaseMetaData;
    }
}

