/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.impl.AXIComponentCreator;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.AttributeImpl;
import org.netbeans.modules.xml.axi.impl.AttributeProxy;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.ElementImpl;
import org.netbeans.modules.xml.axi.impl.ElementProxy;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.impl.PeerValidator;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AXIModelUpdater
extends DeepAXITreeVisitor {
    private AXIModelImpl model;
    private boolean syncCompleted;

    public AXIModelUpdater(AXIModelImpl aXIModelImpl) {
        this.model = aXIModelImpl;
    }

    public boolean doSync() {
        try {
            this.syncCompleted = false;
            this.model.getRoot().accept(this);
            for (AXIComponent aXIComponent : this.model.getRoot().getChildren()) {
                if (aXIComponent instanceof ContentModel) continue;
                aXIComponent.accept(this);
            }
            for (ContentModel contentModel : this.model.getRoot().getContentModels()) {
                contentModel.accept(this);
            }
            this.syncCompleted = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.syncCompleted;
    }

    public void syncOne(AXIComponent aXIComponent) {
        aXIComponent.accept(this);
    }

    @Override
    protected void visitChildren(AXIComponent aXIComponent) {
        if (!aXIComponent.canVisitChildren()) {
            return;
        }
        if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY && aXIComponent.getModel() == aXIComponent.getOriginal().getModel()) {
            return;
        }
        AXIComponentCreator aXIComponentCreator = new AXIComponentCreator(this.model);
        AXIComponent aXIComponent2 = this.getAltered(aXIComponent);
        assert (aXIComponent2 != null);
        List<AXIComponent> list = this.synchronize(aXIComponent, aXIComponent2);
        if (list == null || aXIComponent instanceof AXIDocument) {
            return;
        }
        for (AXIComponent aXIComponent3 : list) {
            aXIComponent3.accept(this);
        }
    }

    private AXIComponent getAltered(AXIComponent aXIComponent) {
        if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY) {
            return aXIComponent.getOriginal();
        }
        AXIComponentCreator aXIComponentCreator = new AXIComponentCreator(this.model);
        return aXIComponentCreator.createNew(aXIComponent.getPeer());
    }

    private List<AXIComponent> synchronize(AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        List<AXIComponent> list = this.removeRemovedChildren(aXIComponent, aXIComponent2);
        this.addNewChildren(aXIComponent, aXIComponent2);
        return list;
    }

    private List<AXIComponent> removeRemovedChildren(AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        ArrayList<AXIComponent> arrayList = new ArrayList<AXIComponent>();
        ArrayList<AXIComponent> arrayList2 = new ArrayList<AXIComponent>();
        for (AXIComponent aXIComponent3 : aXIComponent.getChildren()) {
            int n = this.childExists(aXIComponent3, aXIComponent2, true);
            if (n == -1 || aXIComponent3.getPeer().getParent() == null || aXIComponent3.getPeer().getModel() == null) {
                arrayList.add(aXIComponent3);
                continue;
            }
            arrayList2.add(aXIComponent3);
        }
        for (AXIComponent aXIComponent3 : arrayList) {
            aXIComponent.removeChild(aXIComponent3);
        }
        return arrayList2;
    }

    private void addNewChildren(AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        int n = aXIComponent2.getChildren().size();
        for (int i = 0; i < n; ++i) {
            AXIComponent aXIComponent3 = (AXIComponent)aXIComponent2.getChildren().get(i);
            int n2 = this.childExists(aXIComponent3, aXIComponent, false);
            if (n2 == -1) {
                if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY) {
                    AXIComponent aXIComponent4 = this.model.getComponentFactory().createProxy(aXIComponent3);
                    aXIComponent.addChildAtIndex(aXIComponent4, i);
                    continue;
                }
                if (aXIComponent3.getPeer() == null || aXIComponent3.getPeer().getModel() == null) continue;
                aXIComponent.addChildAtIndex(aXIComponent3, i);
                continue;
            }
            if (aXIComponent3.getComponentType() != AXIComponent.ComponentType.PROXY) continue;
            aXIComponent3.getSharedComponent().removeListener(aXIComponent3);
        }
    }

    private int childExists(AXIComponent aXIComponent, AXIComponent aXIComponent2, boolean bl) {
        int n = aXIComponent2.getChildren().size();
        for (int i = 0; i < n; ++i) {
            AXIComponent aXIComponent3 = (AXIComponent)aXIComponent2.getChildren().get(i);
            if (aXIComponent3.getPeer() != aXIComponent.getPeer()) continue;
            if (bl && !this.validateOriginal(aXIComponent, aXIComponent3)) {
                return -1;
            }
            return i;
        }
        return -1;
    }

    private boolean validateOriginal(AXIComponent aXIComponent, AXIComponent aXIComponent2) {
        PeerValidator peerValidator = new PeerValidator();
        if (!peerValidator.validate(aXIComponent)) {
            return false;
        }
        return aXIComponent2.getComponentType() != AXIComponent.ComponentType.PROXY || aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY;
    }

    @Override
    public void visit(AXIDocument aXIDocument) {
        Util.updateAXIDocument(aXIDocument);
        this.visitChildren(aXIDocument);
    }

    @Override
    public void visit(Element element) {
        if (element instanceof ElementImpl) {
            this.visit((ElementImpl)element);
        }
        if (element instanceof ElementRef) {
            this.visit((ElementRef)element);
        }
        if (element instanceof ElementProxy) {
            ((ElementProxy)element).forceFireEvent();
        }
    }

    public void visit(ElementImpl elementImpl) {
        SchemaComponent schemaComponent = elementImpl.getPeer();
        if (schemaComponent instanceof LocalElement) {
            Util.updateLocalElement(elementImpl);
        }
        if (schemaComponent instanceof GlobalElement) {
            Util.updateGlobalElement(elementImpl);
        }
        SchemaComponent schemaComponent2 = Util.getSchemaType(this.model, elementImpl.getPeer());
        AXIType aXIType = Util.getAXIType(elementImpl, schemaComponent2);
        if (elementImpl.getType() != aXIType) {
            elementImpl.setType(aXIType);
        }
        this.visitChildren(elementImpl);
    }

    public void visit(ElementRef elementRef) {
        ElementReference elementReference = (ElementReference)elementRef.getPeer();
        GlobalElement globalElement = (GlobalElement)elementReference.getRef().get();
        SchemaComponent schemaComponent = elementRef.getReferent().getPeer();
        if (schemaComponent == globalElement) {
            Util.updateElementReference(elementRef);
            elementRef.forceFireEvent();
            this.visitChildren(elementRef);
            return;
        }
        AXIComponent aXIComponent = Util.lookup(elementRef.getModel(), (SchemaComponent)globalElement);
        if (aXIComponent != null && aXIComponent instanceof Element) {
            elementRef.setRef((Element)aXIComponent);
            elementRef.forceFireEvent();
        }
    }

    @Override
    public void visit(Attribute attribute) {
        if (attribute instanceof AttributeImpl) {
            this.visit((AttributeImpl)attribute);
        }
        if (attribute instanceof AttributeRef) {
            this.visit((AttributeRef)attribute);
        }
        if (attribute instanceof AttributeProxy) {
            ((AttributeProxy)attribute).forceFireEvent();
        }
    }

    public void visit(AttributeImpl attributeImpl) {
        Datatype datatype;
        SchemaComponent schemaComponent = attributeImpl.getPeer();
        if (schemaComponent instanceof LocalAttribute) {
            Util.updateLocalAttribute(attributeImpl);
            datatype = Util.getDatatype(attributeImpl.getModel(), (SchemaComponent)((LocalAttribute)schemaComponent));
            if (datatype != null) {
                attributeImpl.setType(datatype);
            }
        }
        if (schemaComponent instanceof GlobalAttribute) {
            Util.updateGlobalAttribute(attributeImpl);
            datatype = Util.getDatatype(attributeImpl.getModel(), (SchemaComponent)((GlobalAttribute)schemaComponent));
            if (datatype != null) {
                attributeImpl.setType(datatype);
            }
        }
    }

    public void visit(AttributeRef attributeRef) {
        GlobalAttribute globalAttribute;
        AttributeReference attributeReference = (AttributeReference)attributeRef.getPeer();
        SchemaComponent schemaComponent = attributeRef.getReferent().getPeer();
        if (schemaComponent == (globalAttribute = (GlobalAttribute)attributeReference.getRef().get())) {
            Util.updateAttributeReference(attributeRef);
            attributeRef.forceFireEvent();
            return;
        }
        AXIComponent aXIComponent = Util.lookup(attributeRef.getModel(), (SchemaComponent)globalAttribute);
        if (aXIComponent != null && aXIComponent instanceof Attribute) {
            attributeRef.setRef((Attribute)aXIComponent);
            attributeRef.forceFireEvent();
        }
    }

    @Override
    public void visit(Compositor compositor) {
        Util.updateCompositor(compositor);
        this.visitChildren(compositor);
    }

    @Override
    public void visit(ContentModel contentModel) {
        Util.updateContentModel(contentModel);
        this.visitChildren(contentModel);
    }

    @Override
    public void visit(AnyAttribute anyAttribute) {
        Util.updateAnyAttribute(anyAttribute);
    }

    @Override
    public void visit(AnyElement anyElement) {
        Util.updateAnyElement(anyElement);
    }
}

