/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final WeakHashMap<FileObject, Object[]> bundleInfos = new WeakHashMap();
    private static final FileChangeListener listener = new FileChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            WeakHashMap weakHashMap = bundleInfos;
            synchronized (weakHashMap) {
                bundleInfos.remove(fileEvent.getFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            if (fileAttributeEvent.getName() != null && fileAttributeEvent.getName().equals("SystemFileSystem.localizingBundle")) {
                WeakHashMap weakHashMap = bundleInfos;
                synchronized (weakHashMap) {
                    bundleInfos.remove(fileAttributeEvent.getFile());
                }
            }
        }
    };
    private static final FileChangeListener weakListener = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)listener, null);
    private static final Set<String> ALREADY_LOGGED = Collections.synchronizedSet(new HashSet());

    public static String getLocalizedName(FileObject fileObject, String string) {
        try {
            return fileObject.getFileSystem().getStatus().annotateName(string, Collections.singleton(fileObject));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            if (LOG.isLoggable(Level.FINE)) {
                Utils.logOnce(LOG, Level.FINE, "Can't find localized name of " + fileObject, fileStateInvalidException);
            }
            return string;
        }
    }

    public static String getLocalizedName(FileObject fileObject, String string, String string2) {
        return Utils.getLocalizedName(fileObject, string, string2, false);
    }

    public static String getLocalizedName(FileObject fileObject, String string, String string2, boolean bl) {
        block4: {
            assert (string != null) : "The key can't be null";
            Object[] objectArray = Utils.findResourceBundle(fileObject, bl);
            if (objectArray[1] != null) {
                try {
                    return ((ResourceBundle)objectArray[1]).getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (bl || !LOG.isLoggable(Level.FINE)) break block4;
                    Utils.logOnce(LOG, Level.FINE, "The bundle '" + objectArray[0] + "' is missing key '" + string + "'.", missingResourceException);
                }
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] findResourceBundle(FileObject fileObject, boolean bl) {
        assert (fileObject != null) : "FileObject can't be null";
        WeakHashMap<FileObject, Object[]> weakHashMap = bundleInfos;
        synchronized (weakHashMap) {
            Object[] objectArray = bundleInfos.get(fileObject);
            if (objectArray == null) {
                String string = null;
                Object object = fileObject.getAttribute("SystemFileSystem.localizingBundle");
                if (object instanceof String) {
                    string = (String)object;
                }
                if (string != null) {
                    try {
                        objectArray = new Object[]{string, NbBundle.getBundle((String)string)};
                    }
                    catch (MissingResourceException missingResourceException) {
                        if (!bl && LOG.isLoggable(Level.FINE)) {
                            Utils.logOnce(LOG, Level.FINE, "Can't find resource bundle for " + fileObject.getPath(), missingResourceException);
                        }
                    }
                } else if (!bl && LOG.isLoggable(Level.FINE)) {
                    Utils.logOnce(LOG, Level.FINE, "The file " + fileObject.getPath() + " does not specify its resource bundle.", null);
                }
                if (objectArray == null) {
                    objectArray = new Object[]{string, null};
                }
                bundleInfos.put(fileObject, objectArray);
                fileObject.removeFileChangeListener(weakListener);
                fileObject.addFileChangeListener(weakListener);
            }
            return objectArray;
        }
    }

    public static void logOnce(Logger logger, Level level, String string, Throwable throwable) {
        if (!ALREADY_LOGGED.contains(string)) {
            ALREADY_LOGGED.add(string);
            if (throwable != null) {
                logger.log(level, string, throwable);
            } else {
                logger.log(level, string);
            }
            if (ALREADY_LOGGED.size() > 100) {
                ALREADY_LOGGED.clear();
            }
        }
    }

    public static MimePath mimeTypes2mimePath(String[] stringArray) {
        MimePath mimePath = MimePath.EMPTY;
        for (int i = 0; i < stringArray.length; ++i) {
            mimePath = MimePath.get((MimePath)mimePath, (String)stringArray[i]);
        }
        return mimePath;
    }

    public static Map<String, AttributeSet> immutize(Map<String, ? extends AttributeSet> map, Object ... objectArray) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (String string : map.keySet()) {
            AttributeSet attributeSet = map.get(string);
            if (objectArray.length == 0) {
                hashMap.put(string, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attributeSet}));
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            block1: while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                for (Object object : objectArray) {
                    if (Utilities.compareObjects(obj, (Object)object)) continue block1;
                }
                arrayList.add(obj);
                arrayList.add(attributeSet.getAttribute(obj));
            }
            hashMap.put(string, AttributesUtilities.createImmutable((Object[])arrayList.toArray()));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map<String, AttributeSet> immutize(Collection<AttributeSet> collection) {
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (AttributeSet attributeSet : collection) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof String) {
                hashMap.put((String)object, attributeSet);
                continue;
            }
            LOG.warning("Ignoring AttributeSet with invalid StyleConstants.NameAttribute. AttributeSet: " + attributeSet);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static <A, B> void diff(Map<A, B> map, Map<A, B> map2, Map<A, B> map3, Map<A, B> map4) {
        for (A a : map.keySet()) {
            if (!map2.containsKey(a)) {
                map4.put(a, map.get(a));
                continue;
            }
            if (Utilities.compareObjects(map.get(a), map2.get(a))) continue;
            map3.put(a, map2.get(a));
        }
        for (A a : map2.keySet()) {
            if (map.containsKey(a)) continue;
            map3.put(a, map2.get(a));
        }
    }

    public static <A, B> boolean quickDiff(Map<A, B> map, Map<A, B> map2) {
        for (A a : map.keySet()) {
            if (!map2.containsKey(a)) {
                return true;
            }
            if (Utilities.compareObjects(map.get(a), map2.get(a))) continue;
            return true;
        }
        for (A a : map2.keySet()) {
            if (map.containsKey(a)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FileObject fileObject, StorageWriter storageWriter) {
        assert (fileObject != null) : "FileObject can't be null";
        assert (storageWriter != null) : "StorageWriter can't be null";
        try {
            FileLock fileLock = fileObject.lock();
            try {
                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                try {
                    XMLUtil.write((Document)storageWriter.getDocument(), (OutputStream)outputStream, (String)"UTF-8");
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                fileLock.releaseLock();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't save editor settings to " + fileObject.getPath(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(FileObject fileObject, StorageReader storageReader, boolean bl) {
        assert (fileObject != null) : "Settings file must not be null";
        assert (storageReader != null) : "StorageReader can't be null";
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)bl);
            xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            xMLReader.setContentHandler(storageReader);
            xMLReader.setErrorHandler(storageReader);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", storageReader);
            InputStream inputStream = fileObject.getInputStream();
            try {
                xMLReader.parse(new InputSource(inputStream));
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Invalid or corrupted file: " + fileObject.getPath(), exception);
        }
    }
}

