/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent.api;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;

public final class IndentUtils {
    private static final int MAX_CACHED_INDENT = 80;
    private static final Logger LOG = Logger.getLogger(IndentUtils.class.getName());
    private static final String[] cachedSpacesStrings = new String[81];
    private static final int MAX_CACHED_TAB_SIZE = 8;
    private static final String[][] cachedTabIndents;

    private IndentUtils() {
    }

    public static int indentLevelSize(Document document) {
        int n;
        Preferences preferences = CodeStylePreferences.get(document).getPreferences();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("INDENT_SHIFT_WIDTH='" + preferences.get("indent-shift-width", null) + "', EXPAND_TABS='" + preferences.get("expand-tabs", null) + "', SPACES_PER_TAB='" + preferences.get("spaces-per-tab", null) + "', TAB_SIZE='" + preferences.get("tab-size", null) + "' for " + document);
        }
        if ((n = preferences.getInt("indent-shift-width", -1)) <= 0) {
            boolean bl = preferences.getBoolean("expand-tabs", true);
            n = bl ? preferences.getInt("spaces-per-tab", 4) : preferences.getInt("tab-size", 8);
        }
        assert (n > 0) : "Invalid indentLevelSize " + n + " for " + document;
        return n;
    }

    public static int tabSize(Document document) {
        int n = CodeStylePreferences.get(document).getPreferences().getInt("tab-size", 8);
        assert (n > 0) : "Invalid tabSize " + n + " for " + document;
        return n;
    }

    public static boolean isExpandTabs(Document document) {
        return CodeStylePreferences.get(document).getPreferences().getBoolean("expand-tabs", true);
    }

    public static int lineStartOffset(Document document, int n) throws BadLocationException {
        IndentImpl.checkOffsetInDocument(document, n);
        Element element = IndentImpl.lineRootElement(document);
        return element.getElement(element.getElementIndex(n)).getStartOffset();
    }

    public static int lineIndent(Document document, int n) throws BadLocationException {
        IndentImpl.checkOffsetInDocument(document, n);
        CharSequence charSequence = DocumentUtilities.getText((Document)document);
        int n2 = 0;
        int n3 = -1;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            switch (c) {
                case '\n': {
                    return n2;
                }
                case '\t': {
                    if (n3 == -1) {
                        n3 = IndentUtils.tabSize(document);
                    }
                    n2 = (n2 + n3) / n3 * n3;
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        ++n2;
                        break;
                    }
                    return n2;
                }
            }
            ++n;
        }
        return n2;
    }

    public static String createIndentString(Document document, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("indent=" + n + " < 0");
        }
        return IndentUtils.cachedOrCreatedIndentString(n, IndentUtils.isExpandTabs(document), IndentUtils.tabSize(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String cachedOrCreatedIndentString(int n, boolean bl, int n2) {
        String string;
        if (bl || n < n2) {
            if (n > 80) return IndentUtils.createSpacesString(n);
            String[] stringArray = cachedSpacesStrings;
            synchronized (cachedSpacesStrings) {
                string = cachedSpacesStrings[n];
                if (string != null) return string;
                string = cachedSpacesStrings[80];
                if (string == null) {
                    IndentUtils.cachedSpacesStrings[80] = string = IndentUtils.createSpacesString(80);
                }
                IndentUtils.cachedSpacesStrings[n] = string = string.substring(0, n);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return string;
            }
        }
        if (n > 80) return IndentUtils.createTabIndentString(n, n2);
        if (n2 > 8) return IndentUtils.createTabIndentString(n, n2);
        String[][] stringArray = cachedTabIndents;
        synchronized (cachedTabIndents) {
            String[] stringArray2 = cachedTabIndents[n2];
            if (stringArray2 == null) {
                stringArray2 = new String[80 - n2 + 1];
                IndentUtils.cachedTabIndents[n2] = stringArray2;
            }
            if ((string = stringArray2[n - n2]) != null) return string;
            stringArray2[n - n2] = string = IndentUtils.createTabIndentString(n, n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return string;
        }
    }

    private static String createSpacesString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
        return stringBuilder.toString();
    }

    private static String createTabIndentString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (n >= n2) {
            stringBuilder.append('\t');
            n -= n2;
        }
        ArrayUtilities.appendSpaces((StringBuilder)stringBuilder, (int)n);
        return stringBuilder.toString();
    }

    static {
        IndentUtils.cachedSpacesStrings[0] = "";
        cachedTabIndents = new String[9][];
    }
}

