/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent;

import java.io.IOException;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.indent.IndentImpl;
import org.openide.util.Exceptions;

public final class FormatterWriterImpl
extends Writer {
    private IndentImpl indentImpl;
    private int offset;
    private Writer writer;
    private StringBuilder buffer;

    FormatterWriterImpl(IndentImpl indentImpl, int n, Writer writer) {
        if (n < 0) {
            throw new IllegalArgumentException("offset=" + n + " < 0");
        }
        if (n > indentImpl.document().getLength()) {
            throw new IllegalArgumentException("offset=" + n + " > docLen=" + indentImpl.document().getLength());
        }
        this.indentImpl = indentImpl;
        this.offset = n;
        this.writer = writer;
        this.buffer = new StringBuilder();
    }

    public void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.buffer.append(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.indentImpl.reformatLock();
        try {
            Document document = this.indentImpl.document();
            String string = this.buffer.toString();
            if (string.length() > 0 && this.offset <= document.getLength()) {
                try {
                    document.insertString(this.offset, string, null);
                    Position position = document.createPosition(this.offset);
                    Position position2 = document.createPosition(this.offset + string.length());
                    this.indentImpl.reformat(position.getOffset(), position2.getOffset());
                    int n = position2.getOffset() - position.getOffset();
                    String string2 = document.getText(position.getOffset(), n);
                    document.remove(position.getOffset(), n);
                    this.writer.write(string2);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }
        finally {
            this.indentImpl.reformatUnlock();
        }
    }

    public void flush() throws IOException {
    }
}

