/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.util.NbBundle;

public class TimestampType {
    public static final Locale LOCALE = Locale.UK;
    private final DateFormat[] TIMESTAMP_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", LOCALE), new SimpleDateFormat("yyyy-MM-dd", LOCALE), new SimpleDateFormat("MM-dd-yyyy", LOCALE), new SimpleDateFormat("HH:mm:ss", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};

    public TimestampType() {
        for (int i = 0; i < this.TIMESTAMP_PARSING_FORMATS.length; ++i) {
            this.TIMESTAMP_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public Object convert(Object object) throws DBException {
        if (null == object) {
            return null;
        }
        if (object instanceof Timestamp) {
            return object;
        }
        if (object instanceof String) {
            Date date = null;
            for (int i = 0; date == null && i < this.TIMESTAMP_PARSING_FORMATS.length; ++i) {
                date = this.TIMESTAMP_PARSING_FORMATS[i].parse((String)object, new ParsePosition(0));
            }
            if (date == null) {
                throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
            }
            return new Timestamp(date.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
    }
}

