/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;

public class IndentFactory
implements IndentTask.Factory {
    public IndentTask createTask(Context context) {
        return new GLFIndentTask(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GLFIndentTask
    implements IndentTask {
        private Context context;

        private GLFIndentTask(Context context) {
            this.context = context;
        }

        public void reindent() throws BadLocationException {
            StyledDocument styledDocument = (StyledDocument)this.context.document();
            try {
                MimePath mimePath = MimePath.parse((String)this.context.mimePath());
                String string = mimePath.getMimeType(mimePath.size() - 1);
                Language language = LanguagesManager.getDefault().getLanguage(string);
                Object object = GLFIndentTask.getIndentProperties(language);
                if (object == null) {
                    return;
                }
                if (object instanceof Feature) {
                    Feature feature = (Feature)object;
                    feature.getValue(org.netbeans.api.languages.Context.create(styledDocument, this.context.startOffset()));
                    return;
                }
                Object[] objectArray = (Object[])object;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)styledDocument);
                LanguagePath languagePath = LanguagePath.get((org.netbeans.api.lexer.Language)org.netbeans.api.lexer.Language.find((String)mimePath.getMimeType(0)));
                for (int i = 1; i < mimePath.size(); ++i) {
                    languagePath = languagePath.embedded(org.netbeans.api.lexer.Language.find((String)mimePath.getMimeType(i)));
                }
                List list = tokenHierarchy.tokenSequenceList(languagePath, this.context.startOffset(), this.context.endOffset());
                Set<Integer> set = language.getAnalyser().getSkipTokenTypes();
                for (Context.Region region : this.context.indentRegions()) {
                    HashMap<Position, Integer> hashMap = new HashMap<Position, Integer>();
                    int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)region.getStartOffset());
                    int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)region.getEndOffset());
                    if (!Utils.getTokenSequence(styledDocument, this.context.lineStartOffset(region.getStartOffset())).language().mimeType().equals(string)) {
                        ++n;
                    }
                    int n3 = 0;
                    if (n > 0) {
                        int n4 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
                        n3 = this.context.lineIndent(n4);
                        if (!Utils.getTokenSequence(styledDocument, n4).language().mimeType().equals(string)) {
                            n3 += IndentUtils.indentLevelSize((Document)styledDocument);
                        }
                    }
                    while (n <= n2 && (n != n2 || !GLFIndentTask.isEmpty(n, styledDocument, set) || Utils.getTokenSequence(styledDocument, region.getEndOffset()).language().mimeType().equals(string))) {
                        n3 = this.indent(this.context, styledDocument, objectArray, n++, n3, hashMap, set);
                    }
                    for (Position position : hashMap.keySet()) {
                        this.context.modifyIndent(position.getOffset(), ((Integer)hashMap.get(position)).intValue());
                    }
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        public ExtraLock indentLock() {
            return null;
        }

        private int indent(Context context, StyledDocument styledDocument, Object[] objectArray, int n, int n2, Map<Position, Integer> map, Set<Integer> set) throws BadLocationException {
            int n3;
            int n4 = n3 = n > 0 ? GLFIndentTask.computeIndent(n - 1, styledDocument, context, objectArray) : 0;
            if (n3 > 0) {
                n2 += IndentUtils.indentLevelSize((Document)styledDocument);
            } else if (n3 < 0) {
                if (!GLFIndentTask.startsWithBrace(n - 1, styledDocument, context, objectArray, set)) {
                    n2 -= IndentUtils.indentLevelSize((Document)styledDocument);
                }
            } else if (n3 == 0 && n > 1 && (n3 = GLFIndentTask.computeIndent(n - 2, styledDocument, context, objectArray)) == 2) {
                n2 -= IndentUtils.indentLevelSize((Document)styledDocument);
            }
            if (GLFIndentTask.startsWithBrace(n, styledDocument, context, objectArray, set)) {
                n2 -= IndentUtils.indentLevelSize((Document)styledDocument);
            }
            n2 = Math.max(n2, 0);
            map.put(styledDocument.createPosition(NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n)), n2);
            return n2;
        }

        private static int getCurrentIndent(String string) {
            int n = 0;
            int n2 = string.length() - 1;
            for (int i = 0; i < n2 && Character.isWhitespace(string.charAt(i)); ++i) {
                if (string.charAt(i) == '\t') {
                    n += 8 - n % 8;
                    continue;
                }
                ++n;
            }
            return n;
        }

        private static int computeIndent(int n, StyledDocument styledDocument, Context context, Object[] objectArray) throws BadLocationException {
            Object object;
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            int n3 = styledDocument.getLength();
            try {
                n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n + 1)) - 1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            TokenSequence tokenSequence = Utils.getTokenSequence(styledDocument, n2);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            do {
                Serializable serializable;
                String string;
                if (((Set)objectArray[1]).contains(string = ((Object)(object = tokenSequence.token()).text()).toString().trim())) {
                    serializable = (Integer)hashMap.get(string);
                    serializable = serializable == null ? Integer.valueOf(1) : Integer.valueOf((Integer)serializable + 1);
                    hashMap.put(string, (Integer)serializable);
                }
                if (!((Set)objectArray[2]).contains(((Object)object.text()).toString().trim())) continue;
                serializable = (Integer)hashMap.get(string = (String)((Map)objectArray[3]).get(string));
                serializable = serializable == null ? Integer.valueOf(-1) : Integer.valueOf((Integer)serializable - 1);
                hashMap.put(string, (Integer)serializable);
            } while (tokenSequence.moveNext() && tokenSequence.offset() < n3);
            object = hashMap.values().iterator();
            while (object.hasNext()) {
                int n4 = (Integer)object.next();
                if (n4 > 0) {
                    return 1;
                }
                if (n4 >= 0) continue;
                return -1;
            }
            String string = styledDocument.getText(n2, n3 - n2);
            for (Serializable serializable : (List)objectArray[0]) {
                if (!((Pattern)serializable).matcher(string).matches()) continue;
                return 2;
            }
            return 0;
        }

        private static boolean startsWithBrace(int n, StyledDocument styledDocument, Context context, Object[] objectArray, Set<Integer> set) throws BadLocationException {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            int n3 = styledDocument.getLength();
            try {
                n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n + 1)) - 1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            TokenSequence tokenSequence = Utils.getTokenSequence(styledDocument, n2);
            if (tokenSequence.token() == null) {
                return false;
            }
            while (set.contains(tokenSequence.token().id().ordinal())) {
                if (!tokenSequence.moveNext()) {
                    return false;
                }
                if (tokenSequence.offset() <= n3) continue;
                return false;
            }
            Token token = tokenSequence.token();
            String string = ((Object)token.text()).toString();
            String string2 = string.trim();
            int n4 = string.indexOf("\n");
            if (n4 >= 0 && (n4 = string.indexOf("\n", n4 + 1)) >= 0 && n4 < string.indexOf(string2)) {
                return false;
            }
            return ((Set)objectArray[2]).contains(string2);
        }

        private static boolean isEmpty(int n, StyledDocument styledDocument, Set<Integer> set) throws BadLocationException {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            int n3 = styledDocument.getLength();
            try {
                n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n + 1)) - 1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            TokenSequence tokenSequence = Utils.getTokenSequence(styledDocument, n2);
            if (tokenSequence.token() == null) {
                return true;
            }
            while (set.contains(tokenSequence.token().id().ordinal())) {
                if (!tokenSequence.moveNext()) {
                    return true;
                }
                if (tokenSequence.offset() <= n3) continue;
                return true;
            }
            return false;
        }

        private static Object getIndentProperties(Language language) {
            Object[] objectArray;
            ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            List<Feature> list = language.getFeatureList().getFeatures("INDENT");
            for (Feature feature : list) {
                if (feature.getType() == Feature.Type.METHOD_CALL) {
                    return feature;
                }
                String string = (String)feature.getValue();
                int n = string.indexOf(58);
                if (n < 1) {
                    arrayList.add(Pattern.compile(GLFIndentTask.c(string)));
                    continue;
                }
                hashSet.add(string.substring(0, n));
                hashSet2.add(string.substring(n + 1));
                hashMap.put(string.substring(n + 1), string.substring(0, n));
            }
            if (list.isEmpty()) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = arrayList;
                objectArray2[1] = hashSet;
                objectArray2[2] = hashSet2;
                objectArray = objectArray2;
                objectArray2[3] = hashMap;
            }
            return objectArray;
        }

        private static String c(String string) {
            string = string.replace("\\n", "\n");
            string = string.replace("\\r", "\r");
            string = string.replace("\\t", "\t");
            string = string.replace("\\\"", "\"");
            string = string.replace("\\'", "'");
            string = string.replace("\\\\", "\\");
            return string;
        }
    }
}

