/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.templates;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.templates.TemplateDescriptor;
import com.jaspersoft.ireport.designer.templates.TemplateItemAction;
import com.jaspersoft.ireport.designer.templates.TemplateItemActionCellRenderer;
import com.jaspersoft.ireport.designer.templates.TemplatesPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.CustomTemplateWizard;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class TemplatesFrame
extends JDialog {
    Rectangle minimizeBounds = null;
    boolean adjustingValueSlider = false;
    private JButton jButton1;
    private JButton jButtonFinish;
    private JButton jButtonLaunchWizard;
    private JButton jButtonOpenTemplate;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelDescription;
    private JLabel jLabelSize;
    private JList jListTemplateItems;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanelSlider;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private TemplatesPanel templatesPanel1;

    public TemplatesFrame(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle(I18n.getString("TemplatesFrame.title"));
        this.initComponents();
        this.jListTemplateItems.setModel(new DefaultListModel());
        this.jListTemplateItems.setCellRenderer(new TemplateItemActionCellRenderer());
        this.jSlider1.setMinimum(80);
        this.jSlider1.setMaximum(700);
        this.jSlider1.setValue(120);
        this.jSlider1.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
            }
        });
        this.getContentPane().setBackground(Color.WHITE);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.loadItems();
        if (this.jListTemplateItems.getModel().getSize() > 0) {
            this.jListTemplateItems.setSelectedIndex(0);
        }
        Dimension d = this.getSize();
        d.width = IReportManager.getPreferences().getInt("templates_window_width", d.width);
        d.height = IReportManager.getPreferences().getInt("templates_window_height", d.height);
        this.setSize(d);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
            }
        });
    }

    private synchronized void loadItems() {
        ((DefaultListModel)this.jListTemplateItems.getModel()).removeAllElements();
        List<TemplateItemAction> actions = TemplateItemAction.getActions();
        for (TemplateItemAction a : actions) {
            ((DefaultListModel)this.jListTemplateItems.getModel()).addElement(a);
        }
    }

    private void storeWindowSize() {
        Dimension d = this.getSize();
        IReportManager.getPreferences().putInt("templates_window_width", d.width);
        IReportManager.getPreferences().putInt("templates_window_height", d.height);
    }

    private void initComponents() {
        this.templatesPanel1 = new TemplatesPanel();
        this.jPanel1 = new JPanel();
        this.jLabelSize = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanelSlider = new JPanel();
        this.jLabel3 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jButtonOpenTemplate = new JButton();
        this.jButtonLaunchWizard = new JButton();
        this.jButtonFinish = new JButton();
        this.jButton1 = new JButton();
        this.jLabelDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListTemplateItems = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.title"));
        this.templatesPanel1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TemplatesFrame.this.templatesPanel1ComponentResized(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelSize.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/maximize_win.png")));
        this.jLabelSize.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jLabelSize.text_1"));
        this.jLabelSize.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TemplatesFrame.this.jLabelSizeMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jLabelSize, gridBagConstraints);
        this.jPanelSlider.setLayout(new BorderLayout());
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/template/small.png")));
        this.jLabel3.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jLabel3.text"));
        this.jLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TemplatesFrame.this.jLabel3MouseClicked(evt);
            }
        });
        this.jPanelSlider.add((Component)this.jLabel3, "West");
        this.jSlider1.setMaximum(1000);
        this.jSlider1.setMinimum(80);
        this.jSlider1.setFocusable(false);
        this.jSlider1.setMinimumSize(new Dimension(120, 23));
        this.jSlider1.setPreferredSize(new Dimension(150, 23));
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TemplatesFrame.this.jSlider1StateChanged(evt);
            }
        });
        this.jSlider1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TemplatesFrame.this.jSlider1PropertyChange(evt);
            }
        });
        this.jPanelSlider.add((Component)this.jSlider1, "Center");
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/template/big.png")));
        this.jLabel2.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jLabel2.text"));
        this.jLabel2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TemplatesFrame.this.jLabel2MouseClicked(evt);
            }
        });
        this.jPanelSlider.add((Component)this.jLabel2, "East");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 150, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jPanelSlider, -2, 150, -2).add(0, 0, Short.MAX_VALUE))));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jPanelSlider, -2, -1, -2).add(0, 0, Short.MAX_VALUE))));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonOpenTemplate.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jButtonOpenTemplate.text"));
        this.jButtonOpenTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesFrame.this.jButtonOpenTemplateActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonOpenTemplate, new GridBagConstraints());
        this.jButtonLaunchWizard.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jButtonLaunchWizard.text"));
        this.jButtonLaunchWizard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesFrame.this.jButtonLaunchWizardActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonLaunchWizard, new GridBagConstraints());
        this.jButtonFinish.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jButtonFinish.text"));
        this.jButtonFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesFrame.this.jButtonFinishActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jButtonFinish, new GridBagConstraints());
        this.jButton1.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesFrame.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jLabelDescription.setBackground(new Color(255, 255, 255));
        this.jLabelDescription.setFont(new Font("MS UI Gothic", 0, 12));
        this.jLabelDescription.setText(NbBundle.getMessage(TemplatesFrame.class, (String)"TemplatesFrame.jLabelDescription.text"));
        this.jLabelDescription.setVerticalAlignment(1);
        this.jLabelDescription.setOpaque(true);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jListTemplateItems.setSelectionMode(0);
        this.jListTemplateItems.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TemplatesFrame.this.jListTemplateItemsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListTemplateItems);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, 726, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 240, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.templatesPanel1, -1, 470, Short.MAX_VALUE).add((Component)this.jLabelDescription, -1, 470, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelDescription, -2, 45, -2).addPreferredGap(0).add((Component)this.templatesPanel1, -1, 430, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 470, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.jPanel1, -2, 30, -2)));
        this.pack();
    }

    private void jButtonOpenTemplateActionPerformed(ActionEvent evt) {
        TemplateItemAction action = (TemplateItemAction)this.jListTemplateItems.getSelectedValue();
        if (action != null) {
            action.performAction(this, 3);
        }
    }

    private void jButtonLaunchWizardActionPerformed(ActionEvent evt) {
        TemplateItemAction action = (TemplateItemAction)this.jListTemplateItems.getSelectedValue();
        if (action != null) {
            action.performAction(this, 2);
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        if (this.adjustingValueSlider || this.jSlider1.getValue() == this.templatesPanel1.getIconsSize()) {
            return;
        }
        this.templatesPanel1.setIconsSize(this.jSlider1.getValue());
    }

    private void jButtonFinishActionPerformed(ActionEvent evt) {
        TemplateItemAction action = (TemplateItemAction)this.jListTemplateItems.getSelectedValue();
        if (action != null) {
            action.performAction(this, 1);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jLabel3MouseClicked(MouseEvent evt) {
        this.jSlider1.setValue(this.jSlider1.getMinimum());
    }

    private void jLabel2MouseClicked(MouseEvent evt) {
        this.templatesPanel1.setFullPageView(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TemplatesFrame.this.adjustingValueSlider = true;
                TemplatesFrame.this.jSlider1.setValue(TemplatesFrame.this.templatesPanel1.getIconsSize());
                TemplatesFrame.this.adjustingValueSlider = false;
            }
        });
    }

    private void jSlider1PropertyChange(PropertyChangeEvent evt) {
    }

    private void templatesPanel1ComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TemplatesFrame.this.adjustingValueSlider = true;
                TemplatesFrame.this.jSlider1.setValue(TemplatesFrame.this.templatesPanel1.getIconsSize());
                TemplatesFrame.this.adjustingValueSlider = false;
            }
        });
    }

    private void jListTemplateItemsValueChanged(ListSelectionEvent evt) {
        this.updateSelection();
    }

    private void jLabelSizeMouseClicked(MouseEvent evt) {
        int index = -1;
        if (this.templatesPanel1.isFullPageView()) {
            index = this.templatesPanel1.getList().getFirstVisibleIndex();
        }
        if (this.minimizeBounds == null) {
            this.minimizeBounds = new Rectangle(this.getBounds());
            this.setBounds(this.getParent().getBounds());
            this.jLabelSize.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/minimize_window.png")));
        } else {
            this.setBounds(this.minimizeBounds);
            this.minimizeBounds = null;
            this.jLabelSize.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/maximize_win.png")));
        }
        if (this.templatesPanel1.isFullPageView() && index >= 0) {
            this.templatesPanel1.getList().ensureIndexIsVisible(index);
        }
        this.jLabelSize.updateUI();
    }

    public void runTemplateWizard(TemplateDescriptor td, boolean useWizard) {
        CustomTemplateWizard wizardDescriptor = new CustomTemplateWizard();
        File targetFolder = Misc.findStartingDirectory();
        if (targetFolder == null || !targetFolder.exists()) {
            System.out.println("\u30bf\u30fc\u30b2\u30c3\u30c8\u30d5\u30a9\u30eb\u30c0\uff1a" + targetFolder);
            System.out.flush();
        }
        DataFolder df = DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)targetFolder));
        wizardDescriptor.setTargetFolder(df);
        wizardDescriptor.setTargetName("Report");
        if (!useWizard) {
            wizardDescriptor.putProperty("noFields", "true");
        }
        wizardDescriptor.putProperty("reportTemplate", td.getFileObject());
        try {
            FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("Templates/Report/Report");
            wizardDescriptor.setTemplate(DataObject.find((FileObject)templateFileObject));
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        wizardDescriptor.setTitle("\u65b0\u898f");
        this.setVisible(false);
        this.dispose();
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
    }

    public void runTemplateWizard(String targetName, String templateName) {
        CustomTemplateWizard wizardDescriptor = new CustomTemplateWizard();
        wizardDescriptor.putProperty("WizardPanel_contentDisplayed", Boolean.FALSE);
        wizardDescriptor.putProperty("WizardPanel_contentNumbered", Boolean.FALSE);
        File targetFolder = Misc.findStartingDirectory();
        DataFolder df = DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)targetFolder));
        wizardDescriptor.setTargetFolder(df);
        if (targetName != null) {
            wizardDescriptor.setTargetName(targetName);
        }
        if (templateName != null) {
            try {
                FileObject templateFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(templateName);
                wizardDescriptor.setTemplate(DataObject.find((FileObject)templateFileObject));
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        wizardDescriptor.setTitle("\u65b0\u898f");
        this.setVisible(false);
        this.dispose();
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
    }

    public void updateSelection() {
        TemplateItemAction action = (TemplateItemAction)this.jListTemplateItems.getSelectedValue();
        if (action == null) {
            return;
        }
        this.templatesPanel1.setVisible(action.getProperty("showTemplates") == Boolean.TRUE);
        this.jLabelDescription.setText(action.getDescription() == null ? "" : action.getDescription());
        this.jButtonFinish.setVisible(action.getProperty("showFinishButton") == Boolean.TRUE);
        this.jButtonLaunchWizard.setVisible(action.getProperty("showLaunchReportWizard") == Boolean.TRUE);
        this.jButtonOpenTemplate.setVisible(action.getProperty("showOpenTemplateButton") == Boolean.TRUE);
        this.jPanelSlider.setVisible(action.getProperty("showTemplates") == Boolean.TRUE);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TemplatesFrame dialog = new TemplatesFrame((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public TemplateDescriptor getSelectedTemplateDescriptor() {
        return this.templatesPanel1.getSelectedTamplate();
    }

    public void setVisible(boolean b) {
        this.storeWindowSize();
        super.setVisible(b);
    }
}

