/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.designer.sheet.editors.JRPenPropertyCustomEditor;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.base.JRBasePrintLine;
import net.sf.jasperreports.engine.export.draw.LineDrawer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;

public class JRPenPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean customEd = true;
    private PropertyEnv env;

    public boolean isEditable() {
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics grx, Rectangle box) {
        JRPen pen;
        JRPen jRPen = pen = this.getValue() instanceof JRPen ? (JRPen)this.getValue() : null;
        if (pen == null) {
            super.paintValue(grx, box);
        } else {
            JRBasePrintLine line = new JRBasePrintLine(null);
            line.setX(box.x + 4);
            line.setY(box.y + box.height / 2);
            line.setWidth(box.width - 8);
            line.setHeight(1);
            line.getLinePen().setLineColor(pen.getLineColor());
            line.getLinePen().setLineStyle(pen.getLineStyle());
            line.getLinePen().setLineWidth(pen.getLineWidth());
            new LineDrawer().draw((Graphics2D)grx, (JRPrintLine)line, 0, 0);
        }
    }

    public String getAsText() {
        return "";
    }

    public void setAsText(String s) {
    }

    public boolean supportsCustomEditor() {
        return this.customEd;
    }

    public Component getCustomEditor() {
        JRPen pen = this.getValue() instanceof JRPen ? (JRPen)this.getValue() : null;
        return new JRPenPropertyCustomEditor(pen, false, null, this, this.env);
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.customEd = !Boolean.TRUE.equals(prop.getValue("suppressCustomEditor"));
        }
        this.env = env;
    }
}

