/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.pdf508;

import com.jaspersoft.ireport.designer.ElementDecorator;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.pdf508.Pdf508TagAction;
import com.jaspersoft.ireport.designer.pdf508.Pdf508TagMenuUtility;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class Pdf508TagDecorator
implements ElementDecorator {
    static final ImageIcon startImage = new ImageIcon(Pdf508TagDecorator.class.getResource("/com/jaspersoft/ireport/designer/pdf508/corner1.png"));
    static final ImageIcon endImage = new ImageIcon(Pdf508TagDecorator.class.getResource("/com/jaspersoft/ireport/designer/pdf508/corner2.png"));

    public void paintWidget(Widget w) {
        IReportManager.getInstance();
        if (!IReportManager.getPreferences().getBoolean("showPDF508Tags", false)) {
            return;
        }
        Graphics2D gr = w.getScene().getGraphics();
        Rectangle r = w.getPreferredBounds();
        AffineTransform af = gr.getTransform();
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(w.getBorder().getInsets().left + r.x, w.getBorder().getInsets().top + r.y);
        new_af.concatenate(translate);
        gr.setTransform(new_af);
        if (w instanceof JRDesignElementWidget) {
            int strWidth;
            JRDesignElementWidget dew = (JRDesignElementWidget)w;
            String tagValue = "";
            String startString = "";
            String fullString = "";
            String endString = "";
            boolean drawstart = false;
            boolean drawend = false;
            String[] tags = new String[]{"net.sf.jasperreports.export.pdf.tag.h1", "H1", "net.sf.jasperreports.export.pdf.tag.h2", "H2", "net.sf.jasperreports.export.pdf.tag.h3", "H3", "net.sf.jasperreports.export.pdf.tag.table", "TBL", "net.sf.jasperreports.export.pdf.tag.tr", "TR", "net.sf.jasperreports.export.pdf.tag.th", "TH", "net.sf.jasperreports.export.pdf.tag.td", "TD"};
            for (int i = 0; i < tags.length; i += 2) {
                boolean start = false;
                boolean end = false;
                String prop = tags[i];
                String label = tags[i + 1];
                tagValue = Pdf508TagMenuUtility.getPropertyValue(dew.getElement(), prop);
                if (tagValue.equals("full")) {
                    drawstart = true;
                    drawend = true;
                    fullString = fullString + label + " ";
                    continue;
                }
                if (tagValue.equals("start")) {
                    drawstart = true;
                    startString = startString + label + " ";
                    continue;
                }
                if (!tagValue.equals("end")) continue;
                drawend = true;
                endString = label + " " + endString;
            }
            if (drawstart) {
                this.drawStart(gr);
            }
            if (drawend) {
                this.drawEnd(gr, dew.getElement());
            }
            Font f = gr.getFont();
            Color color = gr.getColor();
            startString = startString.trim();
            endString = endString.trim();
            fullString = fullString.trim();
            gr.setFont(new Font("MS UI Gothic", 0, 8));
            gr.setColor(new Color(195, 47, 193));
            if (startString.length() > 0) {
                gr.drawString(startString, 4, 10);
            }
            if (endString.length() > 0) {
                strWidth = gr.getFontMetrics().stringWidth(endString);
                gr.drawString(endString, dew.getElement().getWidth() - 3 - strWidth, dew.getElement().getHeight() - 3);
            }
            if (fullString.length() > 0) {
                strWidth = 0;
                if (startString.length() > 0) {
                    strWidth = gr.getFontMetrics().stringWidth(startString + " ");
                }
                AttributedString as = new AttributedString(fullString);
                as.addAttribute(TextAttribute.FONT, gr.getFont());
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                gr.drawString(as.getIterator(), 4 + strWidth, 10);
            }
            gr.setFont(f);
            gr.setColor(color);
        }
        gr.setTransform(af);
    }

    public SystemAction[] getActions(Node node) {
        ArrayList<SystemAction> actions = new ArrayList<SystemAction>();
        if (node instanceof ElementNode) {
            actions.add(SystemAction.get(Pdf508TagAction.class));
        }
        return actions.toArray(new SystemAction[actions.size()]);
    }

    private void drawFull(Graphics2D gr, JRDesignElement element) {
        this.drawStart(gr);
        this.drawEnd(gr, element);
    }

    private void drawEnd(Graphics2D gr, JRDesignElement element) {
        gr.drawImage(endImage.getImage(), element.getWidth() - endImage.getIconWidth(), element.getHeight() - endImage.getIconHeight(), null);
    }

    private void drawStart(Graphics2D gr) {
        gr.drawImage(startImage.getImage(), 0, 0, null);
    }

    public boolean appliesTo(Object designElement) {
        return designElement instanceof JRDesignElement;
    }
}

