/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ElementNameVisitor
implements JRVisitor {
    private JasperDesign jasperDesign = null;
    private String name = null;

    public ElementNameVisitor(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public String getName(JRVisitable visitable) {
        visitable.visit((JRVisitor)this);
        if (visitable instanceof JRElement) {
            JRElement ele = (JRElement)visitable;
            if (ele.getKey() != null && IReportManager.getPreferences().getBoolean("showKeyInReportInspector", false)) {
                this.name = "" + ele.getKey();
            } else if (this.name != null && ele.getKey() != null) {
                this.name = this.name + " (" + ele.getKey() + ")";
            }
        }
        return this.name;
    }

    public void visitBreak(JRBreak breakElement) {
        this.name = breakElement.getType() == 1 ? "\u6539\u30da\u30fc\u30b8" : "\u5217\u30d6\u30ec\u30fc\u30af";
    }

    public void visitChart(JRChart chart) {
        switch (chart.getChartType()) {
            case 1: {
                this.name = "Area";
                break;
            }
            case 3: {
                this.name = "Bar";
                break;
            }
            case 2: {
                this.name = "Bar 3D";
                break;
            }
            case 4: {
                this.name = "Bubble";
                break;
            }
            case 5: {
                this.name = "Candlestick";
                break;
            }
            case 6: {
                this.name = "High Low";
                break;
            }
            case 7: {
                this.name = "Line";
                break;
            }
            case 17: {
                this.name = "Meter";
                break;
            }
            case 19: {
                this.name = "Multi Axis";
                break;
            }
            case 9: {
                this.name = "Pie";
                break;
            }
            case 8: {
                this.name = "Pie 3D";
                break;
            }
            case 10: {
                this.name = "Scatter";
                break;
            }
            case 12: {
                this.name = "Stackedbar";
                break;
            }
            case 11: {
                this.name = "Stackedbar 3D";
                break;
            }
            case 18: {
                this.name = "Thermometer";
                break;
            }
            case 16: {
                this.name = "Timeseries";
                break;
            }
            case 13: {
                this.name = "XY Area";
                break;
            }
            case 14: {
                this.name = "XY Bar";
                break;
            }
            case 15: {
                this.name = "XY Line";
                break;
            }
            case 20: {
                this.name = "Stackedarea";
                break;
            }
            default: {
                this.name = "Unknown";
            }
        }
        this.name = this.name + " Chart";
    }

    public void visitCrosstab(JRCrosstab crosstab) {
        this.name = "[" + crosstab.getX() + ", " + crosstab.getY() + ", " + crosstab.getWidth() + ", " + crosstab.getHeight() + "]";
    }

    public void visitElementGroup(JRElementGroup elementGroup) {
        this.name = null;
    }

    public void visitEllipse(JREllipse ellipse) {
        this.name = "[" + ellipse.getX() + ", " + ellipse.getY() + ", " + ellipse.getWidth() + ", " + ellipse.getHeight() + "]";
    }

    public void visitFrame(JRFrame frame) {
        this.name = "[" + frame.getX() + ", " + frame.getY() + ", " + frame.getWidth() + ", " + frame.getHeight() + "]";
    }

    public void visitImage(JRImage image) {
        this.name = Misc.getExpressionText(image.getExpression());
        if (this.name.length() > 15) {
            this.name = this.name.substring(0, 15) + "...";
        }
    }

    public void visitLine(JRLine line) {
        this.name = "[" + line.getX() + ", " + line.getY() + ", " + line.getWidth() + ", " + line.getHeight() + "]";
    }

    public void visitRectangle(JRRectangle rectangle) {
        this.name = "[" + rectangle.getX() + ", " + rectangle.getY() + ", " + rectangle.getWidth() + ", " + rectangle.getHeight() + "]";
    }

    public void visitStaticText(JRStaticText staticText) {
        String s = staticText.getText();
        if (s.length() > 15) {
            s = s.substring(0, 15) + "...";
        }
        this.name = staticText.getText();
    }

    public void visitSubreport(JRSubreport subreport) {
        this.name = Misc.getExpressionText(subreport.getExpression());
        if (this.name.length() > 15) {
            this.name = this.name.substring(0, 15) + "...";
        }
    }

    public void visitTextField(JRTextField textField) {
        this.name = Misc.getExpressionText(textField.getExpression());
        if (this.name.length() > 15) {
            this.name = this.name.substring(0, 15) + "...";
        }
    }

    public void visitComponentElement(JRComponentElement component) {
        this.name = "Component";
    }

    public void visitGenericElement(JRGenericElement arg0) {
        this.name = "Generic element";
    }
}

