/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.fonts;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.JNumberComboBox;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.openide.util.NbBundle;

public class JRFontPanel
extends JPanel
implements PreferenceChangeListener {
    private JDialog dialog = null;
    private JRFont jRFont = new JRBaseFont();
    private boolean init = false;
    private boolean reportFontMode = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonResetAllToDefault;
    private JCheckBox jCheckBoxBold;
    private JCheckBox jCheckBoxDefaultFont;
    private JCheckBox jCheckBoxItalic;
    private JCheckBox jCheckBoxPDFEmbedded;
    private JCheckBox jCheckBoxStrikeThrough;
    private JCheckBox jCheckBoxUnderline;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxPDFFontName;
    private JComboBox jComboBoxPdfEncoding;
    private JComboBox jComboBoxReportFonts;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel27;
    private JLabel jLabel32;
    private JComboBox jNumberComboBoxSize;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanelFont;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JTextField jTextFieldReportFont;
    private int dialogResult;

    public void fillReportFonts(JasperDesign jasperDesign) {
        if (jasperDesign != null) {
            List reportFonts = jasperDesign.getFontsList();
            for (int i = 0; i < reportFonts.size(); ++i) {
                Misc.updateComboBox(this.jComboBoxReportFonts, reportFonts, true);
            }
        }
    }

    public JRFontPanel() {
        this.initComponents();
        this.jPanel6.setVisible(false);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.3"), 3.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.5"), 5.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.8"), 8.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.10"), 10.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.12"), 12.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.14"), 14.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.18"), 18.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.24"), 24.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.36"), 36.0);
        ((JNumberComboBox)this.jNumberComboBoxSize).addEntry(I18n.getString("Global.ComboBox.48"), 48.0);
        this.jNumberComboBoxSize.setSelectedIndex(3);
        this.jComboBoxPdfEncoding.addItem(new Tag(null, "<\u30c7\u30d5\u30a9\u30eb\u30c8>"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1250", "CP1250 (\u4e2d\u592e\u30e8\u30fc\u30ed\u30c3\u30d1)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1251", "CP1251 (\u30ad\u30ea\u30eb\u6587\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1252", "CP1252 (\u897f\u30e8\u30fc\u30ed\u30c3\u30d1ANSI \u5225\u540d WinAnsi)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1253", "CP1253 (\u30ae\u30ea\u30b7\u30e3\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1254", "CP1254 (\u30c8\u30eb\u30b3\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1255", "CP1255 (\u30d8\u30d6\u30e9\u30a4\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1256", "CP1256 (\u30a2\u30e9\u30d3\u30a2\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1257", "CP1257 (\u30d0\u30eb\u30c1\u30c3\u30af)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Cp1258", "CP1258 (\u30d9\u30c8\u30ca\u30e0\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (\u4e2d\u56fd\u8a9e - \u7c21\u4f53\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (\u4e2d\u56fd\u8a9e - \u7c21\u4f53\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (\u4e2d\u56fd\u8a9e - \u7e41\u4f53\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (\u4e2d\u56fd\u8a9e- \u7e41\u4f53\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (\u65e5\u672c\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (\u65e5\u672c\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (\u65e5\u672c\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (\u65e5\u672c\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (\u97d3\u56fd\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (\u97d3\u56fd\u8a9e)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Identity-H", "Identity-H (Unicode - \u6a2a\u6587\u5b57)"));
        this.jComboBoxPdfEncoding.addItem(new Tag("Identity-V", "Identity-V (Unicode - \u7e26\u6587\u5b57)"));
        this.updateStandardFonts();
        this.updateFonts();
        this.jComboBoxReportFonts.setVisible(false);
        this.setReportFontMode(this.reportFontMode);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    public void updateStandardFonts() {
        this.jComboBoxFontName.removeAllItems();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
        Collection extensionFonts = JRFontUtil.getFontFamilyNames();
        for (String fname : extensionFonts) {
            System.out.println("JR\u6307\u5b9a\u30d5\u30a1\u30df\u30ea\uff1a " + fname);
            this.jComboBoxFontName.addItem(fname);
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.jComboBoxFontName.addItem(fontFamilies[i]);
        }
    }

    private void initComponents() {
        this.jPanelFont = new JPanel();
        this.jLabel24 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jComboBoxFontName = new JComboBox();
        this.jNumberComboBoxSize = new JNumberComboBox();
        this.jLabel25 = new JLabel();
        this.jComboBoxPDFFontName = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxBold = new JCheckBox();
        this.jCheckBoxUnderline = new JCheckBox();
        this.jCheckBoxItalic = new JCheckBox();
        this.jCheckBoxStrikeThrough = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxPDFEmbedded = new JCheckBox();
        this.jCheckBoxDefaultFont = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jLabel32 = new JLabel();
        this.jComboBoxPdfEncoding = new JComboBox();
        this.jLabel23 = new JLabel();
        this.jTextFieldReportFont = new JTextField();
        this.jSeparator3 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonResetAllToDefault = new JButton();
        this.jComboBoxReportFonts = new JComboBox();
        this.jSeparator4 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.jPanelFont.setLayout(new GridBagLayout());
        this.jLabel24.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jLabel24.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel27.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jLabel27.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.jPanelFont.add((Component)this.jLabel27, gridBagConstraints);
        this.jComboBoxFontName.setEditable(true);
        this.jComboBoxFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jComboBoxFontNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jComboBoxFontName, gridBagConstraints);
        this.jNumberComboBoxSize.setEditable(true);
        this.jNumberComboBoxSize.setMinimumSize(new Dimension(70, 22));
        this.jNumberComboBoxSize.setPreferredSize(new Dimension(70, 22));
        this.jNumberComboBoxSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jNumberComboBoxSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanelFont.add((Component)this.jNumberComboBoxSize, gridBagConstraints);
        this.jLabel25.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jLabel25.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jLabel25, gridBagConstraints);
        this.jComboBoxPDFFontName.setEditable(true);
        this.jComboBoxPDFFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jComboBoxPDFFontNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxPDFFontName, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jCheckBoxBold.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxBold.text"));
        this.jCheckBoxBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxBoldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxBold, gridBagConstraints);
        this.jCheckBoxUnderline.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxUnderline.text"));
        this.jCheckBoxUnderline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxUnderlineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jCheckBoxUnderline, gridBagConstraints);
        this.jCheckBoxItalic.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxItalic.text"));
        this.jCheckBoxItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxItalicActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxItalic, gridBagConstraints);
        this.jCheckBoxStrikeThrough.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxStrikeThrough.text"));
        this.jCheckBoxStrikeThrough.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxStrikeThroughActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jCheckBoxStrikeThrough, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanelFont.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.jCheckBoxPDFEmbedded.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxPDFEmbedded.text"));
        this.jCheckBoxPDFEmbedded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxPDFEmbeddedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxPDFEmbedded, gridBagConstraints);
        this.jCheckBoxDefaultFont.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jCheckBoxDefaultFont.text"));
        this.jCheckBoxDefaultFont.setEnabled(false);
        this.jCheckBoxDefaultFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jCheckBoxDefaultFontActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jCheckBoxDefaultFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jLabel32.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jLabel32.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jLabel32, gridBagConstraints);
        this.jComboBoxPdfEncoding.setEditable(true);
        this.jComboBoxPdfEncoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jComboBoxPdfEncodingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jComboBoxPdfEncoding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelFont.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel23.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jLabel23.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jLabel23, gridBagConstraints);
        this.jTextFieldReportFont.setPreferredSize(new Dimension(360, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jTextFieldReportFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanelFont.add((Component)this.jSeparator3, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jButtonOK.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jButtonCancel.text"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        this.jButtonResetAllToDefault.setMnemonic('d');
        this.jButtonResetAllToDefault.setText(NbBundle.getMessage(JRFontPanel.class, (String)"JRFontPanel.jButtonResetAllToDefault.text"));
        this.jButtonResetAllToDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jButtonResetAllToDefaultjButtonOKActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonResetAllToDefault, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jPanel6, gridBagConstraints);
        this.jComboBoxReportFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFontPanel.this.jComboBoxReportFontsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelFont.add((Component)this.jComboBoxReportFonts, gridBagConstraints);
        this.jSeparator4.setPreferredSize(new Dimension(360, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 4, 0);
        this.jPanelFont.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanelFont, gridBagConstraints);
    }

    private void jComboBoxFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.getJRFont().setFontName(this.jComboBoxFontName.getSelectedItem() + "");
    }

    private void jNumberComboBoxSizeActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setFontSize((int)((JNumberComboBox)this.jNumberComboBoxSize).getValue());
    }

    private void jComboBoxPDFFontNameActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPDFFontName.getSelectedItem() == null || (this.jComboBoxPDFFontName.getSelectedItem() + "").equals("")) {
            return;
        }
        Object obj = this.jComboBoxPDFFontName.getSelectedItem();
        String fontName = "" + obj;
        fontName = obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        this.jRFont.setPdfFontName(fontName.length() > 0 ? fontName : null);
    }

    private void jCheckBoxBoldActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setBold(this.jCheckBoxBold.isSelected());
    }

    private void jCheckBoxUnderlineActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setUnderline(this.jCheckBoxUnderline.isSelected());
    }

    private void jCheckBoxItalicActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setItalic(this.jCheckBoxItalic.isSelected());
    }

    private void jCheckBoxStrikeThroughActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setStrikeThrough(this.jCheckBoxStrikeThrough.isSelected());
    }

    private void jCheckBoxPDFEmbeddedActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        this.jRFont.setPdfEmbedded(this.jCheckBoxPDFEmbedded.isSelected());
    }

    private void jCheckBoxDefaultFontActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
    }

    private void jComboBoxPdfEncodingActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
        if (this.jComboBoxPdfEncoding.getSelectedItem() instanceof Tag) {
            this.jRFont.setPdfEncoding("" + ((Tag)this.jComboBoxPdfEncoding.getSelectedItem()).getValue());
        } else {
            String s = "" + this.jComboBoxPdfEncoding.getSelectedItem();
            if (s != null && s.length() == 0) {
                this.jRFont.setPdfEncoding(s);
            } else {
                this.jComboBoxPdfEncoding.setSelectedItem(this.jRFont.getPdfEncoding());
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldReportFont.getText().trim().length() <= 0 && this.isReportFontMode()) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRFontPanel.Message.Warning"), I18n.getString("JRFontPanel.Message.Error"), 2);
            return;
        }
        if (this.dialog != null) {
            this.setDialogResult(0);
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.setDialogResult(2);
            this.dialog.dispose();
        }
    }

    private void jButtonResetAllToDefaultjButtonOKActionPerformed1(ActionEvent evt) {
        JRBaseFont ifont = new JRBaseFont();
        this.setJRFont((JRFont)ifont, this.jTextFieldReportFont.isVisible());
    }

    private void jComboBoxReportFontsActionPerformed(ActionEvent evt) {
        if (this.init) {
            return;
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JRFont getJRFont() {
        return this.jRFont;
    }

    public void setJRFont(JRFont jRFont) {
        this.setJRFont(jRFont, true);
    }

    public void setJRFont(JRFont jRFont, boolean reportFontToo) {
        this.init = true;
        if (jRFont == null) {
            jRFont = new JRBaseFont();
        }
        this.jRFont = jRFont;
        this.jCheckBoxBold.setSelected(jRFont.isBold());
        this.jCheckBoxItalic.setSelected(jRFont.isItalic());
        this.jCheckBoxStrikeThrough.setSelected(jRFont.isStrikeThrough());
        this.jCheckBoxPDFEmbedded.setSelected(jRFont.isPdfEmbedded());
        this.jCheckBoxUnderline.setSelected(jRFont.isUnderline());
        this.setComboBoxText(true, jRFont.getFontName(), this.jComboBoxFontName);
        this.setMixedTagComboBox(true, jRFont.getPdfFontName(), this.jComboBoxPDFFontName);
        this.setElementComboNumber(true, jRFont.getFontSize(), (JNumberComboBox)this.jNumberComboBoxSize);
        this.setPdfEncodingComboBox(true, jRFont.getPdfEncoding(), this.jComboBoxPdfEncoding);
        this.init = false;
    }

    public void updateFonts() {
        ArrayList<Tag> fontsVec = new ArrayList<Tag>();
        fontsVec.add(new Tag("Helvetica"));
        fontsVec.add(new Tag("Helvetica-Bold"));
        fontsVec.add(new Tag("Helvetica-BoldOblique"));
        fontsVec.add(new Tag("Helvetica-Oblique"));
        fontsVec.add(new Tag("Courier"));
        fontsVec.add(new Tag("Courier-Bold"));
        fontsVec.add(new Tag("Courier-BoldOblique"));
        fontsVec.add(new Tag("Courier-Oblique"));
        fontsVec.add(new Tag("Symbol"));
        fontsVec.add(new Tag("Times-Roman"));
        fontsVec.add(new Tag("Times-Bold"));
        fontsVec.add(new Tag("Times-BoldItalic"));
        fontsVec.add(new Tag("Times-Italic"));
        fontsVec.add(new Tag("ZapfDingbats"));
        fontsVec.add(new Tag("STSong-Light"));
        fontsVec.add(new Tag("MHei-Medium"));
        fontsVec.add(new Tag("MSung-Light"));
        fontsVec.add(new Tag("HeiseiKakuGo-W5"));
        fontsVec.add(new Tag("HeiseiMin-W3"));
        fontsVec.add(new Tag("HYGoThic-Medium"));
        fontsVec.add(new Tag("HYSMyeongJo-Medium"));
        List<IRFont> fonts = IReportManager.getInstance().getIRFonts();
        for (IRFont f : fonts) {
            fontsVec.add(new Tag(f.getFile(), f.toString()));
        }
        Misc.updateComboBox(this.jComboBoxPDFFontName, fontsVec);
    }

    protected boolean setComboBoxText(boolean firstTime, String value, JComboBox comboField) {
        if (!firstTime && !Misc.nvl(comboField.getSelectedItem(), "").equalsIgnoreCase(value)) {
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setMixedTagComboBox(boolean firstTime, Object value, JComboBox comboField) {
        if (firstTime) {
            try {
                for (int i = 0; i < comboField.getItemCount(); ++i) {
                    if (!(comboField.getItemAt(i) instanceof Tag) || !((Tag)comboField.getItemAt(i)).getValue().equals(value)) continue;
                    comboField.setSelectedIndex(i);
                    return true;
                }
                comboField.setSelectedItem(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object selectedValue = comboField.getSelectedItem();
        if (selectedValue == null && value == null) {
            return true;
        }
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Tag) {
            selectedValue = ((Tag)selectedValue).getValue();
        }
        return selectedValue.equals(value);
    }

    protected boolean setPdfEncodingComboBox(boolean firstTime, String value, JComboBox comboField) {
        if (!(firstTime || comboField.getSelectedItem() != null && (comboField.getSelectedItem() instanceof Tag && (((Tag)comboField.getSelectedItem()).getValue() + "").equalsIgnoreCase(value) || (comboField.getSelectedItem() + "").equals(value)))) {
            if (comboField.getItemCount() > 0) {
                comboField.setSelectedIndex(0);
            }
            return false;
        }
        try {
            for (int i = 0; i < comboField.getItemCount(); ++i) {
                if (!(comboField.getItemAt(i) instanceof Tag) || !((Tag)comboField.getItemAt(i)).getValue().equals(value)) continue;
                comboField.setSelectedIndex(i);
                return true;
            }
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementComboNumber(boolean firstTime, double value, JNumberComboBox numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setSelectedItem("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public boolean isReportFontMode() {
        return this.reportFontMode;
    }

    public void setReportFontMode(boolean reportFontMode) {
        this.setReportFontMode(reportFontMode ? 1 : 0);
    }

    public void setReportFontMode(int reportFontMode) {
        this.reportFontMode = reportFontMode == 1;
        this.jComboBoxReportFonts.setVisible(reportFontMode == 0);
        this.jTextFieldReportFont.setVisible(reportFontMode == 1);
        this.jCheckBoxDefaultFont.setEnabled(reportFontMode == 1);
        this.jLabel23.setVisible(reportFontMode != 3);
        if (this.jComboBoxReportFonts.getItemCount() == 0) {
            // empty if block
        }
    }

    public int showDialog(Component parent) {
        Window pWin = SwingUtilities.windowForComponent(parent);
        this.dialog = pWin instanceof Frame ? new JDialog((Frame)pWin) : (pWin instanceof Dialog ? new JDialog((Dialog)pWin) : new JDialog());
        this.dialog.setModal(true);
        this.jPanel6.setVisible(true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRFontPanel.this.jButtonCancelActionPerformed(e);
            }
        };
        this.dialog.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.dialog.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.dialog.getContentPane().add((Component)this, gridBagConstraints);
        this.dialog.getRootPane().setDefaultButton(this.jButtonOK);
        this.dialog.setVisible(true);
        return this.getDialogResult();
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || evt.getKey() == null || evt.getKey().equals("IREPORT_CLASSPATH")) {
            this.updateStandardFonts();
        }
    }
}

