/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import com.jaspersoft.ireport.designer.editor.CrosstabTotalVariable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionContext {
    public static final String ATTRIBUTE_EXPRESSION_CONTEXT = "EXPRESSION_CONTEXT";
    private static ExpressionContext globalContext = null;
    public static JEditorPane activeEditor = null;
    private List<JRDesignDataset> datasets = new ArrayList<JRDesignDataset>();
    private List<JRDesignCrosstab> crosstabs = new ArrayList<JRDesignCrosstab>();

    public static ExpressionContext getGlobalContext() {
        return globalContext;
    }

    public static synchronized void setGlobalContext(ExpressionContext g) {
        globalContext = g;
    }

    public List<JRDesignDataset> getDatasets() {
        return this.datasets;
    }

    public List<JRDesignCrosstab> getCrosstabs() {
        return this.crosstabs;
    }

    public ExpressionContext() {
    }

    public ExpressionContext(JRDesignDataset dataset) {
        this.datasets.add(dataset);
    }

    public ExpressionContext(JRDesignCrosstab crosstab) {
        this.crosstabs.add(crosstab);
    }

    public String findObjectClassName(String objName, char type) {
        block6: {
            block7: {
                block5: {
                    if (type != 'P') break block5;
                    for (JRDesignDataset dataset : this.getDatasets()) {
                        if (!dataset.getParametersMap().containsKey(objName)) continue;
                        return ((JRParameter)dataset.getParametersMap().get(objName)).getValueClassName();
                    }
                    for (JRDesignCrosstab crosstab : this.getCrosstabs()) {
                        String className = ExpressionContext.getCrosstabParameterClassName(crosstab, objName);
                        if (className == null) continue;
                        return className;
                    }
                    break block6;
                }
                if (type != 'V') break block7;
                for (JRDesignDataset dataset : this.getDatasets()) {
                    if (!dataset.getVariablesMap().containsKey(objName)) continue;
                    return ((JRVariable)dataset.getVariablesMap().get(objName)).getValueClassName();
                }
                for (JRDesignCrosstab crosstab : this.getCrosstabs()) {
                    String className = ExpressionContext.getCrosstabVariableClassName(crosstab, objName);
                    if (className == null) continue;
                    return className;
                }
                break block6;
            }
            if (type != 'F') break block6;
            for (JRDesignDataset dataset : this.getDatasets()) {
                if (!dataset.getFieldsMap().containsKey(objName)) continue;
                return ((JRField)dataset.getFieldsMap().get(objName)).getValueClassName();
            }
        }
        return null;
    }

    private static final String getCrosstabParameterClassName(JRDesignCrosstab crosstab, String name) {
        if (crosstab.getParametersMap().containsKey(name)) {
            return ((JRCrosstabParameter)crosstab.getParametersMap().get(name)).getValueClassName();
        }
        return null;
    }

    private static final String getCrosstabVariableClassName(JRDesignCrosstab crosstab, String name) {
        int i;
        List rowGroups = crosstab.getRowGroupsList();
        List columnGroups = crosstab.getColumnGroupsList();
        for (JRDesignCrosstabMeasure measure : crosstab.getMesuresList()) {
            if (name.equals(measure.getVariable().getName())) {
                return measure.getVariable().getValueClassName();
            }
            for (int i2 = 0; i2 < rowGroups.size(); ++i2) {
                JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i2);
                CrosstabTotalVariable var = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, null);
                if (("$V{" + name + "}").equals(var.getExpression())) {
                    return var.getClassType();
                }
                for (int j = 0; j < columnGroups.size(); ++j) {
                    JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(j);
                    if (j == 0) {
                        CrosstabTotalVariable var2 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, null, (JRCrosstabColumnGroup)columnGroup);
                        if (("$V{" + name + "}").equals(var2.getExpression())) {
                            return var2.getClassType();
                        }
                    }
                    CrosstabTotalVariable var3 = new CrosstabTotalVariable((JRCrosstabMeasure)measure, (JRCrosstabRowGroup)rowGroup, (JRCrosstabColumnGroup)columnGroup);
                    if (!("$V{" + name + "}").equals(var3.getExpression())) continue;
                    return var3.getClassType();
                }
            }
        }
        for (i = 0; i < rowGroups.size(); ++i) {
            JRDesignCrosstabRowGroup rowGroup = (JRDesignCrosstabRowGroup)rowGroups.get(i);
            if (!name.equals(rowGroup.getVariable().getName())) continue;
            return rowGroup.getVariable().getValueClassName();
        }
        for (i = 0; i < columnGroups.size(); ++i) {
            JRDesignCrosstabColumnGroup columnGroup = (JRDesignCrosstabColumnGroup)columnGroups.get(i);
            if (!name.equals(columnGroup.getVariable().getName())) continue;
            return columnGroup.getVariable().getValueClassName();
        }
        return null;
    }
}

