/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.MondrianConnection;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class MondrianConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private JButton jButtonBrowseCatalog;
    private JComboBox jComboBoxMondrianJdbc;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JPanel jPanel14;
    private JPanel jPanelMondrian;
    private JTextField jTextFieldCatalogURI;

    public MondrianConnectionEditor() {
        this.initComponents();
        List<IReportConnection> conns = IReportManager.getInstance().getConnections();
        for (IReportConnection con : conns) {
            if (!(con instanceof JDBCConnection)) continue;
            this.jComboBoxMondrianJdbc.addItem(con.getName());
        }
        if (this.jComboBoxMondrianJdbc.getItemCount() > 0) {
            this.jComboBoxMondrianJdbc.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jPanelMondrian = new JPanel();
        this.jLabel20 = new JLabel();
        this.jComboBoxMondrianJdbc = new JComboBox();
        this.jLabel19 = new JLabel();
        this.jTextFieldCatalogURI = new JTextField();
        this.jButtonBrowseCatalog = new JButton();
        this.jPanel14 = new JPanel();
        this.setLayout(new BorderLayout());
        this.jPanelMondrian.setLayout(new GridBagLayout());
        this.jLabel20.setText("JDBC\u63a5\u7d9a");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelMondrian.add((Component)this.jLabel20, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelMondrian.add((Component)this.jComboBoxMondrianJdbc, gridBagConstraints);
        this.jLabel19.setText("\u30ab\u30bf\u30ed\u30b0URI (\u4f8b\uff1afile:/path/schema.xml) ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelMondrian.add((Component)this.jLabel19, gridBagConstraints);
        this.jTextFieldCatalogURI.setMargin(new Insets(0, 5, 2, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 3, 4);
        this.jPanelMondrian.add((Component)this.jTextFieldCatalogURI, gridBagConstraints);
        this.jButtonBrowseCatalog.setText("\u53c2\u7167...");
        this.jButtonBrowseCatalog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MondrianConnectionEditor.this.jButtonBrowseCatalogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.jPanelMondrian.add((Component)this.jButtonBrowseCatalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelMondrian.add((Component)this.jPanel14, gridBagConstraints);
        this.add((Component)this.jPanelMondrian, "Center");
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof MondrianConnection) {
            MondrianConnection con = (MondrianConnection)this.iReportConnection;
            this.jTextFieldCatalogURI.setText(Misc.nvl(con.getProperties().get("CatalogUri"), ""));
            this.jComboBoxMondrianJdbc.setSelectedItem(con.getConnectionName());
        }
    }

    public IReportConnection getIReportConnection() {
        if (this.jComboBoxMondrianJdbc.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "You have to choose a JDBC connection in order to configure the Mondrian OLAP connection.\nIf JDBC connection are not yet available, please create one before creating this connection.", "Invalid JDBC connection!", 2);
            return null;
        }
        if (this.jTextFieldCatalogURI.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please set the Catalog URI", "Invalid URI!", 2);
            return null;
        }
        MondrianConnection irConn = new MondrianConnection();
        ((IReportConnection)irConn).getProperties().put("CatalogUri", this.jTextFieldCatalogURI.getText().trim());
        ((IReportConnection)irConn).getProperties().put("ConnectionName", this.jComboBoxMondrianJdbc.getSelectedItem() + "");
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }

    private void jButtonBrowseCatalogActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle("Select file....");
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return "XML *.xml";
            }
        });
        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File file = jfc.getSelectedFile();
            try {
                this.jTextFieldCatalogURI.setText(file.toURI() + "");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

