/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.SimpleSQLDataSource;
import com.jaspersoft.ireport.designer.connection.gui.MondrianConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import net.sf.jasperreports.engine.JRDataSource;

public class MondrianConnection
extends IReportConnection {
    public static final String CATALOG_URI = "CatalogUri";
    public static final String CONNECTION_NAME = "ConnectionName";
    private HashMap map = new HashMap();
    private Connection mondrianConnection = null;
    private int usedby = 0;

    public java.sql.Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        return this.map;
    }

    public void loadProperties(HashMap map) {
        this.map = map;
    }

    public JRDataSource getJRDataSource() {
        return null;
    }

    public void closeMondrianConnection() {
        try {
            if (this.getMondrianConnection() != null) {
                --this.usedby;
                if (this.usedby == 0) {
                    this.mondrianConnection.close();
                    this.mondrianConnection = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getMondrianConnection() throws Exception {
        if (this.mondrianConnection == null) {
            JDBCConnection con = this.getJDBCConnection();
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                java.sql.Connection conn = null;
                try {
                    conn = con.getConnection();
                    if (conn == null) {
                        throw new Exception("No DB connection");
                    }
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e) {}
                    }
                }
                Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
                Util.PropertyList props = new Util.PropertyList();
                props.put("Catalog", this.getCatalogUri());
                props.put("Provider", "mondrian");
                props.put("Locale", Locale.getDefault().getLanguage());
                SimpleSQLDataSource ds = new SimpleSQLDataSource(con);
                this.mondrianConnection = DriverManager.getConnection((Util.PropertyList)props, null, (DataSource)ds);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        ++this.usedby;
        return this.mondrianConnection;
    }

    public void setMondrianConnection(Connection mondrianConnection) {
        this.mondrianConnection = mondrianConnection;
    }

    public String getCatalogUri() {
        return (String)this.getProperties().get(CATALOG_URI);
    }

    public void setCatalogUri(String catalogUri) {
        this.getProperties().put(CATALOG_URI, catalogUri);
    }

    public String getConnectionName() {
        return (String)this.getProperties().get(CONNECTION_NAME);
    }

    public void setConnectionName(String connectionName) {
        this.getProperties().put(CONNECTION_NAME, connectionName);
    }

    private JDBCConnection getJDBCConnection() {
        String name = this.getConnectionName();
        List<IReportConnection> conns = IReportManager.getInstance().getConnections();
        for (IReportConnection con : conns) {
            if (!(con instanceof JDBCConnection) || !con.getName().equals(name)) continue;
            return (JDBCConnection)con;
        }
        return null;
    }

    public String escapeProperty(String s) {
        if (s == null) {
            s = "";
        }
        s = Misc.string_replace("\"\"", "\"", s);
        return s;
    }

    public String getDescription() {
        return "Mondrian OLAP\u63a5\u7d9a";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new MondrianConnectionEditor();
    }

    public void test() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = Thread.currentThread();
                    IReportManager.getInstance();
                    thread.setContextClassLoader(IReportManager.getReportClassLoader());
                    try {
                        MondrianConnection.this.getMondrianConnection();
                        MondrianConnection.this.closeMondrianConnection();
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
                        return;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

