/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets.wizards;

import com.jaspersoft.ireport.designer.charts.datasets.wizards.CategoryDatasetWizardPanel1;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.CategoryDatasetWizardPanel2;
import com.jaspersoft.ireport.designer.charts.datasets.wizards.CategoryDatasetWizardPanel3;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import javax.swing.JComponent;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class CategoryDatasetWizardAction
extends CallableSystemAction {
    private WizardDescriptor.Panel[] panels;

    public void performAction() {
    }

    public void configureChart(JRDesignCategoryDataset dataset, byte chartType) {
        boolean cancelled;
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle("\u30ab\u30c6\u30b4\u30ea\u30fb\u30c1\u30e3\u30fc\u30c8\u30a6\u30a3\u30b6\u30fc\u30c9");
        wizardDescriptor.putProperty("chartType", (Object)chartType);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            JRDesignDataset ds = (JRDesignDataset)wizardDescriptor.getProperty("dataset");
            if (ds == null) {
                return;
            }
            if (!ds.isMainDataset()) {
                JRDesignDatasetRun dr = new JRDesignDatasetRun();
                dr.setDatasetName(ds.getName());
                dataset.setDatasetRun((JRDatasetRun)dr);
            } else {
                dataset.setDatasetRun(null);
            }
            if (wizardDescriptor.getProperty("seriesExpression") != null && wizardDescriptor.getProperty("categoryExpression") != null && wizardDescriptor.getProperty("valueExpression") != null) {
                JRDesignCategorySeries series = new JRDesignCategorySeries();
                series.setSeriesExpression((JRExpression)Misc.createExpression("java.lang.Object", (String)wizardDescriptor.getProperty("seriesExpression")));
                series.setCategoryExpression((JRExpression)Misc.createExpression("java.lang.Object", (String)wizardDescriptor.getProperty("categoryExpression")));
                series.setValueExpression((JRExpression)Misc.createExpression("java.lang.Number", (String)wizardDescriptor.getProperty("valueExpression")));
                while (dataset.getSeriesList().size() > 0) {
                    dataset.removeCategorySeries((JRCategorySeries)dataset.getSeriesList().get(0));
                }
                dataset.addCategorySeries((JRCategorySeries)series);
            }
        }
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new CategoryDatasetWizardPanel1(), new CategoryDatasetWizardPanel2(), new CategoryDatasetWizardPanel3()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String getName() {
        return "Start Sample Wizard";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

