/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Toolkit;
import java.io.CharConversionException;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

final class TextDetail {
    static final int DH_SHOW = 1;
    static final int DH_GOTO = 2;
    static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;

    TextDetail(DataObject dataObject, SearchPattern searchPattern) {
        this.dobj = dataObject;
        this.searchPattern = searchPattern;
    }

    void showDetail(int n) {
        JEditorPane[] jEditorPaneArray;
        this.prepareLine();
        if (this.lineObj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (n == 3) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)this.dobj.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
        }
        if (n == 1) {
            this.lineObj.show(0, this.column - 1);
        } else if (n == 2) {
            this.lineObj.show(2, this.column - 1);
        }
        if (this.markLength > 0 && editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Caret caret = jEditorPaneArray[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(this.searchPattern);
    }

    String getLineText() {
        return this.lineText;
    }

    void setLineText(String string) {
        this.lineText = string;
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    int getLine() {
        return this.line;
    }

    void setLine(int n) {
        this.line = n;
    }

    int getColumn() {
        return this.column;
    }

    void setColumn(int n) {
        this.column = n;
    }

    void setMarkLength(int n) {
        this.markLength = n;
    }

    int getMarkLength() {
        return this.markLength;
    }

    private void prepareLine() {
        LineCookie lineCookie;
        if (this.dobj == null || !this.dobj.isValid()) {
            this.lineObj = null;
        } else if (this.lineObj == null && (lineCookie = (LineCookie)this.dobj.getCookie(LineCookie.class)) != null) {
            Line.Set set = lineCookie.getLineSet();
            try {
                this.lineObj = set.getOriginal(this.line - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.lineObj = set.getOriginal(TextDetail.findMaxLine(set));
                this.markLength = 0;
                this.column = 0;
            }
        }
    }

    private static int findMaxLine(Line.Set set) {
        int n = 0;
        int n2 = 32000;
        try {
            while (true) {
                set.getOriginal(n2);
                n = n2;
                n2 *= 2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            while (n < n2) {
                int n3 = (n + n2 + 1) / 2;
                try {
                    set.getOriginal(n3);
                    n = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                    n2 = n3 - 1;
                }
            }
            return n;
        }
    }

    private static class GotoDetailAction
    extends NodeAction {
        private GotoDetailAction() {
        }

        public String getName() {
            return NbBundle.getBundle(GotoDetailAction.class).getString("LBL_GotoDetailAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(GotoDetailAction.class);
        }

        protected boolean enable(Node[] nodeArray) {
            return nodeArray != null && nodeArray.length != 0 && nodeArray[0] instanceof DetailNode;
        }

        protected void performAction(Node[] nodeArray) {
            if (this.enable(nodeArray)) {
                ((DetailNode)nodeArray[0]).gotoDetail();
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    static final class DetailNode
    extends AbstractNode
    implements OutputListener {
        private TextDetail txtDetail;

        public DetailNode(TextDetail textDetail) {
            super(Children.LEAF);
            this.txtDetail = textDetail;
            this.setShortDescription(DetailNode.getShortDesc(textDetail));
            this.setValue("output line", DetailNode.getFullDesc(textDetail));
            textDetail.prepareLine();
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public Action getPreferredAction() {
            return SystemAction.get(GotoDetailAction.class);
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == DetailNode.class && ((DetailNode)((Object)object)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            String string;
            if (this.txtDetail.getMarkLength() > 0 && this.txtDetail.getColumn() > 0) {
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = this.txtDetail.getLineText();
                    int n = this.txtDetail.getColumn() - 1;
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(0, n)));
                    stringBuffer.append("<b>");
                    int n2 = n + this.txtDetail.getMarkLength();
                    stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n, n2)));
                    stringBuffer.append("</b>");
                    if (this.txtDetail.getLineText().length() > n2) {
                        stringBuffer.append(XMLUtil.toElementContent((String)string2.substring(n2)));
                    }
                    string = stringBuffer.toString();
                }
                catch (CharConversionException charConversionException) {
                    return null;
                }
            }
            try {
                string = XMLUtil.toElementContent((String)this.txtDetail.getLineText());
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
            try {
                return string + "      <font color='!controlShadow'>[" + XMLUtil.toElementContent((String)DetailNode.getName(this.txtDetail)) + "]";
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }

        private void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(n));
        }

        private static String getShortDesc(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(n));
        }

        private static String getFullDesc(TextDetail textDetail) {
            String string = textDetail.getDataObject().getPrimaryFile().getNameExt();
            String string2 = textDetail.getLineText();
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{string2, string, Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{string2, string, Integer.toString(n)});
        }
    }
}

