/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.rolap.aggmatcher.AggTableManager;
import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaTest
extends FoodMartTestCase {
    public SchemaTest(String name) {
        super(name);
    }

    private void assertContains(List<Exception> exceptionList, String expected) {
        StringBuilder buf = new StringBuilder();
        for (Exception exception : exceptionList) {
            if (exception.getMessage().matches(expected)) {
                return;
            }
            if (buf.length() > 0) {
                buf.append(Util.nl);
            }
            buf.append(exception.getMessage());
        }
        SchemaTest.fail((String)("Exception list did not contain expected exception '" + expected + "'. Exception list is:" + buf.toString()));
    }

    public void testSolveOrderInCalculatedMember() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", null, "<CalculatedMember\n      name=\"QuantumProfit\"\n      dimension=\"Measures\">\n    <Formula>[Measures].[Store Sales] / [Measures].[Store Cost]</Formula>\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n  </CalculatedMember>, <CalculatedMember\n      name=\"foo\"\n      dimension=\"Gender\">\n    <Formula>Sum(Gender.Members)</Formula>\n    <CalculatedMemberProperty name=\"FORMAT_STRING\" value=\"$#,##0.00\"/>\n    <CalculatedMemberProperty name=\"SOLVE_ORDER\" value='2000'/>\n  </CalculatedMember>");
        testContext.assertQueryReturns("select {[Measures].[QuantumProfit]} on 0, {(Gender.foo)} on 1 from sales", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[QuantumProfit]}\nAxis #2:\n{[Gender].[foo]}\nRow #0: $7.52\n"));
    }

    public void testHierarchyDefaultMember() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Gender with default\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\" defaultMember=\"[Gender with default].[All Gender with defaults].[M]\" >\n      <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\" />\n    </Hierarchy>\n  </Dimension>");
        testContext.assertQueryReturns("select {[Gender with default]} on columns from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender with default].[All Gender with defaults].[M]}\nRow #0: 135,215\n"));
    }

    public void testDefaultMemberName() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Product with no all\" foreignKey=\"product_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Class\" table=\"product_class\" nameColumn=\"product_subcategory\"\n          column=\"product_class_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n      <Level name=\"Brand Name\" table=\"product\" column=\"brand_name\" uniqueMembers=\"false\"/>\n      <Level name=\"Product Name\" table=\"product\" column=\"product_name\"\n          uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n");
        testContext.assertQueryReturns("select {[Product with no all]} on columns from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product with no all].[Nuts]}\nRow #0: 4,400\n"));
    }

    public void testHierarchyAbbreviatedDefaultMember() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Gender with default\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\" defaultMember=\"[Gender with default].[F]\" >\n      <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\" />\n    </Hierarchy>\n  </Dimension>");
        testContext.assertQueryReturns("select {[Gender with default]} on columns from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender with default].[All Gender with defaults].[F]}\nRow #0: 131,558\n"));
    }

    public void testHierarchyTableNotFound() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income3\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer_not_found\"/>\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertSimpleQuery();
        testContext.assertThrows("select [Yearly Income3].Children from [Sales]", "Error while parsing MDX statement");
    }

    public void testPrimaryKeyTableNotFound() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income4\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\" primaryKeyTable=\"customer_not_found\">\n    <Table name=\"customer\"/>\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertThrows("select from [Sales]", "no table 'customer_not_found' found in hierarchy [Yearly Income4]");
    }

    public void testLevelTableNotFound() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income5\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n    <Level name=\"Yearly Income\" table=\"customer_not_found\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertThrows("select from [Sales]", "Table 'customer_not_found' not found");
    }

    public void testHierarchyBadDefaultMember() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Gender with default\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\" defaultMember=\"[Gender with default].[Non].[Existent]\" >\n      <Table name=\"customer\"/>\n      <Level name=\"Gender\" column=\"gender\" uniqueMembers=\"true\" />\n    </Hierarchy>\n  </Dimension>");
        testContext.assertThrows("select {[Gender with default]} on columns from [Sales]", "Can not find Default Member with name \"[Gender with default].[Non].[Existent]\" in Hierarchy \"Gender with default\"");
    }

    public void testDuplicateTableAlias() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income2\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select {[Yearly Income2]} on columns, {[Measures].[Unit Sales]} on rows from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Yearly Income2].[All Yearly Income2s]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"));
    }

    public void testDuplicateTableAliasSameForeignKey() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income2\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\"/>\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select from [Sales]", SchemaTest.fold("Axis #0:\n{}\n266,773"));
    }

    public void testDimensionsShareTable() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income2\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\" alias=\"customerx\" />\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select {[Yearly Income].[$10K - $30K]} on columns,{[Yearly Income2].[$150K +]} on rows from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K]}\nAxis #2:\n{[Yearly Income2].[All Yearly Income2s].[$150K +]}\nRow #0: 918\n"));
        testContext.assertQueryReturns("select NON EMPTY {[Measures].[Unit Sales]} ON COLUMNS,\nNON EMPTY Crossjoin({[Yearly Income].[All Yearly Incomes].Children},\n                     [Yearly Income2].[All Yearly Income2s].Children) ON ROWS\nfrom [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\nRow #0: 12,824\nRow #1: 2,822\nRow #2: 2,933\nRow #3: 918\nRow #4: 18,381\nRow #5: 10,436\nRow #6: 6,777\nRow #7: 2,859\nRow #8: 2,432\nRow #9: 532\nRow #10: 566\nRow #11: 177\nRow #12: 3,877\nRow #13: 2,131\nRow #14: 1,319\nRow #15: 527\nRow #16: 3,331\nRow #17: 643\nRow #18: 703\nRow #19: 187\nRow #20: 4,497\nRow #21: 2,629\nRow #22: 1,681\nRow #23: 721\nRow #24: 1,123\nRow #25: 224\nRow #26: 257\nRow #27: 109\nRow #28: 1,924\nRow #29: 1,026\nRow #30: 675\nRow #31: 291\nRow #32: 19,067\nRow #33: 4,078\nRow #34: 4,235\nRow #35: 1,569\nRow #36: 28,160\nRow #37: 15,368\nRow #38: 10,329\nRow #39: 4,504\nRow #40: 9,708\nRow #41: 2,353\nRow #42: 2,243\nRow #43: 748\nRow #44: 14,469\nRow #45: 7,966\nRow #46: 5,272\nRow #47: 2,208\nRow #48: 7,320\nRow #49: 1,630\nRow #50: 1,602\nRow #51: 541\nRow #52: 10,550\nRow #53: 5,843\nRow #54: 3,997\nRow #55: 1,562\nRow #56: 2,722\nRow #57: 597\nRow #58: 568\nRow #59: 193\nRow #60: 3,800\nRow #61: 2,192\nRow #62: 1,324\nRow #63: 523\n"));
    }

    public void testDimensionsShareTableNativeNonEmptyCrossJoin() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income2\" foreignKey=\"product_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\" alias=\"customerx\" />\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select NonEmptyCrossJoin({[Yearly Income2].[All Yearly Income2s]},{[Customers].[All Customers]}) on rows,NON EMPTY {[Measures].[Unit Sales]} on columns from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Yearly Income2].[All Yearly Income2s], [Customers].[All Customers]}\nRow #0: 266,773\n"));
    }

    public void testDimensionsShareTableSameForeignKeys() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Yearly Income2\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n    <Table name=\"customer\" alias=\"customerx\" />\n    <Level name=\"Yearly Income\" column=\"yearly_income\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>");
        testContext.assertQueryReturns("select {[Yearly Income].[$10K - $30K]} on columns,{[Yearly Income2].[$150K +]} on rows from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K]}\nAxis #2:\n{[Yearly Income2].[All Yearly Income2s].[$150K +]}\nRow #0: \n"));
        testContext.assertQueryReturns("select NON EMPTY {[Measures].[Unit Sales]} ON COLUMNS,\nNON EMPTY Crossjoin({[Yearly Income].[All Yearly Incomes].Children},\n                     [Yearly Income2].[All Yearly Income2s].Children) ON ROWS\nfrom [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Yearly Income].[All Yearly Incomes].[$10K - $30K], [Yearly Income2].[All Yearly Income2s].[$10K - $30K]}\n{[Yearly Income].[All Yearly Incomes].[$110K - $130K], [Yearly Income2].[All Yearly Income2s].[$110K - $130K]}\n{[Yearly Income].[All Yearly Incomes].[$130K - $150K], [Yearly Income2].[All Yearly Income2s].[$130K - $150K]}\n{[Yearly Income].[All Yearly Incomes].[$150K +], [Yearly Income2].[All Yearly Income2s].[$150K +]}\n{[Yearly Income].[All Yearly Incomes].[$30K - $50K], [Yearly Income2].[All Yearly Income2s].[$30K - $50K]}\n{[Yearly Income].[All Yearly Incomes].[$50K - $70K], [Yearly Income2].[All Yearly Income2s].[$50K - $70K]}\n{[Yearly Income].[All Yearly Incomes].[$70K - $90K], [Yearly Income2].[All Yearly Income2s].[$70K - $90K]}\n{[Yearly Income].[All Yearly Incomes].[$90K - $110K], [Yearly Income2].[All Yearly Income2s].[$90K - $110K]}\nRow #0: 57,950\nRow #1: 11,561\nRow #2: 14,392\nRow #3: 5,629\nRow #4: 87,310\nRow #5: 44,967\nRow #6: 33,045\nRow #7: 11,919\n"));
    }

    public void testSnowflakeHierarchyValidationNotNeeded() {
        if (MondrianProperties.instance().ReadAggregates.get() || MondrianProperties.instance().UseAggregates.get()) {
            return;
        }
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Store\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n      <Join leftKey=\"region_id\" rightKey=\"region_id\">\n        <Table name=\"store\"/>\n        <Join leftKey=\"sales_district_id\" rightKey=\"promotion_id\">\n          <Table name=\"region\"/>\n          <Table name=\"promotion\"/>\n        </Join>\n      </Join>\n      <Level name=\"Store Country\" table=\"store\" column=\"store_country\"/>\n      <Level name=\"Store Region\" table=\"region\" column=\"sales_region\" />\n      <Level name=\"Store Name\" table=\"store\" column=\"store_name\" />\n    </Hierarchy>\n    <Hierarchy name=\"MyHierarchy\" hasAll=\"true\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n      <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n        <Table name=\"customer\"/>\n        <Table name=\"region\"/>\n      </Join>\n      <Level name=\"Country\" table=\"customer\" column=\"country\" uniqueMembers=\"true\"/>\n      <Level name=\"Region\" table=\"region\" column=\"sales_region\" uniqueMembers=\"true\"/>\n      <Level name=\"City\" table=\"customer\" column=\"city\" uniqueMembers=\"false\"/>\n      <Level name=\"Name\" table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Customers\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n      <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n        <Table name=\"customer\"/>\n        <Table name=\"region\"/>\n      </Join>\n      <Level name=\"Country\" table=\"customer\" column=\"country\" uniqueMembers=\"true\"/>\n      <Level name=\"Region\" table=\"region\" column=\"sales_region\" uniqueMembers=\"true\"/>\n      <Level name=\"City\" table=\"customer\" column=\"city\" uniqueMembers=\"false\"/>\n      <Level name=\"Name\" table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n<Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select  {[Store.MyHierarchy].[Mexico]} on rows,{[Customers].[USA].[South West]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[South West]}\nAxis #2:\n{[Store].[MyHierarchy].[All MyHierarchys].[Mexico]}\nRow #0: 51,298\n"));
    }

    public void testSnowflakeHierarchyValidationNotNeeded2() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Store\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n      <Join leftKey=\"region_id\" rightKey=\"region_id\">\n        <Table name=\"store\"/>\n        <Join leftKey=\"sales_district_id\" rightKey=\"promotion_id\">\n          <Table name=\"region\"/>\n          <Table name=\"promotion\"/>\n        </Join>\n      </Join>\n      <Level name=\"Store Country\" table=\"store\" column=\"store_country\"/>\n      <Level name=\"Store Region\" table=\"region\" column=\"sales_region\" />\n      <Level name=\"Store Name\" table=\"store\" column=\"store_name\" />\n    </Hierarchy>\n    <Hierarchy name=\"MyHierarchy\" hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n      <Join leftKey=\"region_id\" rightKey=\"region_id\">\n        <Table name=\"store\"/>\n        <Table name=\"region\"/>\n      </Join>\n      <Level name=\"Store Country\" table=\"store\" column=\"store_country\"/>\n      <Level name=\"Store Region\" table=\"region\" column=\"sales_region\" />\n      <Level name=\"Store Name\" table=\"store\" column=\"store_name\" />\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Customers\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n    <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n      <Table name=\"customer\"/>\n      <Table name=\"region\"/>\n    </Join>\n    <Level name=\"Country\" table=\"customer\" column=\"country\" uniqueMembers=\"true\"/>\n    <Level name=\"Region\" table=\"region\" column=\"sales_region\" uniqueMembers=\"true\"/>\n    <Level name=\"City\" table=\"customer\" column=\"city\" uniqueMembers=\"false\"/>\n    <Level name=\"Name\" table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>\n<Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select  {[Store.MyHierarchy].[USA].[South West]} on rows,{[Customers].[USA].[South West]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[South West]}\nAxis #2:\n{[Store].[MyHierarchy].[All MyHierarchys].[USA].[South West]}\nRow #0: 72,631\n"));
    }

    public void testDimensionsShareJoinTable() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"sales_fact_1997\"/>\n<Dimension name=\"Store\" foreignKey=\"store_id\">\n<Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n    <Join leftKey=\"region_id\" rightKey=\"region_id\">\n      <Table name=\"store\"/>\n      <Table name=\"region\"/>\n    </Join>\n <Level name=\"Store Country\" table=\"store\"  column=\"store_country\" uniqueMembers=\"true\"/>\n <Level name=\"Store Region\"  table=\"region\" column=\"sales_region\"  uniqueMembers=\"true\"/>\n <Level name=\"Store Name\"    table=\"store\"  column=\"store_name\"    uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Dimension name=\"Customers\" foreignKey=\"customer_id\">\n<Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n    <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n      <Table name=\"customer\"/>\n      <Table name=\"region\"/>\n    </Join>\n  <Level name=\"Country\" table=\"customer\" column=\"country\"                      uniqueMembers=\"true\"/>\n  <Level name=\"Region\"  table=\"region\"   column=\"sales_region\"                 uniqueMembers=\"true\"/>\n  <Level name=\"City\"    table=\"customer\" column=\"city\"                         uniqueMembers=\"false\"/>\n  <Level name=\"Name\"    table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n<Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\" formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select  {[Store].[USA].[South West]} on rows,{[Customers].[USA].[South West]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[South West]}\nAxis #2:\n{[Store].[All Stores].[USA].[South West]}\nRow #0: 72,631\n"));
    }

    public void testDimensionsShareJoinTableOneAlias() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"sales_fact_1997\"/>\n<Dimension name=\"Store\" foreignKey=\"store_id\">\n<Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n    <Join leftKey=\"region_id\" rightKey=\"region_id\">\n      <Table name=\"store\"/>\n      <Table name=\"region\"/>\n    </Join>\n <Level name=\"Store Country\" table=\"store\"  column=\"store_country\" uniqueMembers=\"true\"/>\n <Level name=\"Store Region\"  table=\"region\" column=\"sales_region\"  uniqueMembers=\"true\"/>\n <Level name=\"Store Name\"    table=\"store\"  column=\"store_name\"    uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Dimension name=\"Customers\" foreignKey=\"customer_id\">\n<Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n    <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n      <Table name=\"customer\"/>\n      <Table name=\"region\" alias=\"customer_region\"/>\n    </Join>\n  <Level name=\"Country\" table=\"customer\" column=\"country\"                      uniqueMembers=\"true\"/>\n  <Level name=\"Region\"  table=\"customer_region\"   column=\"sales_region\"                 uniqueMembers=\"true\"/>\n  <Level name=\"City\"    table=\"customer\" column=\"city\"                         uniqueMembers=\"false\"/>\n  <Level name=\"Name\"    table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n<Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\" formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select  {[Store].[USA].[South West]} on rows,{[Customers].[USA].[South West]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[South West]}\nAxis #2:\n{[Store].[All Stores].[USA].[South West]}\nRow #0: 72,631\n"));
    }

    public void testDimensionsShareJoinTableTwoAliases() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"sales_fact_1997\"/>\n<Dimension name=\"Store\" foreignKey=\"store_id\">\n<Hierarchy hasAll=\"true\" primaryKeyTable=\"store\" primaryKey=\"store_id\">\n    <Join leftKey=\"region_id\" rightKey=\"region_id\">\n      <Table name=\"store\"/>\n      <Table name=\"region\" alias=\"store_region\"/>\n    </Join>\n <Level name=\"Store Country\" table=\"store\"  column=\"store_country\" uniqueMembers=\"true\"/>\n <Level name=\"Store Region\"  table=\"store_region\" column=\"sales_region\"  uniqueMembers=\"true\"/>\n <Level name=\"Store Name\"    table=\"store\"  column=\"store_name\"    uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Dimension name=\"Customers\" foreignKey=\"customer_id\">\n<Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKeyTable=\"customer\" primaryKey=\"customer_id\">\n    <Join leftKey=\"customer_region_id\" rightKey=\"region_id\">\n      <Table name=\"customer\"/>\n      <Table name=\"region\" alias=\"customer_region\"/>\n    </Join>\n  <Level name=\"Country\" table=\"customer\" column=\"country\"                      uniqueMembers=\"true\"/>\n  <Level name=\"Region\"  table=\"customer_region\"   column=\"sales_region\"                 uniqueMembers=\"true\"/>\n  <Level name=\"City\"    table=\"customer\" column=\"city\"                         uniqueMembers=\"false\"/>\n  <Level name=\"Name\"    table=\"customer\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n</Hierarchy>\n</Dimension>\n<Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n<Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\" formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select  {[Store].[USA].[South West]} on rows,{[Customers].[USA].[South West]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[South West]}\nAxis #2:\n{[Store].[All Stores].[USA].[South West]}\nRow #0: 72,631\n"));
    }

    public void testTwoAliasesDimensionsShareTable() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"inventory_fact_1997\"/>\n  <Dimension name=\"StoreA\" foreignKey=\"store_id\">    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">      <Table name=\"store\" alias=\"storea\"/>      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>      <Level name=\"Store Name\"  column=\"store_name\" uniqueMembers=\"true\"/>    </Hierarchy>  </Dimension>  <Dimension name=\"StoreB\" foreignKey=\"warehouse_id\">    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">      <Table name=\"store\"  alias=\"storeb\"/>      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>      <Level name=\"Store Name\" column=\"store_name\" uniqueMembers=\"true\"/>    </Hierarchy>  </Dimension>  <Measure name=\"Store Invoice\" column=\"store_invoice\" aggregator=\"sum\"/>\n  <Measure name=\"Supply Time\" column=\"supply_time\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[StoreA].[USA]} on rows,{[StoreB].[USA]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[StoreB].[All StoreBs].[USA]}\nAxis #2:\n{[StoreA].[All StoreAs].[USA]}\nRow #0: 10,425\n"));
    }

    public void testTwoAliasesDimensionsShareTableSameForeignKeys() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"AliasedDimensionsTesting\" defaultMeasure=\"Supply Time\">\n  <Table name=\"inventory_fact_1997\"/>\n  <Dimension name=\"StoreA\" foreignKey=\"store_id\">    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">      <Table name=\"store\" alias=\"storea\"/>      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>      <Level name=\"Store Name\" column=\"store_name\" uniqueMembers=\"true\"/>    </Hierarchy>  </Dimension>  <Dimension name=\"StoreB\" foreignKey=\"store_id\">    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">      <Table name=\"store\"  alias=\"storeb\"/>      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>      <Level name=\"Store Name\" column=\"store_name\" uniqueMembers=\"true\"/>    </Hierarchy>  </Dimension>  <Measure name=\"Store Invoice\" column=\"store_invoice\" aggregator=\"sum\"/>\n  <Measure name=\"Supply Time\" column=\"supply_time\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[StoreA].[USA]} on rows,{[StoreB].[USA]} on columns from AliasedDimensionsTesting", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[StoreB].[All StoreBs].[USA]}\nAxis #2:\n{[StoreA].[All StoreAs].[USA]}\nRow #0: 10,425\n"));
    }

    public void testMultipleDimensionUsages() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Two Dimensions\">\n  <Table name=\"sales_fact_1997\" alias=\"sales_fact_1997_mdu\"/>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Time2\" source=\"Time\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select\n {[Time2].[1997]} on columns,\n {[Time].[1997].[Q3]} on rows\nFrom [Sales Two Dimensions]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n" + (MondrianProperties.instance().SsasCompatibleNaming.get() ? "{[Time2].[Time].[1997]}\n" : "{[Time2].[1997]}\n") + "Axis #2:\n" + "{[Time].[1997].[Q3]}\n" + "Row #0: 16,266\n"));
    }

    public void testMultipleDimensionHierarchyCaptionUsages() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Two Dimensions\">\n  <Table name=\"sales_fact_1997\" alias=\"sales_fact_1997_mdu\"/>\n  <DimensionUsage name=\"Time\" caption=\"TimeOne\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Time2\" caption=\"TimeTwo\" source=\"Time\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        String query = "select\n {[Time2].[1997]} on columns,\n {[Time].[1997].[Q3]} on rows\nFrom [Sales Two Dimensions]";
        Result result = testContext.executeQuery(query);
        Member member1 = (Member)result.getAxes()[0].getPositions().iterator().next().iterator().next();
        SchemaTest.assertEquals((String)"TimeTwo", (String)member1.getLevel().getDimension().getCaption());
        Member member2 = (Member)result.getAxes()[1].getPositions().iterator().next().iterator().next();
        SchemaTest.assertEquals((String)"TimeOne", (String)member2.getLevel().getDimension().getCaption());
    }

    public void testDimensionCreation() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Create Dimension\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        mondrian.olap.Cube cube = testContext.getConnection().getSchema().lookupCube("Sales Create Dimension", true);
        testContext.assertQueryReturns("select\nNON EMPTY {[Store].[All Stores].children} on columns \nFrom [Sales Create Dimension]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
        String dimension = "<DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>";
        testContext.getConnection().getSchema().createDimension(cube, dimension);
        testContext.assertQueryReturns("select\nNON EMPTY {[Store].[All Stores].children} on columns, \n{[Time].[1997].[Q1]} on rows \nFrom [Sales Create Dimension]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nAxis #2:\n{[Time].[1997].[Q1]}\nRow #0: 66,291\n"));
    }

    public void testDimensionUsageLevel() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Customer Usage Level\">\n  <Table name=\"customer\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" level=\"Store State\" foreignKey=\"state_province\"/>\n  <Measure name=\"Cars\" column=\"num_cars_owned\" aggregator=\"sum\"/>\n  <Measure name=\"Children\" column=\"total_children\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select\n {[Store].[Store State].members} on columns \nFrom [Customer Usage Level]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[Canada].[BC]}\n{[Store].[All Stores].[Mexico].[DF]}\n{[Store].[All Stores].[Mexico].[Guerrero]}\n{[Store].[All Stores].[Mexico].[Jalisco]}\n{[Store].[All Stores].[Mexico].[Veracruz]}\n{[Store].[All Stores].[Mexico].[Yucatan]}\n{[Store].[All Stores].[Mexico].[Zacatecas]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 7,700\nRow #0: 1,492\nRow #0: 228\nRow #0: 206\nRow #0: 195\nRow #0: 229\nRow #0: 1,209\nRow #0: 46,965\nRow #0: 4,686\nRow #0: 32,767\n"));
    }

    public void testAllMemberMultipleDimensionUsages() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Two Sales Dimensions\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Store\" caption=\"First Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <DimensionUsage name=\"Store2\" caption=\"Second Store\" source=\"Store\" foreignKey=\"product_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        String store2AllMember = MondrianProperties.instance().SsasCompatibleNaming.get() ? "[Store2].[All Stores]" : "[Store2].[All Store2s]";
        testContext.assertQueryReturns("select\n {[Store].[Store].[All Stores]} on columns,\n {" + store2AllMember + "} on rows\n" + "From [Sales Two Sales Dimensions]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores]}\nAxis #2:\n{[Store2].[Store].[All Stores]}\nRow #0: 266,773\n"));
        Result result = testContext.executeQuery("select ([Store].[All Stores], " + store2AllMember + ") on 0\n" + "from [Sales Two Sales Dimensions]");
        Axis axis = result.getAxes()[0];
        Position position = axis.getPositions().get(0);
        SchemaTest.assertEquals((String)"First Store", (String)((Member)position.get(0)).getDimension().getCaption());
        SchemaTest.assertEquals((String)"Second Store", (String)((Member)position.get(1)).getDimension().getCaption());
    }

    public void testNonAliasedDimensionUsage() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Two Dimensions\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Time2\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        String query = "select\n {[Time].[1997]} on columns \nFrom [Sales Two Dimensions]";
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            testContext.assertThrows("select\n {[Time].[1997]} on columns \nFrom [Sales Two Dimensions]", "In cube \"Sales Two Dimensions\" use of unaliased Dimension name \"[Time]\" rather than the alias name \"Time2\"");
        } else {
            testContext.assertQueryReturns("select\n {[Time].[1997]} on columns \nFrom [Sales Two Dimensions]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time2].[Time].[1997]}\nRow #0: 266,773\n"));
        }
    }

    public void testViewFactTable() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Warehouse (based on view)\">\n  <View alias=\"FACT\">\n    <SQL dialect=\"generic\">\n     <![CDATA[select * from \"inventory_fact_1997\" as \"FOOBAR\"]]>\n    </SQL>\n    <SQL dialect=\"oracle\">\n     <![CDATA[select * from \"inventory_fact_1997\" \"FOOBAR\"]]>\n    </SQL>\n    <SQL dialect=\"mysql\">\n     <![CDATA[select * from `inventory_fact_1997` as `FOOBAR`]]>\n    </SQL>\n    <SQL dialect=\"infobright\">\n     <![CDATA[select * from `inventory_fact_1997` as `FOOBAR`]]>\n    </SQL>\n  </View>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Dimension name=\"Warehouse\" foreignKey=\"warehouse_id\">\n    <Hierarchy hasAll=\"false\" defaultMember=\"[USA]\" primaryKey=\"warehouse_id\"> \n      <Table name=\"warehouse\"/>\n      <Level name=\"Country\" column=\"warehouse_country\" uniqueMembers=\"true\"/>\n      <Level name=\"State Province\" column=\"warehouse_state_province\"\n          uniqueMembers=\"true\"/>\n      <Level name=\"City\" column=\"warehouse_city\" uniqueMembers=\"false\"/>\n      <Level name=\"Warehouse Name\" column=\"warehouse_name\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Warehouse Cost\" column=\"warehouse_cost\" aggregator=\"sum\"/>\n  <Measure name=\"Warehouse Sales\" column=\"warehouse_sales\" aggregator=\"sum\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select\n {[Time].[1997], [Time].[1997].[Q3]} on columns,\n {[Store].[USA].Children} on rows\nFrom [Warehouse (based on view)]\nwhere [Warehouse].[USA]", SchemaTest.fold("Axis #0:\n{[Warehouse].[USA]}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1997].[Q3]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 25,789.086\nRow #0: 8,624.791\nRow #1: 17,606.904\nRow #1: 3,812.023\nRow #2: 45,647.262\nRow #2: 12,664.162\n"));
    }

    public void testViewFactTable2() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Store2\">\n  <View alias=\"FACT\">\n    <SQL dialect=\"generic\">\n     <![CDATA[select * from \"store\" as \"FOOBAR\"]]>\n    </SQL>\n    <SQL dialect=\"oracle\">\n     <![CDATA[select * from \"store\" \"FOOBAR\"]]>\n    </SQL>\n    <SQL dialect=\"mysql\">\n     <![CDATA[select * from `store` as `FOOBAR`]]>\n    </SQL>\n    <SQL dialect=\"infobright\">\n     <![CDATA[select * from `store` as `FOOBAR`]]>\n    </SQL>\n  </View>\n  <!-- We could have used the shared dimension \"Store Type\", but we\n     want to test private dimensions without primary key. -->\n  <Dimension name=\"Store Type\">\n    <Hierarchy hasAll=\"true\">\n      <Level name=\"Store Type\" column=\"store_type\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n\n  <Measure name=\"Store Sqft\" column=\"store_sqft\" aggregator=\"sum\"\n      formatString=\"#,###\"/>\n  <Measure name=\"Grocery Sqft\" column=\"grocery_sqft\" aggregator=\"sum\"\n      formatString=\"#,###\"/>\n\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Store Type].Children} on columns from [Store2]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store Type].[All Store Types].[Deluxe Supermarket]}\n{[Store Type].[All Store Types].[Gourmet Supermarket]}\n{[Store Type].[All Store Types].[HeadQuarters]}\n{[Store Type].[All Store Types].[Mid-Size Grocery]}\n{[Store Type].[All Store Types].[Small Grocery]}\n{[Store Type].[All Store Types].[Supermarket]}\nRow #0: 146,045\nRow #0: 47,447\nRow #0: \nRow #0: 109,343\nRow #0: 75,281\nRow #0: 193,480\n"));
    }

    public void testDeprecatedDistinctCountAggregator() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", null, "  <Measure name=\"Customer Count2\" column=\"customer_id\"\n      aggregator=\"distinct count\" formatString=\"#,###\"/>\n  <CalculatedMember\n      name=\"Half Customer Count\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\"[Measures].[Customer Count2] / 2\">\n  </CalculatedMember>");
        testContext.assertQueryReturns("select {[Measures].[Unit Sales],    [Measures].[Customer Count],     [Measures].[Customer Count2],     [Measures].[Half Customer Count]} on 0,\n {[Store].[USA].Children} ON 1\nFROM [Sales]\nWHERE ([Gender].[M])", SchemaTest.fold("Axis #0:\n{[Gender].[All Gender].[M]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Customer Count]}\n{[Measures].[Customer Count2]}\n{[Measures].[Half Customer Count]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 37,989\nRow #0: 1,389\nRow #0: 1,389\nRow #0: 695\nRow #1: 34,623\nRow #1: 536\nRow #1: 536\nRow #1: 268\nRow #2: 62,603\nRow #2: 901\nRow #2: 901\nRow #2: 451\n"));
    }

    public void testInvalidAggregator() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", null, "  <Measure name=\"Customer Count3\" column=\"customer_id\"\n      aggregator=\"invalidAggregator\" formatString=\"#,###\"/>\n  <CalculatedMember\n      name=\"Half Customer Count\"\n      dimension=\"Measures\"\n      visible=\"false\"\n      formula=\"[Measures].[Customer Count2] / 2\">\n  </CalculatedMember>");
        testContext.assertThrows("select from [Sales]", "Unknown aggregator 'invalidAggregator'; valid aggregators are: 'sum', 'count', 'min', 'max', 'avg', 'distinct-count'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknownUsages() {
        if (!MondrianProperties.instance().ReadAggregates.get()) {
            return;
        }
        Logger logger = Logger.getLogger(AggTableManager.class);
        StringWriter sw = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)new SimpleLayout(), (Writer)sw);
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.WARN);
        appender.addFilter((Filter)filter);
        logger.addAppender((Appender)appender);
        try {
            TestContext testContext = TestContext.create("<?xml version=\"1.0\"?>\n<Schema name=\"FoodMart\">\n<Cube name=\"Sales Degen\">\n  <Table name=\"sales_fact_1997\">\n    <AggExclude pattern=\"agg_c_14_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_l_05_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_g_ms_pcat_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_ll_01_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_c_special_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_l_03_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_l_04_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_pl_01_sales_fact_1997\"/>\n    <AggName name=\"agg_c_10_sales_fact_1997\">\n      <AggFactCount column=\"fact_count\"/>\n      <AggMeasure name=\"[Measures].[Store Cost]\" column=\"store_cost\" />\n      <AggMeasure name=\"[Measures].[Store Sales]\" column=\"store_sales\" />\n     </AggName>\n  </Table>\n  <Dimension name=\"Time\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Quarter\" column=\"quarter\" uniqueMembers=\"false\"\n          levelType=\"TimeQuarters\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Time Degenerate\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"time_id\">\n      <Level name=\"day\" column=\"time_id\"/>\n      <Level name=\"month\" column=\"product_id\" type=\"Numeric\"/>\n    </Hierarchy>  </Dimension>  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>\n</Schema>");
            testContext.assertQueryReturns("select from [Sales Degen]", SchemaTest.fold("Axis #0:\n{}\n225,627.23"));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
        SchemaTest.assertEquals((String)SchemaTest.fold("WARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_c_10_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'customer_count' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_c_10_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'month_of_year' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_c_10_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'quarter' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_c_10_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'the_year' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_c_10_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'unit_sales' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_lc_100_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'customer_id' with unknown usage.\nWARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_lc_100_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'unit_sales' with unknown usage.\n"), (String)sw.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnknownUsages1() {
        if (!MondrianProperties.instance().ReadAggregates.get()) {
            return;
        }
        Logger logger = Logger.getLogger(AggTableManager.class);
        StringWriter sw = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)new SimpleLayout(), (Writer)sw);
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.WARN);
        appender.addFilter((Filter)filter);
        logger.addAppender((Appender)appender);
        try {
            TestContext testContext = TestContext.create("<?xml version=\"1.0\"?>\n<Schema name=\"FoodMart\">\n<Cube name=\"Denormalized Sales\">\n  <Table name=\"sales_fact_1997\">\n    <AggExclude pattern=\"agg_c_14_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_l_05_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_g_ms_pcat_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_ll_01_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_c_special_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_l_04_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_pl_01_sales_fact_1997\"/>\n    <AggExclude pattern=\"agg_c_10_sales_fact_1997\"/>\n    <AggName name=\"agg_l_03_sales_fact_1997\">\n      <AggFactCount column=\"fact_count\"/>\n      <AggMeasure name=\"[Measures].[Store Cost]\" column=\"store_cost\" />\n      <AggMeasure name=\"[Measures].[Store Sales]\" column=\"store_sales\" />\n      <AggMeasure name=\"[Measures].[Unit Sales]\" column=\"unit_sales\" />\n      <AggLevel name=\"[Customer].[Customer ID]\" column=\"customer_id\" />\n      <AggForeignKey factColumn=\"time_id\" aggColumn=\"time_id\" />\n     </AggName>\n  </Table>\n  <Dimension name=\"Time\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Quarter\" column=\"quarter\" uniqueMembers=\"false\"\n          levelType=\"TimeQuarters\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Customer\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n      <Level name=\"Customer ID\" column=\"customer_id\"/>\n    </Hierarchy>  </Dimension>  <Dimension name=\"Product\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"product_id\">\n      <Level name=\"Product ID\" column=\"product_id\"/>\n    </Hierarchy>  </Dimension>  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"#,###\"/>\n</Cube>\n</Schema>");
            testContext.assertQueryReturns("select from [Denormalized Sales]", SchemaTest.fold("Axis #0:\n{}\n225,627.23"));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
        SchemaTest.assertEquals((String)SchemaTest.fold("WARN - Recognizer.checkUnusedColumns: Candidate aggregate table 'agg_l_03_sales_fact_1997' for fact table 'sales_fact_1997' has a column 'time_id' with unknown usage.\n"), (String)sw.toString());
    }

    public void testBug1578545() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales2\" defaultMeasure=\"Unit Sales\">  <Table name=\"sales_fact_1997\">\n  </Table>\n  <DimensionUsage name=\"Time\" source=\"Time\" foreignKey=\"time_id\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"\n      formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        String expected = SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n");
        testContext.assertQueryReturns("select {[Measures]} on 0 from [Sales2]", expected);
        testContext.assertQueryReturns("select {[Measures]} on 0 from [Sales]", expected);
    }

    public void testBug1746362() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Store2\" foreignKey=\"store_id\">\n    <Hierarchy name=\"Store2\" hasAll=\"true\" allMemberName=\"All Stores\" primaryKey=\"store_id\">\n      <Table name=\"store_ragged\"/>\n      <Level name=\"Store2\" table=\"store_ragged\" column=\"store_id\" captionColumn=\"store_name\" uniqueMembers=\"true\">\n           <Property name=\"Store Type\" column=\"store_type\"/>           <Property name=\"Store Manager\" column=\"store_manager\"/>     </Level>    </Hierarchy>\n  </Dimension>\n");
        testContext.assertQueryReturns("WITH\n   MEMBER [Measures].[StoreType] AS \n   '[Store2].CurrentMember.Properties(\"Store Type\")'\nSELECT\n   NonEmptyCrossJoin({[Store2].[All Stores].children}, {[Product].[All Products]}) ON ROWS,\n   { [Measures].[Store Sales], [Measures].[StoreType]} ON COLUMNS\nFROM Sales", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[StoreType]}\nAxis #2:\n{[Store2].[All Stores].[2], [Product].[All Products]}\n{[Store2].[All Stores].[3], [Product].[All Products]}\n{[Store2].[All Stores].[6], [Product].[All Products]}\n{[Store2].[All Stores].[7], [Product].[All Products]}\n{[Store2].[All Stores].[11], [Product].[All Products]}\n{[Store2].[All Stores].[13], [Product].[All Products]}\n{[Store2].[All Stores].[14], [Product].[All Products]}\n{[Store2].[All Stores].[15], [Product].[All Products]}\n{[Store2].[All Stores].[16], [Product].[All Products]}\n{[Store2].[All Stores].[17], [Product].[All Products]}\n{[Store2].[All Stores].[22], [Product].[All Products]}\n{[Store2].[All Stores].[23], [Product].[All Products]}\n{[Store2].[All Stores].[24], [Product].[All Products]}\nRow #0: 4,739.23\nRow #0: Small Grocery\nRow #1: 52,896.30\nRow #1: Supermarket\nRow #2: 45,750.24\nRow #2: Gourmet Supermarket\nRow #3: 54,545.28\nRow #3: Supermarket\nRow #4: 55,058.79\nRow #4: Supermarket\nRow #5: 87,218.28\nRow #5: Deluxe Supermarket\nRow #6: 4,441.18\nRow #6: Small Grocery\nRow #7: 52,644.07\nRow #7: Supermarket\nRow #8: 49,634.46\nRow #8: Supermarket\nRow #9: 74,843.96\nRow #9: Deluxe Supermarket\nRow #10: 4,705.97\nRow #10: Small Grocery\nRow #11: 24,329.23\nRow #11: Mid-Size Grocery\nRow #12: 54,431.14\nRow #12: Supermarket\n"));
    }

    public void testCubeWithOneDimensionOneMeasure() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"OneDim\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Promotion Media\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Media\" primaryKey=\"promotion_id\" defaultMember=\"All Media\">\n      <Table name=\"promotion\"/>\n      <Level name=\"Media Type\" column=\"media_type\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Promotion Media]} on columns from [OneDim]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Promotion Media].[All Media]}\nRow #0: 266,773\n"));
    }

    public void testCubeWithOneDimensionUsageOneMeasure() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"OneDimUsage\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Product].Children} on columns from [OneDimUsage]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 24,597\nRow #0: 191,940\nRow #0: 50,236\n"));
    }

    public void testCubeHasFact() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Cube with caption\" caption=\"Cube with name\"/>\n", null, null, null, null);
        Throwable throwable = null;
        try {
            testContext.assertSimpleQuery();
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, "Must specify fact table of cube 'Cube with caption'");
    }

    public void testCubeCaption() throws SQLException {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Cube with caption\" caption=\"Cube with name\">  <Table name='sales_fact_1997'/></Cube>\n", "<VirtualCube name=\"Warehouse and Sales with caption\"  caption=\"Warehouse and Sales with name\" defaultMeasure=\"Store Sales\">\n  <VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n</VirtualCube>", null, null, null);
        NamedList cubes = testContext.getOlap4jConnection().getSchema().getCubes();
        Cube cube = (Cube)cubes.get("Cube with caption");
        SchemaTest.assertEquals((String)"Cube with name", (String)cube.getCaption(null));
        Cube cube2 = (Cube)cubes.get("Warehouse and Sales with caption");
        SchemaTest.assertEquals((String)"Warehouse and Sales with name", (String)cube2.getCaption(null));
    }

    public void testCubeWithNoDimensions() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"NoDim\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select {[Measures].[Unit Sales]} on columns from [NoDim]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"));
    }

    public void testCubeWithNoMeasuresFails() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"NoMeasures\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Promotion Media\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Media\" primaryKey=\"promotion_id\" defaultMember=\"All Media\">\n      <Table name=\"promotion\"/>\n      <Level name=\"Media Type\" column=\"media_type\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n</Cube>", null, null, null, null);
        testContext.assertThrows("select {[Promotion Media]} on columns from [NoMeasures]", "Hierarchy '[Measures]' is invalid (has no members)");
    }

    public void testCubeWithOneCalcMeasure() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"OneCalcMeasure\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Promotion Media\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Media\" primaryKey=\"promotion_id\" defaultMember=\"All Media\">\n      <Table name=\"promotion\"/>\n      <Level name=\"Media Type\" column=\"media_type\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <CalculatedMember\n      name=\"One\"\n      dimension=\"Measures\"\n      formula=\"1\"/>\n</Cube>", null, null, null, null);
        testContext.assertThrows("select {[Measures]} on columns from [OneCalcMeasure] where [Promotion Media].[TV]", "Hierarchy '[Measures]' is invalid (has no members)");
    }

    public void testAggTableSupportOfSharedDims() {
    }

    public void testLevelTableAttributeAsView() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"GenderCube\">\n  <Table name=\"sales_fact_1997\" alias=\"sales_fact_1997_gender\"/>\n<Dimension name=\"Gender2\" foreignKey=\"customer_id\">\n  <Hierarchy hasAll=\"true\" allMemberName=\"All Gender\" primaryKey=\"customer_id\">\n    <View alias=\"gender2\">\n      <SQL dialect=\"generic\">\n        <![CDATA[SELECT * FROM customer]]>\n      </SQL>\n      <SQL dialect=\"oracle\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"derby\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"luciddb\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"netezza\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n      <SQL dialect=\"db2\">\n        <![CDATA[SELECT * FROM \"customer\"]]>\n      </SQL>\n    </View>\n    <Level name=\"Gender\" table=\"gender2\" column=\"gender\" uniqueMembers=\"true\"/>\n  </Hierarchy>\n</Dimension>  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>", null, null, null, null);
        if (!testContext.getDialect().allowsFromQuery()) {
            return;
        }
        Result result = testContext.executeQuery("select {[Gender2].members} on columns from [GenderCube]");
        TestContext.assertEqualsVerbose(TestContext.toString(result.getAxes()[0].getPositions()), SchemaTest.fold("[Gender2].[All Gender]\n[Gender2].[All Gender].[F]\n[Gender2].[All Gender].[M]"));
    }

    public void testInvalidSchemaAccess() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"invalid\"/>\n</Role>").withRole("Role1");
        testContext.assertThrows("select from [Sales]", "In Schema: In Role: In SchemaGrant: Value 'invalid' of attribute 'access' has illegal value 'invalid'.  Legal values: {all, custom, none, all_dimensions}");
    }

    public void testAllMemberNoStringReplace() {
        TestContext testContext = TestContext.create(null, "<Cube name=\"Sales Special Time\">\n  <Table name=\"sales_fact_1997\"/>\n<Dimension name=\"TIME\" foreignKey=\"time_id\" type=\"TimeDimension\"><Hierarchy name=\"CALENDAR\" hasAll=\"true\" allMemberName=\"All TIME(CALENDAR)\" primaryKey=\"time_id\">  <Table name=\"time_by_day\"/>  <Level name=\"Years\" column=\"the_year\" uniqueMembers=\"true\" levelType=\"TimeYears\"/>  <Level name=\"Quarters\" column=\"quarter\" uniqueMembers=\"false\" levelType=\"TimeQuarters\"/>  <Level name=\"Months\" column=\"month_of_year\" uniqueMembers=\"false\" levelType=\"TimeMonths\"/></Hierarchy></Dimension>  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"    formatString=\"Standard\"/>\n  <Measure name=\"Store Cost\" column=\"store_cost\" aggregator=\"sum\"   formatString=\"#,###.00\"/>\n</Cube>", null, null, null, null);
        testContext.assertQueryReturns("select [TIME.CALENDAR].[All TIME(CALENDAR)] on columns\nfrom [Sales Special Time]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[TIME].[CALENDAR].[All TIME(CALENDAR)]}\nRow #0: 266,773\n"));
    }

    public void testUnionRole() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"all\"/>\n</Role>\n<Role name=\"Role2\">\n  <SchemaGrant access=\"all\"/>\n</Role>\n<Role name=\"Role1Plus2\">\n  <Union>\n    <RoleUsage roleName=\"Role1\"/>\n    <RoleUsage roleName=\"Role2\"/>\n  </Union>\n</Role>\n<Role name=\"Role1Plus2Plus1\">\n  <Union>\n    <RoleUsage roleName=\"Role1Plus2\"/>\n    <RoleUsage roleName=\"Role1\"/>\n  </Union>\n</Role>\n").withRole("Role1Plus2Plus1");
        testContext.assertQueryReturns("select from [Sales]", SchemaTest.fold("Axis #0:\n{}\n266,773"));
    }

    public void testUnionRoleContainsGrants() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"all\"/>\n</Role>\n<Role name=\"Role1Plus2\">\n  <SchemaGrant access=\"all\"/>\n  <Union>\n    <RoleUsage roleName=\"Role1\"/>\n    <RoleUsage roleName=\"Role1\"/>\n  </Union>\n</Role>\n").withRole("Role1Plus2");
        testContext.assertThrows("select from [Sales]", "Union role must not contain grants");
    }

    public void testUnionRoleIllegalForwardRef() {
        TestContext testContext = TestContext.create(null, null, null, null, null, "<Role name=\"Role1\">\n  <SchemaGrant access=\"all\"/>\n</Role>\n<Role name=\"Role1Plus2\">\n  <Union>\n    <RoleUsage roleName=\"Role1\"/>\n    <RoleUsage roleName=\"Role2\"/>\n  </Union>\n</Role>\n<Role name=\"Role2\">\n  <SchemaGrant access=\"all\"/>\n</Role>").withRole("Role1Plus2");
        testContext.assertThrows("select from [Sales]", "Unknown role 'Role2'");
    }

    public void testVirtualCubeNamedSetSupportInSchema() {
        TestContext testContext = TestContext.createSubstitutingCube("Warehouse and Sales", null, null, "<NamedSet name=\"Non CA State Stores\" formula=\"EXCEPT({[Store].[Store Country].[USA].children},{[Store].[Store Country].[USA].[CA]})\"/>");
        testContext.assertQueryReturns("WITH SET [Non CA State Stores] AS 'EXCEPT({[Store].[Store Country].[USA].children},{[Store].[Store Country].[USA].[CA]})'\nMEMBER [Store].[Total Non CA State] AS \n'SUM({[Non CA State Stores]})'\nSELECT {[Store].[Store Country].[USA],[Store].[Total Non CA State]} ON 0,{[Measures].[Unit Sales]} ON 1 FROM [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[Total Non CA State]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\nRow #0: 192,025\n"));
        testContext.assertQueryReturns("WITH MEMBER [Store].[Total Non CA State] AS \n'SUM({[Non CA State Stores]})'\nSELECT {[Store].[Store Country].[USA],[Store].[Total Non CA State]} ON 0,{[Measures].[Unit Sales]} ON 1 FROM [Warehouse and Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[Total Non CA State]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\nRow #0: 192,025\n"));
    }

    public void testVirtualCubeNamedSetSupportInSchemaError() {
        TestContext testContext = TestContext.createSubstitutingCube("Warehouse and Sales", null, null, "<NamedSet name=\"Non CA State Stores\" formula=\"EXCEPT({[Store].[Store State].[USA].children},{[Store].[Store Country].[USA].[CA]})\"/>");
        try {
            testContext.assertQueryReturns("WITH SET [Non CA State Stores] AS 'EXCEPT({[Store].[Store Country].[USA].children},{[Store].[Store Country].[USA].[CA]})'\nMEMBER [Store].[Total Non CA State] AS \n'SUM({[Non CA State Stores]})'\nSELECT {[Store].[Store Country].[USA],[Store].[Total Non CA State]} ON 0,{[Measures].[Unit Sales]} ON 1 FROM [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\n{[Store].[Total Non CA State]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\nRow #0: 192,025\n"));
            SchemaTest.fail();
        }
        catch (MondrianException e) {
            SchemaTest.assertTrue((e.getMessage().indexOf("bad formula") >= 0 ? 1 : 0) != 0);
        }
    }

    public void _testValidatorFindsNumericLevel() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Store Size in SQFT\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n      <Table name=\"store\"/>\n      <Level name=\"Store Sqft\" column=\"store_sqft\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>");
        List<Exception> exceptionList = testContext.getSchemaWarnings();
        this.assertContains(exceptionList, "todo xxxxx");
    }

    public void testInvalidRoleError() {
        String schema = TestContext.getRawFoodMartSchema();
        schema = schema.replaceFirst("<Schema name=\"FoodMart\"", "<Schema name=\"FoodMart\" defaultRole=\"Unknown\"");
        TestContext testContext = TestContext.create(schema);
        List<Exception> exceptionList = testContext.getSchemaWarnings();
        this.assertContains(exceptionList, "Role 'Unknown' not found");
    }

    public void testBinaryLevelKey() {
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case DERBY: 
            case MYSQL: {
                break;
            }
            default: {
                return;
            }
        }
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Binary\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"id\">\n      <InlineTable alias=\"binary\">\n        <ColumnDefs>\n          <ColumnDef name=\"id\" type=\"Integer\"/>\n          <ColumnDef name=\"bin\" type=\"Integer\"/>\n          <ColumnDef name=\"name\" type=\"String\"/>\n        </ColumnDefs>\n        <Rows>\n          <Row>\n            <Value column=\"id\">2</Value>\n            <Value column=\"bin\">X'4546'</Value>\n            <Value column=\"name\">Ben</Value>\n          </Row>\n          <Row>\n            <Value column=\"id\">3</Value>\n            <Value column=\"bin\">X'424344'</Value>\n            <Value column=\"name\">Bill</Value>\n          </Row>\n          <Row>\n            <Value column=\"id\">4</Value>\n            <Value column=\"bin\">X'424344'</Value>\n            <Value column=\"name\">Bill</Value>\n          </Row>\n        </Rows>\n      </InlineTable>\n      <Level name=\"Level1\" column=\"bin\" nameColumn=\"name\" ordinalColumn=\"name\" />\n      <Level name=\"Level2\" column=\"id\"/>\n    </Hierarchy>\n  </Dimension>\n");
        testContext.assertQueryReturns("select {[Binary].members} on 0 from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Binary].[Ben]}\n{[Binary].[Ben].[2]}\n{[Binary].[Bill]}\n{[Binary].[Bill].[3]}\n{[Binary].[Bill].[4]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \n"));
        testContext.assertQueryReturns("select hierarchize({[Binary].members}) on 0 from [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Binary].[Ben]}\n{[Binary].[Ben].[2]}\n{[Binary].[Bill]}\n{[Binary].[Bill].[3]}\n{[Binary].[Bill].[4]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \n"));
    }

    public void _testAttributeHierarchy() {
        this.assertQueryReturns("WITH \n MEMBER\n  Measures.SalesPerWorkingDay AS \n    IIF(\n     Count(\n      Filter(\n        Descendants(\n          [Date].[Calendar].CurrentMember\n          ,[Date].[Calendar].[Date]\n          ,SELF)\n       ,  [Date].[Day of Week].CurrentMember.Name <> \"1\"\n      )\n    ) = 0\n     ,NULL\n     ,[Measures].[Internet Sales Amount]\n      /\n       Count(\n         Filter(\n           Descendants(\n             [Date].[Calendar].CurrentMember\n             ,[Date].[Calendar].[Date]\n             ,SELF)\n          ,  [Date].[Day of Week].CurrentMember.Name <> \"1\"\n         )\n       )\n    )\n   '\nSELECT [Measures].[SalesPerWorkingDay]  ON 0\n, [Date].[Calendar].[Month].MEMBERS ON 1\nFROM [Adventure Works]", "x");
    }

    public void testScdJoin() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Product truncated\" foreignKey=\"product_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Class\" table=\"product_class\" nameColumn=\"product_subcategory\"\n          column=\"product_class_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n", null, null);
        testContext.assertQueryReturns("select non empty {[Measures].[Unit Sales]} on 0,\n non empty Filter({[Product truncated].Members}, [Measures].[Unit Sales] > 10000) on 1\nfrom [Sales]", SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product truncated].[All Product truncateds]}\n{[Product truncated].[All Product truncateds].[Fresh Vegetables]}\n{[Product truncated].[All Product truncateds].[Fresh Fruit]}\nRow #0: 266,773\nRow #1: 20,739\nRow #2: 11,767\n"));
    }

    public void _testNonUniqueAlias() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Product truncated\" foreignKey=\"product_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\" alias=\"product_class\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Class\" table=\"product_class\" nameColumn=\"product_subcategory\"\n          column=\"product_class_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n", null, null);
        Throwable throwable = null;
        try {
            testContext.assertSimpleQuery();
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, "Alias not unique");
    }

    public void testBug2384825() {
        if (TestContext.instance().getDialect().getDatabaseProduct() != Dialect.DatabaseProduct.MYSQL) {
            return;
        }
        String salesCube1 = "<Cube name=\"Sales2\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\" >\n    <SQL dialect=\"default\">\n     <![CDATA[`sales_fact_1997`.`store_id` in (select distinct `store_id` from `store` where `store`.`store_state` = \"CA\")]]>\n    </SQL>\n  </Table>\n  <DimensionUsage name=\"Store\" source=\"Store\" foreignKey=\"store_id\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n  <Measure name=\"Store Sales\" column=\"store_sales\" aggregator=\"sum\" formatString=\"Standard\"/>\n</Cube>\n";
        TestContext testContext = TestContext.create(null, salesCube1, null, null, null, null);
        String query1 = "WITH SET [#DataSet#] as 'NonEmptyCrossjoin({[Product].[All Products]}, {[Store].[All Stores].[USA].Children})' SELECT {[Measures].[Unit Sales]} on columns, NON EMPTY Hierarchize({[#DataSet#]}) on rows FROM [Sales2]";
        testContext.assertQueryReturns(query1, SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products], [Store].[All Stores].[USA].[CA]}\nRow #0: 74,748\n"));
        String query2 = "WITH SET [#DataSet#] as '{Descendants([Store].[All Stores], 3)}' SELECT {[Measures].[Unit Sales]} on columns, NON EMPTY Hierarchize({[#DataSet#]}) on rows FROM [Sales2]";
        testContext.assertQueryReturns(query2, SchemaTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles]}\n{[Store].[All Stores].[USA].[CA].[San Diego]}\n{[Store].[All Stores].[USA].[CA].[San Francisco]}\nRow #0: 21,333\nRow #1: 25,663\nRow #2: 25,635\nRow #3: 2,117\n"));
    }
}

