/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Set;
import junit.framework.Assert;
import mondrian.olap.Connection;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import org.eigenbase.util.property.Property;

public class ParameterTest
extends FoodMartTestCase {
    public ParameterTest(String name) {
        super(name);
    }

    private void assertSetPropertyFails(String propName, String scope) {
        Query q = this.getConnection().parseQuery("select from [Sales]");
        try {
            q.setParameter(propName, "foo");
            ParameterTest.fail((String)("expected exception, trying to set non-overrideable property '" + propName + "'"));
        }
        catch (Exception e) {
            ParameterTest.assertTrue((e.getMessage().indexOf("Parameter '" + propName + "' (defined at '" + scope + "' scope) is not modifiable") >= 0 ? 1 : 0) != 0);
        }
    }

    public void testChangeable() {
        String mdx = "select {Parameter(\"Foo\",[Time],[Time].[1997],\"Foo\")} ON COLUMNS from [Sales]";
        Query query = this.getConnection().parseQuery(mdx);
        SchemaReader sr = query.getSchemaReader(false);
        Member m = sr.getMemberByUniqueName(Id.Segment.toList("Time", "1997", "Q2", "5"), true);
        Parameter p = sr.getParameter("Foo");
        p.setValue(m);
        ParameterTest.assertEquals((Object)m, (Object)p.getValue());
        query.resolve();
        p.setValue(m);
        ParameterTest.assertEquals((Object)m, (Object)p.getValue());
        mdx = query.toString();
        ParameterTest.assertEquals((String)("select {Parameter(\"Foo\", [Time], [Time].[1997].[Q2].[5], \"Foo\")} ON COLUMNS" + nl + "from [Sales]" + nl), (String)mdx);
    }

    public void testParameterInFormatString() {
        this.assertQueryReturns("with member [Measures].[X] as '[Measures].[Store Sales]'," + nl + "format_string = Parameter(\"fmtstrpara\", STRING, \"#\")" + nl + "select {[Measures].[X]} ON COLUMNS" + nl + "from [Sales]", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Measures].[X]}" + nl + "Row #0: 565238" + nl);
    }

    public void testParameterInFormatString_Bug1584439() {
        String queryString = "with member [Measures].[X] as '[Measures].[Store Sales]'," + nl + "format_string = Parameter(\"fmtstrpara\", STRING, \"#\")" + nl + "select {[Measures].[X]} ON COLUMNS" + nl + "from [Sales]";
        Connection connection = this.getConnection();
        Query query = connection.parseQuery(queryString);
        query.toString();
    }

    public void testParameterOnAxis() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on rows," + nl + " {Parameter(\"GenderParam\",[Gender],[Gender].[M],\"Which gender?\")} on columns" + nl + "from Sales", "Axis #0:" + nl + "{}" + nl + "Axis #1:" + nl + "{[Gender].[All Gender].[M]}" + nl + "Axis #2:" + nl + "{[Measures].[Unit Sales]}" + nl + "Row #0: 135,215" + nl);
    }

    public void testNumericParameter() {
        String s = this.executeExpr("Parameter(\"N\",NUMERIC,2+3,\"A numeric parameter\")");
        Assert.assertEquals((String)"5", (String)s);
    }

    public void testStringParameter() {
        String s = this.executeExpr("Parameter(\"S\",STRING,\"x\" || \"y\",\"A string parameter\")");
        Assert.assertEquals((String)"xy", (String)s);
    }

    public void testNumericParameterStringValueFails() {
        this.assertExprThrows("Parameter(\"S\",NUMERIC,\"x\" || \"y\",\"A string parameter\")", "Default value of parameter 'S' is inconsistent with its type, NUMERIC");
    }

    public void testParameterDimension() {
        this.assertExprReturns("Parameter(\"Foo\",[Time],[Time].[1997],\"Foo\").Name", "1997");
        this.assertExprReturns("Parameter(\"Foo\",[Time],[Time].[1997].[Q2].[5],\"Foo\").Name", "5");
        this.assertExprThrows("Parameter(\"Foo\",[Time],[Product].[All Products],\"Foo\").Name", "Default value of parameter 'Foo' is not consistent with the parameter type 'MemberType<dimension=[Time]>");
        this.assertExprThrows("Parameter(\"Foo\",[Time],[Time].[1997].[Q5],\"Foo\").Name", "MDX object '[Time].[1997].[Q5]' not found in cube 'Sales'");
    }

    public void testParameterHierarchy() {
        this.assertExprReturns("Parameter(\"Foo\", [Time.Weekly], [Time.Weekly].[1997].[40],\"Foo\").Name", "40");
        String levelName = MondrianProperties.instance().SsasCompatibleNaming.get() ? "[Time].[Weekly]" : "[Time.Weekly]";
        this.assertExprThrows("Parameter(\"Foo\",[Time.Weekly],[Time].[1997].[Q1],\"Foo\").Name", "Default value of parameter 'Foo' is not consistent with the parameter type 'MemberType<hierarchy=" + levelName + ">");
        this.assertExprThrows("Parameter(\"Foo\",[Time.Weekly],[Product].[All Products],\"Foo\").Name", "Default value of parameter 'Foo' is not consistent with the parameter type 'MemberType<hierarchy=" + levelName + ">");
        this.assertExprThrows("Parameter(\"Foo\",[Time.Weekly],[Widget].[All Widgets],\"Foo\").Name", "MDX object '[Widget].[All Widgets]' not found in cube 'Sales'");
    }

    public void testParameterLevel() {
        this.assertExprReturns("Parameter(\"Foo\",[Time].[Quarter], [Time].[1997].[Q3], \"Foo\").Name", "Q3");
        this.assertExprThrows("Parameter(\"Foo\",[Time].[Quarter], [Time].[1997].[Q3].[8], \"Foo\").Name", "Default value of parameter 'Foo' is not consistent with the parameter type 'MemberType<level=[Time].[Quarter]>");
    }

    public void testParameterMemberFails() {
        this.assertExprThrows("Parameter(\"Foo\",[Time].[1997].[Q2],[Time].[1997],\"Foo\")", "Invalid type for parameter 'Foo'; expecting NUMERIC, STRING or a hierarchy");
    }

    public void testParameterWithExpressionForHierarchyFails() {
        this.assertExprThrows("Parameter(\"Foo\",[Gender].DefaultMember.Hierarchy,[Gender].[M],\"Foo\")", "Invalid parameter 'Foo'. Type must be a NUMERIC, STRING, or a dimension, hierarchy or level");
    }

    public void _testDerivedParameterFails() {
        this.assertExprThrows("Parameter(\"X\",NUMERIC,Parameter(\"Y\",NUMERIC,1)+2)", "Parameter may not be derived from another parameter");
    }

    public void testParameterInSlicer() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on rows," + nl + " {[Marital Status].children} on columns" + nl + "from Sales where Parameter(\"GenderParam\",[Gender],[Gender].[M],\"Which gender?\")", "Axis #0:" + nl + "{[Gender].[All Gender].[M]}" + nl + "Axis #1:" + nl + "{[Marital Status].[All Marital Status].[M]}" + nl + "{[Marital Status].[All Marital Status].[S]}" + nl + "Axis #2:" + nl + "{[Measures].[Unit Sales]}" + nl + "Row #0: 66,460" + nl + "Row #0: 68,755" + nl);
    }

    public void _testParameterDuplicateDimensionFails() {
        this.assertThrows("select {[Measures].[Unit Sales]} on rows," + nl + " {[Gender].[F]} on columns" + nl + "from Sales where Parameter(\"GenderParam\",[Gender],[Gender].[M],\"Which gender?\")", "Invalid hierarchy for parameter 'GenderParam'");
    }

    public void dontTestParamRef() {
        String s = this.executeExpr("Parameter(\"X\",STRING,\"x\",\"A string\") || ParamRef(\"Y\") || \".\" ||ParamRef(\"X\") || Parameter(\"Y\",STRING,\"y\" || \"Y\",\"Other string\")");
        Assert.assertEquals((String)"xyY.xyY", (String)s);
    }

    public void testParamRefWithoutParamFails() {
        this.assertExprThrows("ParamRef(\"Y\")", "Unknown parameter 'Y'");
    }

    public void testParamDefinedTwiceFails() {
        this.assertThrows("select {[Measures].[Unit Sales]} on rows," + nl + " {Parameter(\"P\",[Gender],[Gender].[M],\"Which gender?\")," + nl + "  Parameter(\"P\",[Gender],[Gender].[F],\"Which gender?\")} on columns" + nl + "from Sales", "Parameter 'P' is defined more than once");
    }

    public void testParamBadTypeFails() {
        this.assertExprThrows("Parameter(\"P\", 5)", "No function matches signature 'Parameter(<String>, <Numeric Expression>)'");
    }

    public void testParamCyclicOk() {
        this.assertExprReturns("Parameter(\"P\", NUMERIC, ParamRef(\"Q\") + 1) + Parameter(\"Q\", NUMERIC, Iif(1 = 0, ParamRef(\"P\"), 2))", "5");
    }

    public void testParamCyclicFails() {
        this.assertExprThrows("Parameter(\"P\", NUMERIC, ParamRef(\"Q\") + 1) + Parameter(\"Q\", NUMERIC, Iif(1 = 1, ParamRef(\"P\"), 2))", "Cycle occurred while evaluating parameter 'P'");
    }

    public void testParameterMetadata() {
        Connection connection = this.getConnection();
        Query query = connection.parseQuery("with member [Measures].[A string] as " + nl + "   Parameter(\"S\",STRING,\"x\" || \"y\",\"A string parameter\")" + nl + " member [Measures].[A number] as " + nl + "   Parameter(\"N\",NUMERIC,2+3,\"A numeric parameter\")" + nl + "select {[Measures].[Unit Sales]} on rows," + nl + " {Parameter(\"P\",[Gender],[Gender].[F],\"Which gender?\")," + nl + "  Parameter(\"Q\",[Gender],[Gender].DefaultMember,\"Another gender?\")} on columns" + nl + "from Sales");
        Parameter[] parameters = query.getParameters();
        Assert.assertEquals((int)4, (int)parameters.length);
        Assert.assertEquals((String)"S", (String)parameters[0].getName());
        Assert.assertEquals((String)"N", (String)parameters[1].getName());
        Assert.assertEquals((String)"P", (String)parameters[2].getName());
        Assert.assertEquals((String)"Q", (String)parameters[3].getName());
        Member member = query.getSchemaReader(true).getMemberByUniqueName(Id.Segment.toList("Gender", "M"), true);
        parameters[2].setValue(member);
        Assert.assertEquals((String)("with member [Measures].[A string] as 'Parameter(\"S\", STRING, (\"x\" || \"y\"), \"A string parameter\")'" + nl + "  member [Measures].[A number] as 'Parameter(\"N\", NUMERIC, (2.0 + 3.0), \"A numeric parameter\")'" + nl + "select {Parameter(\"P\", [Gender], [Gender].[All Gender].[M], \"Which gender?\"), Parameter(\"Q\", [Gender], [Gender].DefaultMember, \"Another gender?\")} ON COLUMNS," + nl + "  {[Measures].[Unit Sales]} ON ROWS" + nl + "from [Sales]" + nl), (String)Util.unparse(query));
    }

    public void testTwoParametersBug1425153() {
        Connection connection = this.getTestContext().getConnection();
        Query query = connection.parseQuery("select \n{[Measures].[Unit Sales]} on columns, \n{Parameter(\"ProductMember\", [Product], [Product].[All Products].[Food], \"wat willste?\").children} ON rows \nfrom Sales where Parameter(\"Time\",[Time],[Time].[1997].[Q1])");
        Result result = connection.execute(query);
        String resultString = TestContext.toString(result);
        TestContext.assertEqualsVerbose(ParameterTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Starchy Foods]}\nRow #0: 1,932\nRow #1: 5,045\nRow #2: 820\nRow #3: 4,737\nRow #4: 400\nRow #5: 3,262\nRow #6: 2,985\nRow #7: 918\nRow #8: 6,624\nRow #9: 391\nRow #10: 9,499\nRow #11: 412\nRow #12: 7,750\nRow #13: 1,718\nRow #14: 1,316\n"), resultString);
        query.setParameter("ProductMember", "[Product].[All Products].[Food].[Eggs]");
        result = connection.execute(query);
        resultString = TestContext.toString(result);
        TestContext.assertEqualsVerbose(ParameterTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Eggs].[Eggs]}\nRow #0: 918\n"), resultString);
        query.setParameter("ProductMember", "[Product].[All Products].[Food].[Deli]");
        query.setParameter("Time", "[Time].[1997].[Q2].[4]");
        result = connection.execute(query);
        resultString = TestContext.toString(result);
        TestContext.assertEqualsVerbose(ParameterTest.fold("Axis #0:\n{[Time].[1997].[Q2].[4]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Deli].[Meat]}\n{[Product].[All Products].[Food].[Deli].[Side Dishes]}\nRow #0: 621\nRow #1: 187\n"), resultString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFoo() {
        Connection connection = this.getTestContext().getConnection();
        try {
            String mdx = "with member [Measures].[s] as Parameter(\"x\", NUMERIC, 1) select {[Measures].[s]} on columns, {Time.Children} on rows from [Sales]";
            Query query = connection.parseQuery(mdx);
            query.setParameter("x", "8");
        }
        finally {
            connection.close();
        }
    }

    public void testConnectionPropsWhichShouldBeNull() {
        this.assertExprReturns("ParamRef(\"JdbcPassword\")", "");
        this.assertExprReturns("ParamRef(\"CatalogContent\")", "");
    }

    public void testConnectionPropsCannotBeOverridden() {
        Set overrideableProps = Util.enumSetOf((Enum)RolapConnectionProperties.Catalog, (Enum[])new RolapConnectionProperties[]{RolapConnectionProperties.Locale});
        for (RolapConnectionProperties prop : (RolapConnectionProperties[])RolapConnectionProperties.class.getEnumConstants()) {
            if (overrideableProps.contains((Object)prop)) continue;
            this.assertSetPropertyFails(prop.name(), "Connection");
        }
    }

    public void testSystemPropsGet() {
        for (Property property : MondrianProperties.instance().getPropertyList()) {
            this.assertExprReturns("ParamRef(" + Util.singleQuoteString(property.getPath()) + ")", property.stringValue());
        }
    }

    public void testSystemPropsGetJava() {
        String javaVersion = System.getProperty("java.version");
        this.assertExprReturns("ParamRef(\"java.version\")", javaVersion);
    }

    public void testMondrianPropsGetJava() {
        String jdbcDrivers = MondrianProperties.instance().JdbcDrivers.get();
        this.assertExprReturns("ParamRef(\"mondrian.jdbcDrivers\")", jdbcDrivers);
    }

    public void testSystemPropsSet() {
        for (Property property : MondrianProperties.instance().getPropertyList()) {
            String propName = property.getPath();
            this.assertSetPropertyFails(propName, "System");
        }
    }

    public void testSchemaProp() {
        TestContext tc = TestContext.create("<Parameter name=\"prop\" type=\"String\" defaultValue=\" 'foo bar' \" />", null, null, null, null, null);
        tc.assertExprReturns("ParamRef(\"prop\")", "foo bar");
    }

    public void testSchemaPropDupFails() {
        TestContext tc = TestContext.create("<Parameter name=\"foo\" type=\"Numeric\" defaultValue=\"1\" />\n<Parameter name=\"bar\" type=\"Numeric\" defaultValue=\"2\" />\n<Parameter name=\"foo\" type=\"Numeric\" defaultValue=\"3\" />\n", null, null, null, null, null);
        tc.assertExprThrows("ParamRef(\"foo\")", "Duplicate parameter 'foo' in schema");
    }

    public void testSchemaPropIllegalTypeFails() {
        TestContext tc = TestContext.create("<Parameter name=\"foo\" type=\"Bad type\" defaultValue=\"1\" />", null, null, null, null, null);
        tc.assertExprThrows("1", "In Schema: In Parameter: Value 'Bad type' of attribute 'type' has illegal value 'Bad type'.  Legal values: {String, Numeric, Integer, Boolean, Date, Time, Timestamp, Member}");
    }

    public void testSchemaPropInvalidDefaultExpFails() {
        TestContext tc = TestContext.create("<Parameter name=\"Product Current Member\" type=\"Member\" defaultValue=\"[Product].DefaultMember.Children(2) \" />", null, null, null, null, null);
        tc.assertExprThrows("ParamRef(\"Product Current Member\")", "No function matches signature '<Member>.Children(<Numeric Expression>)'");
    }

    public void testSchemaPropContext() {
        TestContext tc = TestContext.create("<Parameter name=\"Customer Current Member\" type=\"Member\" defaultValue=\"[Customers].DefaultMember.Children.Item(2) \" />", null, null, null, null, null);
        tc.assertQueryReturns("with member [Measures].[Foo] as ' ParamRef(\"Customer Current Member\").Name '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]", ParameterTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: USA\n"));
        tc.assertThrows("with member [Measures].[Foo] as ' ParamRef(\"Customer Current Member\").Name '\nselect {[Measures].[Foo]} on columns\nfrom [Warehouse]", "MDX object '[Customers]' not found in cube 'Warehouse'");
    }
}

